@part(execlib, root "manual.mss")
@Chapter(Control of Executives)

Instances of the V executive, or command interpreter, are normally created
and controlled directly by the user interacting with the system.  However, 
this control is also available to programs through the following functions:

@begin (function)
int CreateExec(execserver, inserver, infile, outserver, outfile,
                  errserver, errfile, cpid, ccid, flags, execpid,
                  error)
    ProcessId execserver;
    ProcessId inserver, outserver, errserver;
    InstanceId infile, outfile, errfile;
    ProcessId cpid;
    ContextId ccid;
    short flags;
    ProcessId  *execpid;
    SystemCode  *error;

@end (function)
Create an instance of the executive with the specified standard input,
standard output, standard error output, and context.  Each of the
three standard i/o files is specified by two parameters, the server
pid and the instance identifier within that server.  This means that
all these instances must be opened before @t[Create Exec] is called.
Context is specified by two parameters, a server pid and a
context identifier relative to the given pid.
The @t[GetContextId]
function will map a context name into such a pair.  @t[Execserver] is
the pid of the exec server to which the request is being made.  The
@t[Flags] parameter determines which if any of the standard i/o
instances are to be owned by the newly created executive; it may be
any combination of RELEASE@us()INPUT,
RELEASE@us()OUTPUT, and RELEASE@us()ERR.  If
for example RELEASE@us()INPUT is specified, the executive will own its
standard input instance and will release it on termination.

@t[CreateExec] returns an exec identifier, a small integer which will
be used to refer to this executive in other executive control
requests.  In the location pointed to by @t[execpid] it returns the
process id of the new executive.  In the location pointed to by error it
returns a system error code; if this code is not OK, the exec
identifier and execpid are meaningless.

WARNING: a server process cannot call @t[CreateExec] with a file
instance pointing to that server itself, or the server and the
execserver will become deadlocked waiting for each other.  A server
that needs to do this should create a subprocess to call
@t[CreateExec.]

@begin(function)
SystemCode DeleteExec(execserver, execid)
    ProcessId execserver;
    int execid;
@end(function)
Delete the executive specified by @t[execid], along with the program
running under it if any. It need not have been created by this
process; there is no concept of ownership of execs.  Note that this is
not the only way executives vanish; they also terminate on end of file
on the standard input. @t[DeleteExec] will return NOT@us()FOUND if
@t[execid] is invalid.

@begin[function]
SystemCode QueryExec(execserver, execid)
    ProcessId execserver;
    int execid;
@end[function]
Inquire about the state of the specified exec.  If successful, it
returns a code of OK, and the following information: in @t[execpid] the
process id of the exec; in @t[program], the process id of the program
running under it, if any; in status, the status of the exec.  Status
can be one of
@begin(description)
EXEC@us()FREE@\Exec is waiting for a command.

EXEC@us()LOADING@\exec is in the process of loading a program.

EXEC@us()RUNNING@\A program is running under this exec.  In this case and
this case only, @t[program] returns relevant information.

EXEC@us()HOLD@\Exec has been created but not yet started.  Hopefully this state
should never be observed, as it is taken care of within
@t[CreateExec.]
@end(description)

@begin(function)
SystemCode KillProgram(execserver, execid)
    ProcessId execserver;
    int execid;
@end(function)
Kill the program, if any, running under the specified exec.  Returns
OK is successful, NOT@us()FOUND if execid was invalid, NONEXISTENT@us()PROCESS
if there was no program running under that exec.

@begin(function)

SystemCode CheckExecs(execserver)
    ProcessId execserver;
@end(function)

Causes the execserver to do a check on all executives.  Any of them
whose standard input server or standard output server (but @i[not]
standard error server) has died is destroyed during the check.  This
should be called after an action that might have destroyed an i/o
server which was providing standard i/o for one or more executives.
