@Part( perform, root "manual" )
@Chapter(Performance)@Label(perform)

Two measures of performance for the kernel are the speed of various
operations and space requirements.
For a detailed account of the performance of the V kernel, we refer the
reader to @i[The Distributed V Kernel and Its Performance on Diskless
Workstations], by David R. Cheriton and Willy Zwaenepoel, in
Proceedings of the 9th Symposium on Operating System Principles,
October 1983 (also available as Technical Report STAN-CS-83-973,
Computer Science Department, Stanford University).

@Section(Space Requirements)
The space requirements are dependent on the machine,
the number and complexity of devices supported,
and the maximum number of processes, teams and devices configured.
Table @Ref(kernelspace) gives the code segment size for the kernel
configured to support distributed operation on the SUN workstation
with support for console device, serial interfaces, Ethernet interface and
a mouse pointing device.
The table also gives
the unit space cost of a process descriptor and a team descriptor,
and the total space requirements for a kernel configured with
a maximum of 64 processes, 16 teams and 16 device descriptors.
All measurements are given in bytes.
@begin(Table)
@Caption(SUN Workstation Kernel Memory Requirements)@Tag(kernelspace)
@TabSet(2 Inches, +1.75 Inches)
@\@ux[Component@>Size in bytes]@\
@\code segment@>31836@\
@\process descriptor@>202@\
@\team descriptor@>18@\
@\device descriptor@>44@\
@\total@>47990@\
@end(Table)

@Section(Kernel Operation Times)
@Index[kernel timings]
Table @Ref(kerneltimes) gives the times for various sequences
of kernel operations
on the SUN workstation using a 10 Megahertz Motorola 68000 processor.
The times for sequences of operations are given instead of times
for individual operations to give a better indication of the kernel
overhead for higher-level operations.
For instance,
the Send-Receive-MoveFrom-Reply sequence is indicative of the time
to perform a file read operation using the I/O protocol.
These sequences are also easier to time in some cases than individual
component operations.
@begin(Table)
@Caption[SUN Workstation Times for Kernel Operations (in milliseconds)]
@Tag(kerneltimes)
@Tabclear
@Tabset( .75 inch, +3.50 inches, +1.50 inches)
@\@ux[@>local@>remote]@\
@\GetTime@>0.06@>Not Applicable@\
@\Send-Receive-Reply(0 bytes)@>0.77@>2.54@\
@\Send-Receive-Reply(512 bytes)@>1.31@>5.56@\
@end(Table)
The table is not intended to be complete but simply indicative of performance.
The Send-Receive-Reply time is indicative of the interprocess communication
time using the kernel.
The column labeled "remote" gives the Send-Receive-Reply time between
two processes resident on different workstations.
The GetTime time is indicative of the cost of a trivial kernel operation.
All other kernel operations can be expected to be faster than
the Send-Receive-Reply sequence.
@Index[Send-Receive-Reply]

Another measure of interest is the speed at which packets can be read
and written over the Ethernet with the overhead of sending read and
@Index[Ethernet performance]
write requests to the kernel device server to access the network.
@Index[device server]
Table @Ref(netoutput) gives performance figures for the kernel running
on the SUN workstation connected to a 3 Megabit Ethernet.
@begin(Table)
@Caption(SUN Workstation Ethernet Output)@Tag(netoutput)
@Tabclear
@Tabset(2.5 in, +1.25 in, +2 in)
@>@ux[Packet Size in bytes@>Packets per sec@>Throughput in Kbytes/sec]@\
@>16@>2200@>35@\
@>512@>360@>180@\
@>1024@>170@>170@\
@end(Table)
Similar throughput figures for a stand-alone Alto are 4, 120 and 140 Kbytes
per sec (approximately).

On the input side,
with one SUN writing as fast as possible to another,
10000 packets of 1024 bytes can be received in 5.89 seconds with
0 packets lost, yielding a throughput of about
170 Kbytes per second, which is about 40% of the bandwidth of the net.
However, for some unknown reason, packets are dropped as the packet
size becomes smaller.

@Section(Interrupt Disable Time)
@Index[interrupt disable time]
The interrupt disable time for the kernel is essentially
the maximum of the time required to insert a record in
a ordered queue (the ready queue) and the time to load
the processor with the state of a new process.
Although the former is dependent on the maximum number of
ready processes, it is typically very small.
For example, on the SUN workstation, adding a lowest priority
process to the ready queue when 32 processes are ready to execute
is estimated to result in an interrupt disable time of
164 microseconds.
Under normal circumstances, an interrupt disable time of about
30 microseconds can be expected.

