@Part( kexceptions, root "manual" )
@Chapter(Exceptions and Kernel Exception Handling)@Label(kexceptions)

The V kernel handles exceptions (such as illegal instruction
@Index[exceptions]
or bus error traps) by forcing the erroneous process to send
a message to the @i[exception server]
@Index[exception server]
containing the details of the error.
The exception server is a process that has registered as the
EXCEPTION@Us()SERVER with the kernel using SetPid.
If no exception server exists,
the message is sent back to the process that caused the error,
blocking it permanently.
In either case,
other processes in the system can continue to run.

The message from the exception-incurring process 
to the exception server
appears as a normal message and can be received by the standard
message primitives.
After receiving the message, the exception server can read the
faulting process's state using either the kernel primitive QueryProcessState
@index[QueryProcessState] or the library function ReadProcessState.
@Index[ReadProcessState]
In the Sun implementation of the kernel, the registers in the state record
reflect the processor state at the time of the exception, unless it occurred
while running in the kernel.
In that case, the program counter and status
register returned are those that were saved at the time the kernel trap was
taken.
The other registers reflect the state at the time of the exception.
The correct program counter and status register contents can always be
obtained from the exception message.

The message also provides read and write access to the segment consisting
of the entire team address space of the exception-incurring process.
This provides debuggers and exception servers with complete access to the
code and data of the process.

The format of the exception message is given by the ExceptionMessage
@Index[ExceptionMessage]
struct in <Vexceptions.h> together with manifest constant definitions
@Index[Vexceptions.h]
for the type of exception.
The message format for the Motorola 68000 is given below.
@Index[Motorola 68000]

@hbar(2 inches)
@begin(Description)
requestcode@\EXCEPTION@us()REQUEST

type@\Type of exception.
This is encoded as
the address of the MC68000 exception vector that was taken.

buserrortype@\Additional information on the cause of the error,
if @i[type] is equal to BUS@us()ERROR.

code@\In the case of address errors and bus errors, this contains a code
returned by the processor to identify the type of memory reference that
caused the exception.
Only the low order 5 bits of this word are valid;
the others should be masked off.
For other types of exceptions, this word contains zero.

accaddr@\The access address in the case of address or bus errors,
otherwise zero.

instruction@\The instruction register in the case of address or bus
errors, otherwise zero.
This should be the first word of the instruction
that caused the error.

status@\The status register.

errpc@\The program counter.

segment@\Starting address of the team's address space.
Currently at 0x10000 on the SUN workstation because the kernel uses the
first two segments.

segmentsize@\Number of bytes in the team's address space.
@end(Description)
@hbar(2 inches)

See the Motorola MC68000 User's Manual for a description of the
types of exceptions possible and the meaning of the information returned
by the processor and passed on in these exception messages.

Exceptions are always blamed on the currently active process, even if they
occur inside the kernel.
For instance, it is possible for 
an exception inside the kernel
to be caused by an invalid pointer passed by a process when invoking a
kernel operation.
However, it is also possible for exceptions to be caused by bugs in the
kernel itself, though this is unlikely unless an experimental version of the
kernel is being tested.
@Foot(The worst case is when the exception is caused by a
bug in a kernel interrupt handler, since in that case there would be no
relation between the currently active process and the code that caused the
exception; however, in this case, the bug is likely to crash the processor
anyway.)

A standard exception server process has been implemented and
is described in the @i[V-System Servers Manual].
