@string(LastEditDate="Tue Jun 17 16:28:53 1986")

@Part(install, root "manual")
@Appendix(Installation Notes)@label(installation)@index(installation)

This document describes the installation and maintenance of
the V-System software.
The reader should be familiar with the V-System as documented in the
V-System manuals, and with the Unix system used for development.

@section(V-System Distribution Tapes)

The software is distributed on a 1600 bpi Unix tar format tape.
Licensing information and tapes can be obtained from:
@begin(format)
	Office of Technology Licensing
	Suite 250
	350 Cambridge Ave.
	Palo Alto, CA 94306
	(415) 723-0651
@end(format)
All the software is under copyright protection, so you must
get a license from Stanford to have this software.
New versions of the software may be released from time to time.
Send comments on the software and documentation to the Arpanet
address @t[vbugs@@pescadero.stanford.edu].
Please report any bugs you find, or improvements you make.

The full V distribution consists of two tapes, the 
binary distribution (or binary tape), and
the source distribution (or source tape) which has the sources to the V system
itself. @t[V6.0] combines both of these on a single tape, with the
``logical binary tape'' first.
@b[The combined space requirement for V6.0 is approximately 67 megabytes.]

@b[Note:] This V distribution runs on Cadlinc and SUN MicroSystems
workstations with 68000s (SUN-1s), SMI workstations with 68010s and
68020s (models 2/{50,100,120,170} & 3/{75,160}), and @c[DEC] MicroVAX-II
workstations with and without framebuffers.  Ethernet drivers are provided
for the @c[3com] and Excelan 10meg boards, the Intel 82586 LAN chip (found in
SMI 2/50 and 3/75 models), the SMI 3 meg board, and the DEQNA.
There is presently no driver for the SMI Multibus 10 Mbit Ethernet
interface or for the AMD 7990 chip found in the Sun-3/50.
The @c[VAX] server host side must be running 4.2 or 4.3 @c[BSD].

@section(Binary Distribution Tape)

The binary tape contains 3 tar (Unix tape-archive format) files:
@begin(description, leftmargin +8, indent -8)

enet:@\The files required to install our ethernet
packet filter code in a Vax/Unix 4.2 kernel.
The installation.doc and enet.doc files that are part of this tape file
describe how to install the driver and how it works, respectively.
This code should be included in the official 4.3BSD release.

unix:@\The binaries and some sources for
Unix support programs and servers used with V.

usr.V:@\@Multiple{Files used by workstations running the V-system.
@begin(itemize)
V binary images for kernel, servers and programs.

V libraries for C programs in Unix tar format.

V header files for C programs, defining standard manifest
constants and structures.

Miscellaneous configuration and documentation files.
@end(itemize)}
@end(description)

The binary tape is structured to be loaded into a single subtree of
a Unix file system.
Make a subdirectory on a partition with at least 65 megabytes free. We
suggest calling it V6.0. Change to the V6.0 directory, make another
subdirectory called @t[enet] and change to it. Extract the packet filter
from the tape. Change to V6.0 and run @t[tar x] repeatedly to extract the
remaining files from the tape.
(Due to extra end-of-files, you may get a ``0 blocks read''
message between files.)

Several programs expect to find files in certain directories.
Run the @t[Vlink] shell script to link the distribution into the
file structure.

Add the termcap.vgts entries to /etc/termcap.

@subsection(V Subdirectories)

There are several subdirectories of interest under the ``V''
subdirectory in the installation directory:
@begin(description)
bin@\Binaries of the V-system commands and servers.
These are the programs that run under V on the workstations.

boot@\This directory contains standalone
programs (programs that do not run under the V kernel) such as @t[Vload]
(the @t[V]-System bootstrap), and the @t[netwatch] family of network
monitoring programs, plus initial teams to run under the V kernel.
The subdirectory ``Vkernel'' contains
various V kernel configurations.

config@\Workstation configuration files.
One config file exists per workstation. These files are used
by the @t[ndserver] to determine which version of @t[Vload] to download,
by @t[Vload] to determine which kernel image to load, and by the
internetserver to determine the workstation's IP address.

fonts@\Type fonts used by the VGTS and other V-System programs.

include@\The include (@t[.h]) files.
Most V-System include files start with an upper case ``V''.

lib@\The V-System libraries.
The main run-time library is libV.a
Other major libraries are libsun100Vgts.a for the SUN-1 frame buffer and
libsun120Vgts.a for the SUN-2 framebuffer, raw character I/O for various
hardware configurations, and lowlevel V ikc libraries for standalone programs.
There is also a library for each of the different servers,
e.g. libVinternet.a contains the Internet server,
providing primarily IP/TCP service.

misc@\Other random files.

run@\Various files that are used by programs for runtime support.
@end(description)

@subsection(Network File Service and Bootloading)

The next step is to provide network file service and bootloading
service.
@begin(enumerate)
Provide access to the Ethernet on your VAX/UNIX system
(the only configuration fully supported by the distribution tape).

Modify the configuration files, under V/config
to indicate the desired configuration and network
addresses of your workstations.

Install and
initiate the execution of the Vserver and ndserver on the Vax.
@end(enumerate)
@paragraph(Ethernet Filter Code)

This code must be added to the Unix kernel, if not already present.
It allows a user program to open the Ethernet directly for reading
and writing as a special device file.
The user program can then specify by a ``filter'' which packets
it wants to receive.
See enet/Installation.doc for installation information
and enet/enet.doc for a brief description of the code.
Note that 4.2 BSD does not currently provide this functionality.
However, a group at Stanford has convinced the weenies at Berkeley to include
this driver as a standard part of Berkeley Unix, starting with the 4.3 release.
Make sure the maximum packet size (MTU) is large enough to fit
all the data bytes in a kernel packet plus the header,
currently about 1200 bytes. The @t[V6.0] release packet filter is incompatible
with previous packet filter releases.

In addition, the network driver files in@us()proto.c and ip@us()input.c
should be replaced in /usr/src/sys/netinet.
This adds
the IPPROTO@us()ND protocol family (used by SMI boot proms) to the kernel.

@paragraph(Ethernet multicast reception)
@b[Important:] Make sure that your Unix ethernet driver is set up to
receive all multicast packets. By default most drivers do not listen to
these packets.  Multicast is now a fundamental part of the V interkernel
protocol.

@paragraph(DEC Deuna)
Change the initialization line in @t[/usr/src/sys/vaxif/if_de.c] to include the
multicast enable bit:
@begin(programexample)
#ifdef	STANFORD
	/* receive all multicast packets to keep V people happy */
	ds->ds_pcbb.pcbb2 = MOD_TPAD|MOD_HDX|MOD_ENAL;
#else
	ds->ds_pcbb.pcbb2 = MOD_TPAD|MOD_HDX;
#endif	STANFORD
@end(programexample)

@paragraph(Interlan 1010a)
Before setting the Interlan board online send an additional command to enable
reception of all multicast packets (in @t[/usr/src/sys/vaxif/if_il.c]):
@begin(programexample)
#ifdef	STANFORD
	/*
	 * For V people: receive all multicast packets
	 */
	addr->il_csr = ILC_ALLMC;
	while ((addr->il_csr & IL_CDONE) == 0)
		;
#endif	STANFORD

	/*
	 * Set board online.
	 * Hang receive buffer and start any pending
	 * writes by faking a transmit complete.
	 * Receive bcr is not a muliple of 4 so buffer
	 * chaining can't happen.
	 */
@end(programexample)

@paragraph(Configuration Files)

The ``config'' files provide information about individual network nodes
or workstations.
If a node has Ethernet address AAAAAAAAAAAA (in hex)
then its configuration file
should be config/C.AAAAAAAAAAAA.
In general, C.* files describe a network node, G.* files describe routing
to be used by a gateway and S.* files are scripts for servers to execute
on initialization. Config files contain information fields of the form
``name:value''. Several exapmles are included in @t[V/config].
See chapter @ref(ConfigDatabase) for a full description of the keywords and
their appropriate values.

The fields needed for booting are:
@begin(description)
name@\Name to be used as a user-specified designation of network node.

bootfile@\@begin(multiple)
Which version of @t[Vload] to download. Sun-2/50s must have this field set to
Vload50.d. It defaults to Vload10.d for Suns and Vload.vax for microVaxen.
@end(multiple)

alt-ether-addr@\@begin(multiple)
Sun-2 workstations that have @c[3com] ethernet interfaces
use the SMI address (0800.2001.xxxx) for booting and the @c[3com]
address (0260.8c00.xxxx) when running the V-System.
To configure such a
workstation, name the config file after its @c[3com] address and
put the SMI address in the alt-ether-addr field.
SMI workstations generally print their SMI-assigned ethernet
address on the screen during powerup.
You can determine your workstation's @c[3com] address by running
the following program under SMI Unix:

@begin(programexample)
#include <sys/file.h>

main()
  {
    int fd, i;
    unsigned char addr[6];

    fd = open("/dev/mbmem", O_RDONLY, 0);
    lseek(fd, 0xE0400, 0);
    for (i=0; i<6; i++)
	read(fd, &addr[i], 1);
    printf("%02x%02x.%02x%02x.%02x%02x\n", 
    	    addr[0], addr[1], addr[2],
    	    addr[3], addr[4], addr[5]);
  }
@end(programexample)
@end(multiple)

@end(description)

@paragraph(Initiation of V Servers on Unix)

The directory unix/etc contains the Unix server programs needed
to boot diskless workstations and serve remote sessions.
This directory is symbolically linked to @t[/etc/V].

The Vserver uses the file @t[V/run/Vhosttab] to map from hostnames to
V logical host ids. Since this file is installation dependent
you'll have to generate it by editing the SERVERHOSTS variable in
(source) V/servers/unix/buildfile, run buildmake, then make install.

The line ``sh /etc/V/rc'' 
should be added to @t[/etc/rc.local] to fire up these server programs
whenever the system is booted.
(The ``rc'' file also provides a reasonable description of how to
hand start these servers.)
@b[Note:] the Vserver expects to be run as root, so that it can
fork ``sessions'' that setuid to the appropriate user.

There must be at least one @i[public] Vserver running in any given
local network.  A Vserver is made public by starting it with the @t[-p] flag.
See the @i[Unix Server] section of the manual for further information.

@subsection(V Authentication Files)
@index(Authentication)
@t[V6.0] requires two files for authentication:
the Vpassword file, which is used by the Vauthentication server to
authenticate (log in) users, and the Vusercorrespondence file, which maps V
user numbers to Unix user names. For a complete description see chapter
@ref(authserver), @i[Authentication and the Authentication Server]. The
section @ref(auth-database) explains the use and needs of the files
involved in V authentication.

Two @i[awk] scripts are provided to generate the Vusercorrespondence and
Vpassword files from the Unix /etc/passwd file.
These scripts make each V user's V password the same as their password under
Unix, and makes their V home direcotry on the correct Unix host.
These scripts are aimed at sites
which have only one Unix host providing V file service. Section
@ref(multiple-Vservers) explains what to do if you have more than one such
Unix host.

@paragraph(Creating the Vpassword File)
@index(Vpassword)

Follow the directions in @t[/etc/V/Vpassword.awk], then create a rough
password file by executing 
@begin(programexample)
awk -f /etc/V/Vpassword.awk < /etc/passwd > /tmp/rough
@end(programexample)
Edit /tmp/rough to remove password entries for such Unix users as root, uucp,
etc. Copy /tmp/rough to /usr/V/misc/Vpassword.

@paragraph(Creating the Vusercorrespondence File)
@index(Vusercorrespndence)

Follow the directions in @t[/etc/V/Vusercorr.awk], then create a rough
correspondence file by executing
@begin(programexample)
awk -f /etc/V/Vusercorr.awk < /etc/passwd > /tmp/rough
@end(programexample)
Edit /tmp/rough to remove the same extraneous 
entries deleted from the password file.
Copy /tmp/rough to /etc/V/Vusercorrespondence.

@paragraph(The Unknown User and the V administrator)
A workstation which has nobody logged in is authenticated to a special
unknown user. We assume that you may want people to be able to run V programs
(such as telnet and netwatch) without logging in. To do so, create
an account called ``Vunknown'' on your unix system, make its home /tmp and give
it minimal privileges. In addition you should create ,``Vadmin''
an account for the
administration of V system files and @i[chown] /usr/V/misc/Vpassword to that
user.

@paragraph(V Authentication and Multiple Vservers)@label(multiple-Vservers)
If you have more than one machine
serving V, you must create a single password file that contains entries for
the users from all of the machines. To do this first
 create a Vpassword file on each offsetting the V user numbers so
that there is no overlap between machines. Then form a rough master password file by merging
all of them together on the master password site. Massage the rough
master by editing out duplicate entries, keeping the entries that correspond
to each users ``home'' machine.
Sorting the rough password file before duplicate deletion makes this chore
much easier.

It is a bit more difficult
to automatically generate individual correspondence files when building a
merged Vpassword file. This is because there may be little relation between
a given user's V user number and the user's Unix uids on multiple Unix
hosts.
We suggest starting with a minimal correspondence
table on each machine and having users run @t[addcorr] the first time they
log in to the V-System.
A minimal file sufficient to boot and test the system is as follows:
@begin(programexample)
0	Vadmin
1	Vadmin
2	Vunknown
@end(programexample)

@subsection(The Boot Sequence)

This section explains what happens during the bootstrap process.  See
chapter @ref(standalone) for a detailed description of workstation boot
commands.  The boot process consists of three steps: loading @t[Vload], the
V-system bootstrap, loading the kernel and first team, and initializing the
system (which may include downloading more programs such as the @t[vgts]).

@t[Vload] is downloaded over the network using the diskless booting
protocol contained in the workstation's proms. There are many brands of
workstations, and even more boot protocols.
Once running, @t[Vload]
locates and connects to a ``public'' Vserver to load the appropriate
kernel and first team.
After @t[Vload] has been loaded,
all subsequent network file I/O is performed through a V server using V
interkernel protocols.

@paragraph(SUN-1)
Owners of Sun-1s are pretty much on their own.
At Stanford we use our own proms which boot using PUP EFTP. You may have
another protocol, or none at all.
We suggest upgrading to a Sun-2.

@paragraph(SUN-2)
Booting SUN-2 workstations with the ND protocol requires a running
@t[ndserver].
The actual boot sequence is as follows.
When an SMI workstation boots,
if it contains no disk interface,
it attempts to boot over the Ethernet.
This is done using the ``ND'' boot protocol which asks for the
first 18 512-byte blocks of a virtual disk.
(Several of these blocks are thrown away. The boot program must be
less than 0x1E00 bytes of text and initialized data).
The ND server ``intercepts'' these requests and replies with @t[Vload].

In general, the ndserver is a modest ``hack'' to allow one to run V on
SMI SUN workstations without modifying the PROM monitor as it comes
from the manufacturer. If a Sun is to run SMI Unix the
field ``boot:no'' should be placed in the workstation's config
file to prevent the @t[ndserver] from downloading @t[Vload].

@paragraph(SUN-3)

Sun-3 workstations require running @t[rarpd] and @t[tftpd] servers.
A Sun-3
boots using IP RARP (reverse address resolution protocol) to
determine its IP address, then uses TFTP (trivial file transfer
protocol) to download a bootstrap program.

The rarpd uses a simple database file, rarpdb.<pseudo-net>, to map physical
ethernet addresses to IP addresses. Edit the example file to include the
Sun-3s that will be running V6.0. Make sure that the <pseudo-net> extension
matches the enet device corresponding to the 10 meg interface that the
workstations are on. Typically this is ``enet'' or ``eneta''.

Once the Sun-3 knows its IP address it uses TFTP to download a file named by
its hexadecimal IP address. For instance, if the rarpd responds with
``36.8.1.3'', the workstation will attempt to load a file named
``24080103''. This file should be linked to @t[Vload3+ie.d], the Sun-3
version of @t[Vload]. These files (including a copy of @t[Vload3+ie.d])
should be placed in your tftp daemon's home directory. The @t[tftpd]
distributed in 4.2BSD was buggy. We've included a patched version with V6.0,
along with a rarp daemon. Remember to start the rarp and tftp daemons from
/etc/rc.local.

@b[Note:] The Sun-3 boot process doesn't involve a workstation's
configuration file until after @t[Vload] is running, so neither the
'bootfile' nor the 'boot' config file fields affects booting. To run Sun
Unix prevent the tftpd from downloading @t[Vload] by removing the file
linked to @t[Vload3+ie.d].

@paragraph(MicroVAX)
Booting MicroVAX workstations requires the
@t[mvaxbootserver] to be running on a Unix host. The
@t[mvaxbootserver] services MicroVAX network boot requests just as the
@t[ndserver] responds to SMI ND requests. A ``boot:no'' entry in the
workstation's config file will prevent the @t[mvaxbootserver] from
responding to boot requests.

@Subsection(Debugging Suggestions)

If the system fails to boot after following the above sequence,
it is suggested that you try booting a ``standalone'' program
like @t[netwatch] to check the initial portion of boot sequence
and also (assuming you have multiple workstations), monitor
the network activity when you try a full system boot.
See the ``Standalone'' chapter 
of the reference manual (chapter @ref(Standalone))
for details on how to load and use standalone programs.
Section @ref(Netwatch) gives an overview of how to use the @t[netwatch]
family of programs.
In general, the @t[netwatch] family of programs are very useful
for debugging network problems.
They keep a record of network packets which can be
written to a log file.
Please include such a log file in bug reports that relate to
the network.

If the workstation fails to load a standalone program,
check that your ethernet connection is working correctly.
This is easiest if you have other means of monitoring
Ethernet activity.
You should also check that the @t[ndserver] or @t[mvaxbootserver]
is properly instructed
to respond to requests from the workstation's host address
by having the correct config files present.
The @t[ndserver] or @t[mvaxbootserver]
can be executed with the ``d'' flag to put it into
debugging mode.
This should give a clear indication as to whether or not it
is receiving the workstation boot request packets and
what it is doing in response to the packets it receives.

Assuming you can load standalone programs,
you should be able to load @t[Vload].
The error codes generated by @t[Vload] (e.g. ``C017'') can be decoded by
looking the the header file @t[V/include/mi/Venviron.h].
Besides using netwatch to monitor network activity,
one can run the @t[Vserver] in debug mode.
Option ``A'' gives a verbose account of the  Vservers's activities.
See chapter @ref(unixserver) for the details of other debugging options.

@Section(Source Distribution Tape)

The source distribution tape contains the V-System sources.
Unless one is modifying the standard software or recompiling for
some reason, there should be no reason to keep these sources on-line.

The procedure for extracting the files of the source tape is identical
to that used with the binary distribution tape.
@b[Warning:]  Do not extract the source tape into the same directory
as the binary tape.  Some subdirectories have identical names.
At Stanford, we keep V sources under /V.

@Subsection(Structure of the V Sources)

The V source directories are structured by function and by
machine dependency. For convenience each division is in a
separate tar file.
The major functional divisions are:
@begin(description)
cmds@\Standard command programs. A subdirectory for each
command program (with some exceptions that we plan to
eliminate).

kernel@\V Kernel sources. The machine-independent source is under
mi, 680X0 source under m68k, Microvax source under vax,
and configuration-specific files
under the other subdirectories.
For example, sun2+ec configures the kernel for the SUN-2 with
a @c[3COM] Ethernet interface.

libc@\Standard C run-time library for V.
Subdirectories for different functional parts of the library.
Machine-specific directories occur at various levels if there
are machine-specific files.

servers@\Server programs. A subdirectory for each separate server.
The two Unix server programs @t[ndserver] and @t[Vserver] are here,
though they don't run under V.

standalone@\Standalone programs. A subdirectory for each separate
program.

fonts:@\Sources for some of the fonts used in the V-System.

doc:@\The V6.0 manual in Scribe format.
@end(description)

@subsection(Recompiling V Sources)

Many of the V-System makefiles invoke @t[cc68] to compile and
link.
Be sure you have the latest version (included on the tape)
of @t[cc68], with the @t[-V] option.

Edit the shell script under @t[V/netinstall] to perform the appropriate
installation procedure for your system.
Some possibilities are for it to copy the binaries to other V hosts on your
network (thus automating the installation and causing changes to take
network-wide effect immediately), copy binaries to hosts in the local V-domain
only, or copy to the local host only (a good choice if you have only 
one host running a Vserver or update local hosts with regular rdists).
It's important to keep
all of the V binary directories synchronized within a domain since
binaries are often served by the first @t[Vserver] to answer a request.
This and a few other shell scripts are assumed to be
in the search path by the V-System makefiles.
These sources are in @t[V/tools] and should have been installed into
some directory in the search path by @t[Vlink]  before making the rest
of the system. Each directory contains a file called @t[buildfile]
which is processed by the @t[build] program, an enhanced version of @t[make].
The sources to @t[build] are included.

The following describes the steps (and order) to completely remake
the V-System binaries (and libraries).

Change directory to @t[V/libc] and do a @t[build install-includes].
This should copy the V-System specific include files into @t[/usr/V/include].
Then do a @t[build] and then @t[build install] under this directory.
This should result in @t[libV.a] being copied into @t[/usr/V/lib].

Next, change to the @t[V/standalone] directory.
This directory is for bootstrapping and loading utilities.

Next, change to @t[/V/kernel].
There is a subdirectory corresponding to each of the hardware combinations
currently supported by the V-System.
@b[cd] to the directory corresponding to your hardware
configuration, then do a @t[build] followed
by a @t[build install] to compile the kernel and put the binary
into @t[V/boot/Vkernel]. For instance, @t[V/kernel/sun2+ec] and
@t[V/kernel/sun1+en] correspond
to the configurations ``sun2 cpu with @c[3com] ethernet'' and
``sun1 (old sun, cadlinc etc.) with sun 3meg ethernet''.
You may have to create a new subdirectory and edit the buildfile
to configure the kernel for your I/O devices. 

Next change directory to @t[/V/servers], and do a @t[build] followed by
a @t[build install].

Next, change directory to @t[/V/cmds] and again do a @t[build] followed
by a @t[build install] to compile all the commands.
This takes a while, and uses the include files, libraries, and servers.

Do the same for @t[/V/config] (after making some config files for your
workstations) and @t[/V/standalone].

@Subsection(Source Distribution Summary)

The source tape provides all the files required to regenerate
the binary distribution tape files (we believe). Any omissions
were unintentional or forced upon us by lawyers.



