@Part(exec, root "manual" )
@Chapter(Using the V Executive)
@label(UsingExec)

@section(Introduction)
@index(Executive)@index(Exec)
The V executive is the part of the V system that 
accepts user commands from the keyboard and causes them to be executed.
It corresponds to the Unix@index(Unix)@index(Shell)
shell or Tops-20 Exec.@index(Tops-20)
The executive is available as a program and as a service provided
by the exec server@index(Execserver).
Each executive usually runs in a virtual terminal provided by
the workstation agent  either the STS or the
VGTS@index(Terminal Agent)@index(STS)@index(VGTS).
See the description of the STS in section
@ref(STS) and the description of the Exec Control menu of the 
VGTS View Manager in
section @ref(ViewManager)@index(Exec Control)@index(View Manager).

The basic operation of the executive is to read command lines
and execute commands.
The first field on a command line is the command name; the 
rest are arguments to be passed to the command.  
Fields are separated by spaces, except when quoted
(see section @ref(QuotingArgs)).
A command name can be a built-in exec command,
the name of a file containing a program compiled to run under the V
system, or the name of a program to be run on a server, such as Unix.
The executive provides a simple search path mechanism for commands.
By default, it looks first for a V program
in the current context (i.e., current working directory),
then in the [bin] context.@index([bin])
You can specify a different search path using the
@t[PATH] environment variable (section @ref(ExecEnvVars)).
If the command is not found on your search path, the exec
will try to execute it
remotely, on the server that is providing your current context.

The executive waits for each command to exit,
unless the last field on the command line is the single character @bt[&].
In this case, the command runs in the background,
while the executive continues to accept commands from the keyboard.
The View Manager and STS provide mechanisms for stopping or
interrupting a command running in the foreground.
A program running in the background may be terminated using the
@t[destroy] command (see chapter @ref(CmdSummary)).

Other exec features are described in section @ref(execsyntax).

@section(Naming)
@index(Contexts)
@label(ContextIntro)
A @i[context] in the V system is similar to the @i[directories]
provided by other systems such as Unix.
Each process (and thus each executive)
has its own @i[current context], i.e., current working directory.
A filename is normally interpreted in the current context, unless
it begins with a square bracket (`@t([)').
The square bracket flags the name as being 
either an absolute name, or a local alias.

In V, the first component of an absolute name generally specifies
the @i[type] of object or service being named.
The second component often specifies a particular server.
For example,
@programexample([storage/pescadero]/etc/passwd)
names the file @t(/etc/passwd) on the storage server @t[pescadero].
The closing square bracket is optional here.
Most servers accept it as an alternative to the standard slash character
(`@t[/]') used to separate name components.

Users can define their own local aliases for
contexts, using the @t[define] and @t[undefine] commands.
For example,
@ProgramExample(define g [storage/gregorio]/user/mann)
defines @t{[g]} as an abbreviation for user Mann's home directory
on the storage server Gregorio.
The command
@ProgramExample(undefine g)
removes this definition.
The command @programexample(printdef)
lists the local aliases that are currently defined.  
Several other standard aliases are automatically defined by the
executive when you log in.  These include
@begin(description)
@t([home])@\The logged-in user's home directory.

@t([sys])@\The directory containing standard V-System files.

@t([bin])@\The directory from which standard V-System commands are loaded.
Normally the same as @t([sys]bin).

@t([V])@\The directory containing standard production V-System files.
The same as @t([sys]) if you are running the production V-System.

@t([xV])@\The directory containing standard experimental V-System files.
The same as @t([sys]) if you are running the experimental V-System.

@t([homex])@\The ``home'' server used for program execution.  Normally
@t([team/local]), the local team server.  See section
@ref(VRemoteExecution).
@end(description)
When running with the VGTS, aliases defined in any exec created
by the view manager are global to all such execs, since all the execs
run on the same team.
A program run under the exec inherits a copy of the exec's aliases.
Later changes to the exec's aliases do not affect it.

@subsection(Changing the Current Context)
@index(cd)@index(Change Directory)@index(Change Context)
The @t[cd] (change directory) command can be used to change the
current context for an exec.
The command format is
@begin(programexample)
cd @i{pathname}
@end(programexample)
The pathname is interpreted in the (previous) current context.  If the
pathname is omitted, [home] is assumed.
When an exec is created, its current context is set to the current
value of [home].

@index(Pwd)
The @t[pwd] command prints the absolute name of the current context.

@section(Logging In and Out)

@subsection(Login)
@label(Login)@index(Login)
The @t[login] command is used to authenticate a user to the V-System.
The command format is 
@begin(programexample)
login @i(flags) @i(username)
@end(programexample)
The optional flags are described below.

The login command prompts for a password.  The password
is not echoed when typed.
An error message is printed
if the user types an invalid name or password,
or cannot be authenticated for some other 
reason.@foot{The message ``Server not responding'' indicates that no
authentication server could be contacted.  The command @t[authserver &] will
start one locally, after which it should be possible to log in.}
If authentication is successful,
the given user is registered with the exec server and
team server as the primary user of this workstation.
The exec then forces any guest programs running on the workstation
to migrate elsewhere.@Index(migration)

The exec next defines the local alias @t([home]) to be
the user's preferred home context, as recorded in the system
authentication database, and undefines all other user-defined aliases.
Thus, if user Mann's home context is @t{[storage/teton]/ds/mann},
after logging in, he can refer to the file @t[/ds/mann/phone-numbers]
under the name @t([home]phone-numbers).
In this case it would be possible to get at
the ``root'' directory on Teton by using a @t(/) immediately following
the alias, for example,
@t([home]/usr/V/misc/termcap).

Next, the exec changes its current context
to be the new value of @t([home]).
Finally, the exec executes a command script
from the file @t([home].Vinit), if such a file exists.

The login command's behavior can be modified by specifying one or
more of the following flags on the command line:
@begin(description)
@t[-v]@\Verbose flag.  Commands in .Vinit are echoed as they are
executed.

@t[-q]@\Quick flag.  Prevents .Vinit from being executed.

@t[-x]@\Exclusive flag.  Normally, when a user is logged in to a workstation,
that workstation is registered as being unavailable for remote execution
of commands, but if some other workstation insists on requesting remote
execution there, the team server will still grant the request.  If the
exclusive flag is given to the login program, the local team server is 
instructed to refuse all requests for remote execution.

@t[-r]@\Remote flag.  Register the workstation as being fully available for
remote execution, as though no one were logged in.

@t[-f]@\Finish flag.  Allow guest programs currently
executing on the workstation to
finish.  If this flag is not given, guest programs are forced to migrate to
another workstation.@Index(migration)

@end(description)

After a user has logged in to a workstation, 
all further execs created on
that workstation using the View Manager run as that user.
The @t[su] command can be used to authenticate individual execs
as some other user.@index(su)  The command format is
@begin(ProgramExample)
su @i(username)
@end(ProgramExample)
Like the @t[login] command, the @t[su] command prompts for a password,
which is not echoed.
However, it only authenticates the exec in which the command is typed.
It does not affect the exec server's record of the primary logged-in user,
or perform any of the other actions of @t[login].

Execs created when no one is logged in to a workstation run as
the @i[unknown user].  Most system servers place severe restrictions
on what the unknown user is allowed to do.

@subsection(Logout)@index(Logout)@label[Logout]

Give the @t[logout] command when you are done using a workstation.
The command format is
@begin(programexample)
logout @i(username) ...
@end(programexample)
where the user names are optional.
If no name is given, the user owning the exec in which the command
was typed is logged out.
If one or more user names are given, the given users are logged out.
If the flag @t[-a] is given in place of the list of user names,
all users with authenticated execs on the workstation are logged out.
(The latter two options are restricted to the primary logged-in user.)

Logging out a user destroys all execs authenticated as that user,
and hence all foreground programs run by that user.
Do not log out if you want such programs to continue running.

@section(Remote Program Execution on a Unix Server)
@label(RemoteExecutionBySession)
@index(Remote program execution)
If the executive fails to find an appropriate load file for a command,
it will attempt to execute the command on the server providing its current 
context by invoking the @t[fexecute] program.
Thus, for example, when a V server on Unix is providing the current
@index(Unix)@index(V server)
context, all the standard Unix commands like @t[finger], @t[man], or
@t[ps] are available.
The output of the Unix command is printed on the
standard output file.

You can also supply input to remote commands.
The character echoing and line editing on this input are done on the
workstation, not by the session server machine.

Since both the input and output are done through pipes, and input
is a line at a time,
many Unix programs
which expect to be run on tty devices (such as @t[emacs],
@t[more], etc.) do not work
in this mode.  Such programs can only be run by logging in to
the Unix machine, perhaps using the V telnet program to
connect to it (see chapter @ref(CmdSummary)).

The V servers do not provide execution of Unix commands to
users who are not logged in to V or do not have a Unix account.
If the executive tries to execute a Unix command for such a user,
the V server returns an ``No permission'' error.

@section(Remote Execution on V Hosts)
@index(Remote program execution)

A command can also be executed remotely by designating either a specific
remote V host or any remote V host.  A specific host can be specified either
by the process id of its team server or by its string name (e.g. sun-mj416).
(Syntax details are described in @ref(VRemoteExecution).)
Remote execution of this type is transparent to the user
in that I/O is still directed to the local host.

@section(Facilities for Command Specification and Modification)
@label(execsyntax)

The executive provides various facilities for specifying commands and for
redefining various aspects of command execution.  The syntax and semantics
of each is described below.  

@subsection(Line Editing Facilities)

Command lines can be edited as described in Section @ref(LineEditing).

@subsection(Pattern Expansion)

A command argument that contains one or more asterisks (@bt[*]) is
considered a @i[pattern], and
is replaced
by a list of existing filenames that match the pattern,
unless it is quoted with @t[""] or @t[''] (section @ref(QuotingArgs)).
The asterisk character matches any string of zero or more characters
other than slash (@bt[/]), right square bracket
(@bt{]}), or an initial period (@bt[.]).
Other characters in the pattern match themselves.

@subsection(Command History References)

The executive maintains a history of the last 20 command lines that the
user has typed in.  These command lines may be referenced by typing the
character @bt(!) immediately followed by a prefix of the desired command
line.  Thus if the command line 
@Begin(programexample)
cp /ng/ng/V/cmds/exec/exec.c /tmp/exec.c
@End(ProgramExample)
was typed in, then it can be referenced by typing (for example)
@Begin(ProgramExample)
!cp
@End(ProgramExample)
If a non-unique prefix is specified then the most recent command with that
prefix is taken.  Another special form of reference is @bt(!!), which
references the previous command line.

When a command line is referenced it is redisplayed for further line
editing and verification.  Thus in the previous example typing 
@Begin(ProgramExample)
!cp
@End(ProgramExample)
will cause the executive to display
@Begin(ProgramExample)
cp /ng/ng/V/cmds/exec/exec.c /tmp/exec.c
@End(ProgramExample)
with the cursor sitting at the end of the line.  The user can then hit
carriage return to re-execute the line or can edit it first to derive a new
command.

The command @t[history] @index(history) will cause the executive to list the
command lines it has stored in its history record.  The most recently
executed command will be at the bottom of the list.

@subsection(Command Aliases)

Command names can be aliased by means of the @t[alias] command.  
Thus, for example, typing
@Begin(ProgramExample)
alias e ved
@End(ProgramExample)
will cause the command name ``e''
to be replaced by ``ved'' in subsequent command lines.  Note
that aliasing is done @i[only] for command names and not for 
command arguments.
(Remember that the command name is the first word of a command line.)

Aliases specify a string for replacement of the alias word.  Thus one can
create aliases such as
@Begin(ProgramExample)
alias test /ng/mmt/test/testcopy -d
@End(ProgramExample)
Then typing something like
@Begin(ProgramExample)
test file1 file2
@End(ProgramExample)
will cause the command
@Begin(ProgramExample)
/ng/mmt/test/testcopy -d file1 file2
@End(ProgramExample)
to be submitted to the executive for execution.

A list of all defined aliases can be obtained by typing @t[alias] without
any arguments.  The command @t[unalias] is used to remove an alias
definition.  Specifying a new alias definition for a command name simply
replaces the old one.

@subsection(I/O Redirection and Pipes)

I/O redirection and specification of
pipes between two (or more) commands is done
using the same syntax as is used by the Unix shells.  Thus input can be
redirected to come from a file by specifying
@Begin(ProgramExample)
cmd < file
@End(ProgramExample)
and output can be redirected to a file by specifying
@Begin(ProgramExample)
cmd > file
@End(ProgramExample)
or 
@Begin(ProgramExample)
cmd >> file
@End(ProgramExample)
The latter form specifies that the output should be appended to the file
whereas the first form will overwrite any data already existent in the file.
Error output can be redirected by specifying @bt[>?] or @bt[>>?].
The forms @bt[>&] and @bt[>>&] redirect both standard output and
standard error to the same file.

A special form of redirection is available for bidirectional files,
such as the serial lines available on Suns. Specifying
@programexample[cmd <> file]
causes the command's input and output to be redirected to the same file.
To be precise, the file is opened in FCREATE mode, and standard output is
redirected to the instance thus created.  Standard input is redirected to
come from an instance whose id is equal to the output instance id plus 1.
This matches a convention used by several V-System I/O servers.  The
form @bt[<>&] also redirects standard error to the same instance as 
standard output.

Pipes can be set up between several commands by separating them with a 
@bt(|) on the command line.  Thus, for example, the command line
@Begin(ProgramExample)
cmd1 | cmd2 | cmd3 > log
@End(ProgramExample)
will create two pipes and redirect I/O so that the output of cmd1 will be
used as the input to cmd2, the output of cmd2 will be used as the input to
cmd2, and the output of cmd2 will be redirected into the file @t[log].

All the special characters described above must be surrounded by spaces
for the executive to recognize them.  Redirection clauses must appear after
all arguments to be passed to the command.

@subsection(Quoting Command Arguments)
@label(QuotingArgs)@index(Quoting Arguments)@index(Command Arguments)

Sometimes it is desirable to include a space in a single argument to a
command.  To do this, put a pair of either single quotes
(@bt(')) or double quotes (@bt(")) around the
argument.  An argument quoted by one of these may contain the other.
Unmatched quotes are matched by the end of the line.

@subsection(Environment Variables)
@label(ExecEnvVars)@index(Environment Variables)
The command
@ProgramExample(setenv @i[var] @i[value])
sets the environment variable @i[var] to the character-string value
@i[value].  (The latter should be quoted if it contains spaces.)
As with local aliases for context names,
environment variables are shared among all execs created by the View Manager,
and are inherited by programs run under any exec.

The command
@ProgramExample(unsetenv @i[var])
removes the definition of @i[var], while the command
@ProgramExample(printenv @i[var])
prints its definition.
The @t[printdef] command with no arguments prints all environment
variables.

A command argument that begins with a dollar sign (`@bt[$]') is
replaced by the value of the rest of the argument interpreted as an
environment variable, if such a variable is defined.
Otherwise the argument is left unchanged.

When trying to execute a V command,
the exec determines the search path to be used from
the environment variable @t[PATH], if it is set,
as do all programs that use the standard V-System program
execution library routines.
The value of @t[PATH] should be a list of context names separated
by spaces.
The default path, used if @t[PATH] is not set, is ``./ [bin]''.

@subsection(Concurrent Commands)

Commands can be specified as being @i[concurrent] by including an @bt(&) at
the end of the command line.  This causes the executive to return
immediately to the user for another command rather than waiting until the
current command completes.  Also, while
nonconcurrent (foreground)
commands are terminated if their executive is
deleted, concurrent (background)
commands will continue even if the executive that
initiated them goes away.
In fact, concurrent commands continue to execute even if the user
that initiated them logs out.

The @bt[&] must be preceded by a space for the executive to recognize it.

@subsection(Execution of Commands on Another Host)
@label(VRemoteExecution)
@index(Remote program execution)

Commands can be designated to execute on another host by including
@Begin(ProgramExample)
@@ @i[<host-designation>]
@End(ProgramExample)
on the command line.  
Here @i[<host-designation>] can be one of three things:
@Begin(itemize)
The hexadecimal process id of the host's team server.  This must given in
the form @p[0x]@i[pid], i.e. as the characters @p[0x] followed by the hex
process id.

The string name of the host, e.g. @t[sun-mj430].

The string @t[any], designating any
suitable V host other than the local one.
A @i[suitable] host is defined as a host on which no one is logged in,
and whose unused memory and CPU time meet certain minimum requirements.
@End(itemize)

Remote execution is transparent to the user in that the I/O of the command
is still directed to the local host and will be displayed in the same manner
as if the command were executing locally.

The @bt[@@] sign must be surrounded by spaces for the executive to recognize
it.  The remote execution clause, if present, must follow all arguments to
the command (but may be intermixed freely with redirection clauses).

Another way to specify that commands should be executed remotely
is to use the @t[cx] command to change the exec's @i[current execution
context]_that is, the server (and context) where commands are executed when
a remote execution clause is not given.
The command format is
@ProgramExample(cx [team/@i(hostname)])
Giving the @t[cx] command with no arguments resets the execution context
to @t([homex]), the exec's ``home'' execution context, which is
normally @t([team/local]).
The command 
@ProgramExample(pwx)
prints the name of the current execution context.

@section(Support for Heterogeneous Processors)
@label[HeterogeneousCommandExecution]
@index(Heterogeneity)

The V-System currently runs on machines with two different types of 
processor: the Motorola 68000 family and the DEC Vax family.
More processor types may be supported in the future.
Thus, several versions of the same V program may exist, each compiled for a 
different processor.

Different versions of the same V program that appear in the same directory
may be distinguished by a @i[machine-specific] file-name suffix.  This suffix
is ``@t[.m68k]'' for Motorola 68000-based machines (in particular,
Sun workstations), and ``@t[.vax]'' for the Vax.
Note, in particular, that the directory for installed V-System command 
binaries (at Stanford, @t[/usr/V/bin]) contains two such versions of almost 
every command.
When searching for a command binary, the executive automatically searches 
for a file name both with and without an appropriate machine-specific suffix.
Thus, it is not necessary for the user to enter a machine-specific 
suffix when typing a command to the executive.
This is true even if the command is executed @i[remotely] (see section
@ref[VRemoteExecution]) on a host with a different processor type.

In light of the above, the executive's search path mechanism needs to be 
explained further.  When a command is to be executed on a @i[specific] 
host (that is, one that is known in advance), then the executive looks down the
search path, until it finds a version of the command that can be executed on
this particular host.  This is the usual case.
When a command is to be executed on an @i[arbitrary] host (``@t[@@ any]''), 
then a slightly different mechanism is used.  In this case, the executive 
looks down the search path until it finds @i[any] version of this command.  
It then determines all versions of the command that exist in this location, 
and selects a suitable remote host that is able to execute one of these 
versions.
In most circumstances the difference between these two mechanisms will not 
be noticeable.
