@part(Vdb, root "manual")
@chapter(debug: The V Debugger)
@label(Vdb)@label(Vdebugger)
@comment(The debugger used to be called Vdb.  This name lives on only in
Scribe labels and part names --TPM)

@section(Synopsis)

@begin(programexample)
debug  [-d]  [-o origin]  progName  progArg1  progArg2 ...
@end(programexample)

@section(Description)

@subsection(Invoking the Debugger With a Program)

@index(Debugger)
@i[Debug]
is an assembler-level symbolic debugger for V programs.
Versions exist for both the Vax and the 
68000.

It can be called as a command to the V exec and takes the following
arguments:
@Begin(description)

-d@\If the VGTS@index(VGTS)
is available, then this argument causes an AVT to
be created for the debugger which is separate from the one used by the
program to be debugged.  This option is a necessity for programs which read
keyboard input via separate reader processes since these may interfere with
the debugger's keyboard input requests.

-o origin@\The @i[origin] is the location where the program to be
debugged was linked to load (e.g., 1000 or 2000 in the case of the kernel).
The default value is the normal team origin (currently 20000).
This option is usually only used by kernel hackers
in place of getting a symbol table dump and assembler listing when debugging.
They issue the command @t[debug -o 2000 /xV/kernel/sun2+ec/sun2+ec]
(for example), and
can find out exactly what is at the address where it crashed.  The debugger
disables the @t[g], @t[x], etc. commands when in this mode.


progName@\The name of the program to be debugged.

progArg@i(n)@\The nth argument of the program to be debugged.
@End(description)


Thus, to debug a program which is normally invoked by:
@Begin(programexample)
progName arg1 arg2
@End(programexample)
one types
@Begin(programexample)
debug progName arg1 arg2
@End(programexample)
If a separate
AVT is desired (@i[for VGTS resident environments only]) then one would
type
@Begin(programexample)
debug -d progName arg1 arg2
@End(programexample)

@subsection(Postmortem Debugger)

The debugger can also be used as a ``postmortem'' debugger.  The V
team server is
structured so that if an exception occurs in the program currently being 
run, the debugger is automatically loaded and given control.
The postmortem debugger is always run with the @t[-d] flag.

@subsection(Common Usage)

A program invoked with the debugger will start out at the debugger's command
level.  Breakpoints may be set and the program code and global variables
may be examined.  The program can then be started using the commands
described below.

A frequent ``postmortem'' use of the debugger is to obtain a stack trace to
find out where a program incurred an exception and then quit.  This is done
by typing @t[s] after having been transferred into the postmortem debugger
to get a stack trace, and @t[q] to quit:
@begin(programexample)
! @ux(prog arg1 arg2)

Bus error on read from address    f in process    2ed0024
Instruction       Program Counter     Status Register/PSL
    1010              10172               10
B0> 10174      4880                    main+2C           extw d0
.@ux(s)
    @i(stack trace)
.@ux(q)
!
@end(programexample)

@section(Commands)

The debugger begins by displaying the line of code at which execution
has paused, and then gives a period (`.') as a prompt.
The user can then enter commands using the keyboard.
Most commands are
terminated with a carriage return; exceptions will be noted in the
command descriptions.
The only characters that may be used to erase previously typed input are
backspace (\b) and delete (DEL).  The entire line may be erased by typing
CTRL-u.
When omitting optional arguments in commands
which take more than one argument, be sure to include the correct number
of commas for the command.  In this way the debugger can determine which
argument is to be assumed.

@subsection(Definitions)

Within the command descriptions below,
an @i[expression] is 
some combination of numeric constants,
register symbols, globally visible symbols from the program being
debugged, and the operators @t[+], @t[-], and @t[|], representing 2's complement
addition, subtraction, and bitwise inclusive or, respectively.
Blanks are not
significant except in strings.  All
operations are carried out using 32-bit arithmetic and evaluated strictly
left to right.

Register symbols are symbols which represent the various
processor registers.  The following symbols are
recognized on the 68000:
@Begin(description)
@b[%d0] - @b[%d7]@\Data registers 0 - 7.

@b[%a0] - @b[%a7]@\Address registers 0 - 7.

@b[%fp]@\Frame pointer (synonym for %a6).

@b[%sp]@\Stack pointer (synonym for %a7).

@b[%pc]@\Program counter.

@b[%sr]@\Status register.
@End(description)
The following symbols are recognized on the MicroVAX:
@Begin(description)
@b[%r0] - @b[%r11]@\General registers 0 - 11.

@b[%ap]@\General register 12 (argument pointer).

@b[%fp]@\General register 13 (frame pointer).

@b[%sp]@\General register 14 (stack pointer).

@b[%pc]@\General register 15 (program counter).

@b[%psl]@\Program status longword.

@b[%psw]@\Program status word.
@End(description)
In all commands except the replace-register (@b[rr]) command a register
symbol represents the contents of the specified register.  In the
replace-register command it represents the address of the register
specified.

Globally visible program symbols are names of program routines or 
global program variables.  Note that the VAX C compiler prepends an
underscore to the names of all global symbols.  The debugger attempts
to guess the correct symbol if no underscore is typed by the user, but
it does get confused sometimes.

The single character `.' (dot)
is treated as a symbol representing the last memory location
examined.  Its value upon entrance to the command level of the
debugger is set to the current value of the program counter.


@subsection(Execution Control Commands)

@Begin(description)

@i[expression], @i[number], @b[b]@\Set breakpoint 
@i[number] (in the range 2-15 decimal) at
@i[expression].  @i[expression] must be a legal instruction address.
If @i[number] is omitted the first unused breakpoint number
is used.  If @i[expression] is 0 the named breakpoint is cleared, or if
@i[number] is omitted then all breakpoints are cleared.  If @i[expression] is
omitted all breakpoints are printed.  Note: if @i[expression] is omitted
then @i[number] must also be omitted or must be preceded by a comma in order
distinguish it from being interpreted as the @i[expression] argument.

  VAX note (not applicable to the 68000):
  The VAX C compiler uses the @i(calls) instruction for all function calls.
  This instruction expects to find a 2-byte register mask at the address
  specified and actually transfers control to that address plus 2.
  Therefore you have to add 2 to the address when setting breakpoints at
  functions in a C program on a VAX.  This may or may not apply to
  subroutine calls in assembly language or in code generated by other
  compilers, depending on which instruction is used.

@i[expression], @b[g]@\Go.  Start or resume execution at @i[expression].  If @i[expression] is
omitted, then start execution at the current pc value.

@i[expression], @b[gb]@\Go past breakpoint.  
Like @i[go] with no argument, except
that if we are presently stopped at a breakpoint, then @i[expression] counts the
number of times to pass this breakpoint before breaking.  If @i[expression]
is omitted, then 1 is assumed.

@i[expression], @b[x]@\Execute the next @i[expression] instructions, 
starting from the
current pc and printing out all executed instructions.  If @i[expression] is
omitted, then 1 is assumed.  Note: traps are executed as single
instructions; i.e. the instructions executed in a trap routine are not
displayed or counted.

@i[expression], @b[y]@\Same as @b[x] except that 
subroutine calls are executed as single
instructions; i.e. do not descend into the called subroutine.
Note that breakpoints within the subroutines are ignored.

@b[xx]@\@b[xx] is a synonym for @b[y]

@b[;]@\A synonym for @b[x], except that each instruction executed is displayed on
the same line as the command, providing a more compact display.
No carriage return is needed to terminate this command; the semi-colon triggers
execution.

@b[:]@\A synonym for @b[y], except that each instruction executed is displayed on
the same line as the command, providing a more compact display.
No carriage return is needed to terminate this command; the colon triggers
execution.

The typeout mode referred to in the command descriptions is described under
the @b[t] command.

@b[sp]@\Toggle the flag that determines whether the whole team stops at an exception
or just the process that incurred the exception.  The debugger's default
behavior is to stop the whole team when an exception occurs, not allowing
any of its processes to proceed until one of the above Execution Commands
restarts the team.  (Of course, at that point ANY of the processes could
resume execution_i.e., single-stepping one process could allow another
to execute indefinitely.)  If this command is typed, an exception in any
one process will not halt any of the other processes on the team.  
Typing @t[sp] again makes
the debugger go back to its original behavior.

@b[q]@\Quit.  Exits the debugger and kills both the debugger and the
program being debugged.

@End(description)


@subsection(Display Commands)

The following commands are executed immediately without waiting for a
carriage-return (CR) to be typed, and their output overwrites
the current line.  (This provides a more compact display format.)
@Begin(description)
@i[expression]@b(/)@\

@i[expression]@b(\)@\Display the contents of @i[expression].
The typeout mode used is determined from the program symbol
table and the current typeout mode.  The value of dot is set to
@i[expression].
The @b(\) command is not very useful in instruction-typeout mode on the VAX
  (i.e. after giving the "'i',tt" command) because the VAX uses variable
  length instructions and almost every byte value is a valid op-code,
  thus making it impossible to tell where the previous instruction really
  starts.  Similar problems occur less frequently on the 68000.

@b(/)@\

@b(\)@\Display the contents of dot after having respectively incremented
(@b[/]) or decremented (@b[\]) it.
The typeout mode used is determined from the program symbol
table and the current typeout mode.

@b(@@)@\

@i[expression]@b(@@)@\Display the contents of the memory locations
@i[pointed] to by the value of dot or @i[expression], respectively.
The typeout mode used is determined from the program symbol
table and the current typeout mode.  The value of dot is set to the address of
the memory location just displayed.  Note that %pc will yield the contents of
the memory location pointed to by the pc register (i.e. the current
instruction) and that %pc@@ will attempt to place an additional indirection
on that memory location.  %pc@@ is almost always an invalid reference.

@b(=)@\

@i[expression]@b(=)@\Display the value of dot or @i[expression], respectively.

@End(description)


The following display commands are executed when a carriage-return is typed.

@Begin(description)
@b[d]@\Display the contents of all the registers.

@i[expression],@b[s]@\Print out a stack trace describing the chain
of subroutine calls and their parameters, to a maximum of
@i[expression] calls. (@i[expression] defaults to infinity.)
Warning:  the debugger's stack trace examines the values of
parameters as they currently exist on the stack, not as they were when
the routine was called.  Routines which change the values of their
parameters will similarly affect the stack trace output.

@i[expression], @i[numlines], @b[n]@\Display the next @i[numlines] memory locations, starting at
@i[expression].  If @i[expression] is omitted, then display starts at
dot.  If @i[numlines] is omitted, then 24 lines are displayed.

@i[expression], @i[numlines], @b[p]@\Display the previous @i[numlines] memory locations, starting at
@i[expression].  If @i[expression] is omitted, then display starts at
dot.  If @i[numlines] is omitted, then 24 lines are displayed.

@i[type], @b[t]@\Temporarily set typeout mode to @i[type] where
@i[type] is one of:
@Begin(description)
@b['c']@\type out bytes as ascii characters.

@b['h']@\type out bytes in current output radix.

@b['w']@\type out words (2-bytes) in current output radix.

@b['l']@\type out longs (4-bytes) in current output radix.

@b['s'], @i[strLength]@\type out strings.  Set the
maximum length of strings to be @i[strLength].  The maximum string length
determines how far the debugger is willing to look for the end of 
a string, which is assumed to be a '\0' byte.  For programming languages
such as Pascal which don't terminate their strings with a '\0' byte this
limit is important to prevent endless string searches.  The string maximum
length is sticky (i.e. it need be set to the desired value only once).  The
default value is 80.

@b['i']@\type out as symbolic assembler instructions. 
@End(description)
Note that the type characters must be surrounded by single quotes.
If no argument is supplied then the default typeout mode is used.  This mode
tries to set the typeout mode based on the type of symbol(s) being displayed
and uses @b['l'] format when the mode is not obvious.
The new typeout mode stays in effect until execution is resumed with one
of the Execution Control Commands.

@i[type], @b[tt]@\Permanently set typeout mode to @i[type].
The typeout mode is set to the default typeout mode if @i[type] is omitted.

@i[base], @b[ir]@\Set the input radix to @i[base].  If @i[base] is illegal (less than 2 or
greater than 25, decimal) or
omitted, then hexadecimal is assumed.  (This is the default radix.)

@i[base], @b[or]@\Set the output radix to @i[base].  If @i[base] is illegal (less than 2 or
greater than 25, decimal) or
omitted, then hexadecimal is assumed.  (This is the default radix.)

@i[offset], @b[of]@\Set the maximum offset from a symbol to @i[offset]. If @i[offset] is illegal
(less than 1) or omitted, then hexadecimal 1000 is assumed.  (This is the
default offset.)  This command is useful when examining areas of the team,
such as the stack, which are more accurately labeled by hex addresses than
by symbol+offset notation.

@i[charcount], @b[sl]@\Set the maximum number of characters in a symbol which
will be displayed to @i[charcount].
If @i[charcount] is illegal (less than 1 or greater than 128) or omitted,
then 16 is assumed.


@End(description)

@subsection(Tracing Commands)

@Begin(description)

@i[expression], @b[w]@\Watch the memory location at @i[expression].
When program execution resumes, the debugger regains control after
@i[every] instruction and checks whether the contents of the location
have changed.  If so, a message is printed and the user gets control.
Otherwise, the program continues.  This causes the program to run
several hundred times slower than normal.  If @i[expression] is 0,
watching is turned off.

@i[expression], @b[wb]@\Watch the memory location at @i[expression],
but only at breakpoints.  A breakpoint will not stop the program if
the watched location is unchanged.

@b[w]@\Print information about watched location.

@end(description)

@subsection(Replacement and Search Commands)

@Begin(description)

@i[expression1], @i[expression2], @i[type], @b[r]@\Replace the contents of the
memory location specified by @i[expression1] with @i[expression2].
@i[expression2] is interpreted to have type @i[type].
Note:  It is not currently possible to replace strings with this command, and
instructions should be specified in 16-bit quantities and  
replaced with type 'i'.
If @i[expression2] is omitted, then the value 0 is used.

@i[register], @i[expression], @b[rr]@\Replace the contents of the
specified register with @i[expression].  If @i[expression] is omitted, then
the value 0 is used.  @i[expression] is interpreted to be a 32-bit quantity.

@i[expression], @i[lowlimit], @i[highlimit], @i[type], @b[f]@\Search for
(find) @i[pattern] in the range @i[lowlimit] (inclusive) to @i[highlimit]
(exclusive).  @i[expression] is interpreted as an object of type @i[type].
Objects are assumed to be aligned on word (2-byte) boundaries
except for 1-byte types and strings, which are aligned on byte boundaries.
A mask (set with the mask command) determines how much of the @i[expression] is
significant in the search, unless @i[expression] is a string constant.
The first three
arguments to the search command are sticky; thus if any of them are omitted
then their previously specified value is used.
@b[f] is the only debugger command which allows the specification of a string
constant as @i[expression]. 
A string constant is delimited by the character " on either side;   
to use " in
the string itself, precede it with a \.   An example of
a string is: "This is a string with \" in it".  The typeout limit of strings
determines how much of the string is significant in the search, not the
search mask.

@i[expression], @b[m]@\Set the search mask to @i[expression].  
If @i[expression] is omitted then 0 is used.
-1,@b[m] forces a complete match, f,@b[m] (that's hex f) checks
only the low order 4 bits, 0,@b[m] will make the search pattern match
anything.
@End(description)

@subsection(Help Commands)

@Begin(description)
@b[h]@\Print a brief description of each of the debugger's commands.

@b[#]@\Print a set of internal debugger statistics.  This was implemented for the
convenience of the designers and may change frequently in content and format.
It replaces the obsolete @b[qq] which, due to the debugger's unsophisticated
command parsing will behave exactly as does @b[q].

@End(description)

@section(Bugs)

The debugger as it is currently implemented has some ``features'' one must be
aware of.  

Currently, the version of the debugger that runs on the Vax can
only debug Vax programs, and the version that runs
on the 68000 can only debug 68000 programs.
This limitation causes little difficultly since the debugger is
ordinarily run on the same host as the program to be debugged.

The debugger assumes that any trace trap exceptions have been caused by its
own single-stepping mechanism.  Though it will recognize the first one, and
print an error message, subsequent trap exceptions can cause intolerable
behavior.

The stackdump routines depend upon knowing the string names of the kernel
routines to produce correct stack traces which include those routines.  Right
now, this list is being kept up to date by hand.

Putting breakpoints in code which is shared by two or more processes can be
hazardous to your mental health.
