@part(build, root "manual")
@Chapter(build: Maintain groups of dependent programs)
@label(build)
@index(build)

@t(build) is an enhanced version of Feldman's @t(make)@index(make) program
for Unix. It runs both under V and 4.2bsd Unix.

Except in pathological cases, @t(build) is meant to be backward-compatible
with @t(make). See the Unix @t(man)-page for @t(make).  In this chapter, we
describe only differences between @t[build] and @t[make].

@t(build) reads in a file describing dependencies.  By default it looks
for the files @t(buildfile), @t(makefile) or @t(Makefile) (in that order)
in the current directory.

@section(Macros)
A dependency file can contain lines of the form:
@programexample(OBJECTS=file1.b file2.b).
This defines @t(OBJECTS) as a macro name, which can be used as in:
@programexample[cc68 -r -vV $(OBJECTS)]

Macro names can also be defined in the command line:
@programexample(build "-DOBJECTS=file1.b file2.b") or equivalently:
@programexample(build "OBJECTS=file1.b file2.b")

@section(Including other dependency files)
A line of the form
@programexample(#include @i[filename])
will parse the @i[filename] when reading dependency rules.
(The @i[filename] may optionally be surrounded by @t[<...>] or @t["..."].)

The @i[filename] is resolved relative to the directory containing
the currently-being-read file (the one containing the @t[#include]),
@i[not] the current working directory.

@section(Conditional dependency rules)
@begin(programexample)
#ifdef @i[name]
#ifndef @i[name]
#else
#endif
@end(programexample)

These act like @t[C] preprocessor directives.
For example @t(#ifdef X) succeeds iff the macro @t(X) is defined.

@b[NOTE:] If there is white space after a '#'-sign, the line is taken
as a comment!

@section(Search paths)
A line of the form
@programexample(VPATH=../68k ../mi)
or, equivalently,
@programexample(VPATH=../68k:../mi)
causes @t[build] to search for files first in the current directory, then
in the directory @t[../68k] and finally in @t[../mi].  The first form is
probably preferable as the VPATH macro may then also be used elsewhere in
the buildfile for other purposes.

One use of this is for maintaining libraries for multiple machines, where
most of the sources are in a machine-dependent directory @t[../mi], but
some of the sources and all of the binaries are in the current directory.

Another use is for program maintenance: The sources being worked on can
be in a private directory, while the remainder can stay in the master
directory, if you put the master directory on the search path.

@b[NOTE:] After macro-substituting command lines, @t[build] will look
for words (i.e. strings between spaces). If there exists an alias for
a word @i(and) the file is up-to-date, it will be replaced by the alias.
An alias exists for a word, if build has searched for the file with that
name, failed in the current directory, but found it on the search path.

This simple-minded algorithm will usually do the right thing,
but in pathological cases it might lose.

@section(Dependency patterns)
In addition to the old way of expressing dependencies using file suffixes:
@begin(programexample)
.SUFFIXES: .c .b
.c.b:
        cc68 -c $*.c
@end(programexample)
you can also use more general pattern-matching:
@begin(programexample)
*.b: $*.c
        cc68 -c $*.c
@end(programexample)

That is: a rule for making files can have as its target
a pattern containing at most one `*'.
The part of the file name matching the `*' defines the value of @t[$*].

@section(Suggestion)
If there are many files, you can speed up build (quite significantly for
the V version at least) by starting out with a empty @t[.SUFFIXES:] line, and 
explicitly defining just the suffixes you need.
This saves @t[build]
from having to check for the existence of @t[.y] files etc.

@section(Bugs)
Does not understand RCS.
