/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yaleselect.c */

#include "aledefs.h"

/* yaleselect: selects an object on the screen.  The boolean
 * preUnSelect is TRUE if all previously selected objects are to be
 * unselected before the current object is added to the selection list.
 * FALSE makes this routine into an "add-select" function.
 */

yaleselect (x, y, preUnSelect)
BOOLEAN preUnSelect;
short   x,
        y;
{
    LISTTYPE FindSelectedObject (), list;
    short   globalName;

    ResetXYStatus(x,y);

    list = FindSelectedObject(YaleSDF, x, y, GlobalVGT, All);

    if (list.NumOfElements == 0)
	return;

    if (list.NumOfElements > 1)
      {
    /* disambiguate +++ */
	printf ("found multiple (%d) objects -- using first\n",
		list.NumOfElements);
      }
    globalName = list.Header -> item;

/* Now we've got to figure out what kind of item was selected, and do
 * the appropriate thing.
 */

    switch (SunInstanceArray[globalName].type)
    {
	case SRectangle: 
	    yaleSelectRectangle (globalName, preUnSelect, list.Header->edgeset);
	    break;

	case SCellInstance: 
	    yaleSelectCellInstance (globalName, preUnSelect);
	    break;

	case SReferencePoint: 
	    yaleSelectRefPoint (globalName);
	    break;

	case SConnPoint: 
	    TtyBlinkError ("Not implemented");
	    break;
    }
}

/* yaleSelectRectangle: selects a particular rectange.  preUnSelect has
 * the same function as described in the comments for yaleselect,
 * above.  screenY and screenY are used by the selection routine to
 * figure out exactly which edges of the rectangle were selected.
 */

yaleSelectRectangle (sin, preUnSelect, edgeset)
BOOLEAN preUnSelect;
short   sin, edgeset;
{
    RECTANGLE_PTR rectPtr;
    short   openCellSin,
            xmin,
            xmax,
            ymin,
            ymax;
    short   rectScreenXmin,
	    rectScreenXmax,
	    rectScreenYmin,
	    rectScreenYmax;
    short   selectSet;
    BOOLEAN addedSelection;

    if (preUnSelect)
	UnSelectAll(OpenCellDefinition);
    InquireItem(YaleSDF, sin, &xmin, &xmax, &ymin, &ymax, NULL, NULL, NULL);
    rectPtr = SunInstanceArray[sin].ptr.rect_ptr;
    selectSet = rectPtr -> selectedEdgeset;

    selectSet |= edgeset;
    if (selectSet == 0)
	selectSet = AllEdges;
    SelectRectangle (rectPtr);
    rectPtr -> selectedEdgeset = selectSet;
    openCellSin = OpenCellDefinition -> expandedSunIds[2];
    EditSymbol (YaleSDF, openCellSin);
    AddItem (YaleSDF, sin + EDGECODE, xmin, xmax, ymin, ymax, selectSet, SDF_OUTLINE, NULL);
    EndSymbol(YaleSDF, openCellSin, GlobalVGT);
}

/* UnSelect: removes the selection outline from around the
 * item in question.  Deletes the outline from the SDF as well.
 */

UnSelect(sin)
short sin;	/* sunInstanceNumber for item */
{
    short openCellSin, xmin, xmax, ymin, ymax;

    openCellSin = OpenCellDefinition-> expandedSunIds[2];
    EditSymbol(YaleSDF, openCellSin);
    DeleteItem(YaleSDF, sin+EDGECODE);
    EndSymbol(YaleSDF, openCellSin, GlobalVGT);
}


yaleSelectCellInstance (sin, preUnSelect)
BOOLEAN preUnSelect;
short   sin;
  {
    CELL_INSTANCE_PTR cellInstPtr;
    short openCellSin,
    	calledSin,
    	xmin,
    	xmax,
    	ymin,
    	ymax,
	xbase,
	ybase;
    
    if (preUnSelect)
        UnSelectAll(OpenCellDefinition);
    cellInstPtr = SunInstanceArray[sin].ptr.instPtr;
    SelectCellInstance(cellInstPtr);
    openCellSin = OpenCellDefinition -> expandedSunIds[2];
    EditSymbol(YaleSDF, openCellSin);
    calledSin = InquireCall(YaleSDF, sin);
    InquireItem(YaleSDF, calledSin, &xmin, &xmax, &ymin, &ymax, NULL, NULL, NULL);
    InquireItem(YaleSDF, sin, &xbase, NULL, &ybase, NULL, NULL, NULL, NULL);
    xmin += xbase;
    xmax += xbase;
    ymin += ybase;
    ymax += ybase;
    AddItem(YaleSDF, sin + EDGECODE, xmin, xmax, ymin, ymax, AllEdges, SDF_OUTLINE, NULL);
    EndSymbol(YaleSDF, openCellSin, GlobalVGT);
 }

/* yaleSelectRefPoint: selects a new reference point (and at the same
 * time, unselects the previously-selected reference point.  The reference
 * point selected can be either vertical or horizontal.
 */

yaleSelectRefPoint (globalName)
short globalName;
  {
    register REFERENCE_POINT_ER refPtr;
    short xmin, xmax, ymin, ymax, openCellSin;
    unsigned char typedata;
    char name[TOKBUFSIZE];
    
    openCellSin = OpenCellDefinition -> expandedSunIds[2];
    refPtr = SunInstanceArray[globalName].ptr.refPtr;
    InquireItem(YaleSDF, refPtr->sunInstanceNumber,&xmin,&xmax,&ymin,&ymax,
    		&typedata,NULL,name);
    if (refPtr->isXvar)
      { /* it's vertical */
        yaleUnSelectRefPoint(OpenCellDefinition->xSelectedRef);
        OpenCellDefinition->xSelectedRef = refPtr;
        EditSymbol(YaleSDF, openCellSin);
        ChangeItem(YaleSDF, refPtr->sunInstanceNumber,xmin,xmax,ymin,ymax,
		typedata,SDF_SEL_VERT_REF,NULL);
	/** if (Debug)
	  printf("vert, xmin=%d, xmax=%d, ymin=%d, ymax=%d, data=%d\n",
	  	xmin, xmax, ymin, ymax, typedata ); **/
        EndSymbol(YaleSDF, openCellSin, GlobalVGT);
      }
    else
      {
        yaleUnSelectRefPoint(OpenCellDefinition->ySelectedRef);
        OpenCellDefinition->ySelectedRef = refPtr;
        EditSymbol(YaleSDF, openCellSin);
        ChangeItem(YaleSDF, refPtr->sunInstanceNumber,xmin,xmax,ymin,ymax,
		typedata,SDF_SEL_HORIZ_REF,NULL);
	if (Debug) 
	  printf("horiz, xmin=%d, xmax=%d, ymin=%d, ymax=%d, data=%d\n",
	  	xmin, xmax, ymin, ymax, typedata ); 
        EndSymbol(YaleSDF, openCellSin, GlobalVGT);
      }
}

/* yaleUnSelectRefPoint: changes the SDF entry to be unselected, and
 * re-draws the (now narrower) line.
 */

yaleUnSelectRefPoint(refPtr)
REFERENCE_POINT_ER refPtr;
{
    short openCellSin, refSin;
    short xmin, xmax, ymin, ymax;
    unsigned char typedata, type;
    char name[TOKBUFSIZE];

    openCellSin = OpenCellDefinition->expandedSunIds[2];
    refSin = refPtr->sunInstanceNumber;
    EditSymbol(YaleSDF, openCellSin);
    InquireItem(YaleSDF, refSin,&xmin,&xmax,&ymin,&ymax,&typedata,&type,name);
    if (type==SDF_SEL_HORIZ_REF)
      {
        type = SDF_HORIZONTAL_REF;
      }
    else if (type==SDF_SEL_VERT_REF)
      {
        type = SDF_VERTICAL_REF;
      }
    ChangeItem(YaleSDF, refSin,xmin,xmax,ymin,ymax,typedata,type,NULL);
    EndSymbol(YaleSDF, openCellSin, GlobalVGT);
    /** if (Debug) 
	  printf("unselect, xmin=%d, xmax=%d, ymin=%d, ymax=%d, data=%d\n",
	  	xmin, xmax, ymin, ymax, typedata ); **/
}
 
