/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yalereref.c */

#include "aledefs.h"

extern short CurrentFB;

/* yaleReReference: references all selected items (of the appropriate
 * types) to the reference point which is selected within this routine.
 * At present, only rectangles are rereferenced.
 */

yaleReReference()
{
    short oldOrigin;
    RECTANGLE_CONS_PTR rectConsPtr;
    RECTANGLE_PTR rectPtr;
    REFERENCE_POINT_ER refPtr;
    LISTTYPE FindSelectedObject (), list;
    BOOLEAN isXvar;
    EXPRESSION MakeRelativeExpression ();
    INSTANCE_CONS_PTR instConsPtr;
    CELL_INSTANCE_PTR instPtr;
    short worldX, worldY;
    short xmin, xmax, ymin, ymax, buttons;

    TtyPutString("Re-reference selected values to new ref pt B:");

    GetMouseClick( &worldX, &worldY, &buttons);
    TtyCRLF();
    if (buttons == 7)
	return;

    list = FindSelectedObject(YaleSDF,worldX, worldY, GlobalVGT, JustRefPt);

    ResetXYStatus(worldX, worldY);

    if (list.NumOfElements == 0)
        return;

/*
    if (list.NumOfElements > 1)
      {
        TtyBlinkError("Ambiguous selection");
        return;
      }
 */

/* Now we are sure that only a single reference point has been selected.
 */

    refPtr = SunInstanceArray[list.Header->item].ptr.refPtr;

    isXvar = refPtr->isXvar;

    instConsPtr = OpenCellDefinition->selectedSubcellList;

    while (instConsPtr != NIL)
      {
        instPtr = instConsPtr -> value;
        instConsPtr = instConsPtr -> next;

        if (isXvar)
    	  {
    	    UnLinkDepInstance(instPtr, Vertical);
    	    oldOrigin = evalexp(instPtr->trans.x31, CurrentFB);
    	    FreeExpression(instPtr->trans.x31);
    	    instPtr->trans.x31 = MakeRelativeExpression(refPtr, oldOrigin);
    	    LinkDependentInstance(instPtr, refPtr);
    	  }
        else
    	  {
    	    UnLinkDepInstance(instPtr, Horizontal);
    	    oldOrigin = evalexp(instPtr->trans.x32, CurrentFB);
    	    FreeExpression(instPtr->trans.x32);
    	    instPtr->trans.x32 = MakeRelativeExpression(refPtr, oldOrigin);
    	    LinkDependentInstance(instPtr, refPtr);
      	  }
      }
    rectConsPtr = OpenCellDefinition->selectedRectangleList;
    
    while (rectConsPtr != NIL)
      {
        rectPtr = rectConsPtr->value;
        InquireItem(YaleSDF, rectPtr->sunInstanceNumber, &xmin, &xmax, &ymin, &ymax,
        	NULL, NULL, NULL );
    
        if ((!isXvar) && (rectPtr->selectedEdgeset & TopEdge))
    	  {
    	    UnLinkDepRectangle(rectPtr, TopEdge);
    	    FreeExpression(rectPtr->t);
    	    rectPtr->t = MakeRelativeExpression(refPtr, ymax);
    	    LinkDependentRectangle(rectPtr, refPtr);
    	  }
        if ((!isXvar) && (rectPtr->selectedEdgeset & BottomEdge))
    	  {
    	    UnLinkDepRectangle(rectPtr, BottomEdge);
    	    FreeExpression(rectPtr->b);
    	    rectPtr->b = MakeRelativeExpression(refPtr, ymin);
    	    LinkDependentRectangle(rectPtr, refPtr);
    	  }
        if ((isXvar) && (rectPtr->selectedEdgeset & LeftEdge))
    	  {
    	    UnLinkDepRectangle(rectPtr, LeftEdge);
    	    FreeExpression(rectPtr->l);
    	    rectPtr->l = MakeRelativeExpression(refPtr, xmin);
    	    LinkDependentRectangle(rectPtr, refPtr);
    	  }
        if ((isXvar) && (rectPtr->selectedEdgeset & RightEdge))
          {
    	    UnLinkDepRectangle(rectPtr, RightEdge);
    	    FreeExpression(rectPtr->r);
    	    rectPtr->r = MakeRelativeExpression(refPtr, xmax);
    	    LinkDependentRectangle(rectPtr, refPtr);
          }
        rectConsPtr = rectConsPtr->next;
      }
}
