/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yalemove.c */

#include "aledefs.h"

extern short CurrentFB;

/* yaleMoveRefPoint: moves the selected reference point
 * on the display screen.  It assumes that the mouse has been clicked
 * on the reference point which is to be moved.
 */

yaleMoveRefPoint(worldX, worldY)
    short worldX, worldY;
  {
    LISTTYPE FindSelectedObject (), list;
    REFERENCE_POINT_ER movedRef, parentRef, FindParentRefPt ();
    short parentValue, newValue, buttons;
    EXPRESSION_CONS_PTR eConsPtr;
    BOOLEAN found, VarFind ();
    char *FindExpString();

    list = FindSelectedObject(YaleSDF, worldX, worldY, GlobalVGT, JustRefPt);

    ResetXYStatus(worldX, worldY);

    if (list.NumOfElements == 0)
        return;

    if (list.NumOfElements > 1)
      {
        TtyBlinkError("Ambiguous selection");
        movedRef = SunInstanceArray[list.Header->item].ptr.refPtr;
        if ((movedRef == OpenCellDefinition->xOriginRef) ||
    	    (movedRef == OpenCellDefinition->yOriginRef))
        list.Header = list.Header->next;
      }

/* Now we are sure that only a single reference point has been selected.
 */

    movedRef = SunInstanceArray[list.Header->item].ptr.refPtr;
    if ((movedRef == OpenCellDefinition->xOriginRef) ||
        (movedRef == OpenCellDefinition->yOriginRef))
    	    return;		/* can't move the origins */
    
    parentRef = FindParentRefPt(movedRef->isXvar ?
        OpenCellDefinition->xOriginRef : OpenCellDefinition->yOriginRef,
        movedRef);
    
    if ((parentRef == OpenCellDefinition->xOriginRef) ||
        (parentRef == OpenCellDefinition->yOriginRef))
    	{
    	parentValue = 0;
    	}
    else
        parentValue =
    	FrameStack[CurrentFB + parentRef->symTblPtr->frameDisplacement];

/* Now adjust the default definition: */

    eConsPtr = OpenCellDefinition-> defaultList;
    found = FALSE;

    while (eConsPtr != NIL && !found)
        {
/*        if (VarFind(&string[eConsPtr->value.string], */
        if (VarFind(FindExpString(eConsPtr->value),
    	movedRef->symTblPtr->stringPtr))
    	    found = TRUE;
        else
    	eConsPtr = eConsPtr->next;
        }
    if (found)
        FreeExpression(eConsPtr->value);
    
/* Now get the new reference point location: */

    TtyPutString("to B:");
    GetMouseClick( &worldX, &worldY, &buttons);
    if (buttons == 7)
	{
	TtyCRLF();
	return;
	}
    ResetXYStatus(worldX, worldY);

    newValue = movedRef->isXvar ? worldX : worldY;
    AddDefaultDisplacement(OpenCellDefinition, movedRef->symTblPtr,
			parentRef, newValue - parentValue, eConsPtr);

    if (OpenCellDefinition != NIL)
	UnSelectAll(OpenCellDefinition);
    XCellExpand(OpenCellDefinition->symTblPtr->stringPtr);
}

/* yaleMoveSelections: moves everything which is selected rigidly to a
 * new position, and attaches everything to the currently selected
 * reference point.  This routine is very much like the rereference
 * routine, and perhaps someday should be consolidated with it.
 */

yaleMoveSelections()
{
    RECTANGLE_CONS_PTR rectConsPtr;
    RECTANGLE_PTR rectPtr;
    REFERENCE_POINT_ER xRefPtr, yRefPtr;
    EXPRESSION MakeRelativeExpression ();
    CELL_INSTANCE_PTR instPtr;
    INSTANCE_CONS_PTR instConsPtr;
    short xStart, yStart, xDisplacement, yDisplacement;
    short xmin, xmax, ymin, ymax;
    short txmin, txmax, tymin, tymax;
    short oldXOrigin, oldYOrigin, buttons;

    xmin = ymin = 32767;
    xmax = ymax = -32767;

    TtyPutString("selections. Move point B: ");
    GetMouseClick( &xStart, &yStart, &buttons);
    if (buttons == 7)
	{
	TtyCRLF();
	return;
	}

    ResetXYStatus(xStart, yStart);
    
    TtyMessage("to B:");
    GetMouseClick( &xDisplacement, &yDisplacement, &buttons);
    TtyCRLF();
    if (buttons == 7)
	return;

    xDisplacement -= xStart;
    yDisplacement -= yStart;

    ResetXYStatus(xStart+xDisplacement, yStart+yDisplacement);
    
    xRefPtr = OpenCellDefinition->xSelectedRef;
    yRefPtr = OpenCellDefinition->ySelectedRef;

    instConsPtr = OpenCellDefinition->selectedSubcellList;
    
    while (instConsPtr != NIL)
      {
        instPtr = instConsPtr->value;
        instConsPtr = instConsPtr->next;
    
        oldXOrigin = evalexp(instPtr->trans.x31, CurrentFB);
        oldYOrigin = evalexp(instPtr->trans.x32, CurrentFB);
        UnLinkDepInstance(instPtr, Horizontal);
        UnLinkDepInstance(instPtr, Vertical);
        FreeExpression(instPtr->trans.x31);
        FreeExpression(instPtr->trans.x32);
    
        instPtr->trans.x31 = MakeRelativeExpression(xRefPtr,
    		oldXOrigin + xDisplacement);
        instPtr->trans.x32 = MakeRelativeExpression(yRefPtr,
    		oldYOrigin + yDisplacement);
    
        LinkDependentInstance(instPtr, yRefPtr);
        LinkDependentInstance(instPtr, xRefPtr);
    }

    rectConsPtr = OpenCellDefinition->selectedRectangleList;

    while (rectConsPtr != NIL)
      {
        rectPtr = rectConsPtr->value;
        rectConsPtr = rectConsPtr->next;
        InquireItem(YaleSDF, rectPtr->sunInstanceNumber, 
		&txmin, &txmax, &tymin, &tymax, NULL, NULL, NULL);
    
        if ((rectPtr->selectedEdgeset) & TopEdge)	/* reref top line */
    	  {
    	    UnLinkDepRectangle(rectPtr, TopEdge);
    	    FreeExpression(rectPtr->t);
    	    rectPtr->t = MakeRelativeExpression(yRefPtr,
	    	tymax + yDisplacement);
    	    ymin = min (ymin, tymax);
    	    ymin = min (ymin, tymax + yDisplacement);
    	    ymax = max (ymax, tymax);
    	    ymax = max (ymax, tymax + yDisplacement);
    	    LinkDependentRectangle(rectPtr, yRefPtr);
    	  }
        if ((rectPtr->selectedEdgeset) & BottomEdge)
          {
    	    UnLinkDepRectangle(rectPtr, BottomEdge);
    	    FreeExpression(rectPtr->b);
    	    rectPtr->b = MakeRelativeExpression(yRefPtr,
    	        tymin + yDisplacement);
    	    ymin = min (ymin, tymin);
    	    ymin = min (ymin, tymin + yDisplacement);
    	    ymax = max (ymax, tymin);
    	    ymax = max (ymax, tymin + yDisplacement);
    	    LinkDependentRectangle(rectPtr, yRefPtr);
    	  }
        if ((rectPtr->selectedEdgeset) & LeftEdge)
    	  {
    	    UnLinkDepRectangle(rectPtr, LeftEdge);
    	    FreeExpression(rectPtr->l);
    	    rectPtr->l = MakeRelativeExpression(xRefPtr,
    	        txmin + xDisplacement);
    	    xmin = min (xmin, txmin);
    	    xmin = min (xmin, txmin + yDisplacement);
    	    xmax = max (xmax, txmin);
    	    xmax = max (xmax, txmin + yDisplacement);
    	    LinkDependentRectangle(rectPtr, xRefPtr);
    	  }
        if ((rectPtr->selectedEdgeset) & RightEdge)
    	  {
    	    UnLinkDepRectangle(rectPtr, RightEdge);
    	    FreeExpression(rectPtr->r);
    	    rectPtr->r = MakeRelativeExpression(xRefPtr,
    	        txmax + xDisplacement);
    	    xmin = min (xmin, txmax);
    	    xmin = min (xmin, txmax + yDisplacement);
    	    xmax = max (xmax, txmax);
    	    xmax = max (xmax, txmax + yDisplacement);
    	    LinkDependentRectangle(rectPtr, xRefPtr);
    	  }
        }
    
/*    if (OpenCellDefinition != NIL)
	UnSelectAll(OpenCellDefinition);
 */
    XCellExpand(OpenCellDefinition->symTblPtr->stringPtr);
}

