/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yaleio.c */

#include "aledefs.h"

#define C_WRITE 1
#define C_OPEN_CONN 3
#define C_CLOSE_CONN 4
#define C_USER_NAME 5
#define C_READ 6
#define C_READ_LIB 7
#define C_WRITE_BAK 8
#define C_INITIALIZE 9

static char UserName[20], Password[20], FileName[30], Host[20];
static char MasterSymbol[20];

static BOOLEAN GotMasterSymbol = FALSE;

extern short OpenInputFile;
BOOLEAN BackupOpen;

static BOOLEAN	GotUserName = FALSE,
		GotConnection = FALSE,
		GotFileName = FALSE;
static PopUpEntry IOPopUp[] =
  {
    "Close Connection", C_CLOSE_CONN,
    "Initialize", C_INITIALIZE,
    "Read Library", C_READ_LIB,
    "User Name", C_USER_NAME,
    "Write", C_WRITE,
    "Write Backup", C_WRITE_BAK,
    0, 0
  };

yaleIO()
{
  short popup();
  char *string, *chptr, *TtyGetPromptedString(), *PutUpRecentMenu();

  switch (popup(IOPopUp))
    {
    case C_WRITE_BAK:
	TtyPutString("Write backup file.\r\n");
	if (!BackupOpen)
	    {
	    string = TtyGetPromptedString("Backup file name:", TRUE);
	    if (!XOpenFile(string, UserName, Password, BACKUPFILE))
		{
		TtyBlinkError("Open Backup File Failed");
		return;
		}
	    BackupOpen = TRUE;
	    }
	if (!GotMasterSymbol)
	    {
	    TtyPutString("Write main file.  Master sympbol M:");
	    string = PutUpRecentMenu();
	    if ((string == NIL) || (*string == '\0'))
		return;
	    chptr = MasterSymbol;
	    while (*chptr++ = *string++);
	    GotMasterSymbol = TRUE;
	    }
	TtyCRLF();
	ResetOutputFile(BACKUPFILE);
	XPrintFile(MasterSymbol, BACKUPFILE);
	OutputString(NIL, BACKUPFILE);
	break;

    case C_USER_NAME:
	TtyPutString("Get user name/password\r\n");
	GetUserName();
	break;

    case C_INITIALIZE:
	TtyPutString("Initialize connection.\r\n");
	LeafInit();
	break;

    case C_CLOSE_CONN:
	TtyPutString("Close connection.\r\n");
	if (!GotConnection)
	    return;
	if (XCloseConnection())
	    GotConnection = FALSE;
	break;

    case C_WRITE:
	TtyPutString("Write main file.\r\n");
	if (!GotMasterSymbol)  
	  {
	    TtyPutString("Master sympbol M:");
	    string = PutUpRecentMenu();
	    if ((string == NIL) || (*string == '\0'))
		return;
	    chptr = MasterSymbol;
	    while (*chptr++ = *string++);
	    GotMasterSymbol = TRUE;
	    TtyCRLF();
	  }
	ResetOutputFile(MAINFILE);
	XPrintFile(MasterSymbol, MAINFILE);
	OutputString(NIL, MAINFILE);
	break;

    case C_READ_LIB:
	TtyPutString("Read library file.\r\n");
	string = TtyGetPromptedString("Library File Name:", TRUE);
	if (!XOpenInFile(string, UserName, Password))
	    {
	    TtyBlinkError("Open Library File Failed");
	    return;
	    }
	LexSource = (char *) -1;
	OpenInputFile = LIBFILE;
	ParseFile();
	LexSource = NIL;
	XCloseFile(LIBFILE);
	return;
    }
}

GetUserName()
  {
    char *string, *charPtr, *TtyGetPromptedString();

    string = TtyGetPromptedString("User Name:", TRUE);

    charPtr = &(UserName[0]);
    while (*string)
        *charPtr++ = *string++;
    *charPtr = 0;

    string = TtyGetPromptedString("Password:", FALSE);
    
    charPtr = &(Password[0]);
    while (*string)
        *charPtr++ = *string++;
    *charPtr = 0;
    
    GotUserName = TRUE;
}

GetConnection(oldStyle)
  {
    char *string, *TtyGetPromptedString ();
    
    if (!oldStyle) return(GotConnection = TRUE);
    string = TtyGetPromptedString("Host: (CR for Shasta)", TRUE);
    if (*string == 0)
        string = "shasta";
    
    if (!XOpenConnection(string))
      {
        TtyBlinkError("Connection Failed");
        return;
      }
    GotConnection = TRUE;
}

/* LeafInit: Opens up a connection to shasta, and snarfs the required
 * input file.  Great changes will occur here later.
 */

LeafInit(oldStyle)
  {
    char *string, *charPtr, *TtyGetPromptedString();

    GetConnection(oldStyle);
    if (!GotConnection) return;

    if (oldStyle)
        GetUserName();
    
    string = TtyGetPromptedString("Main File Name:", TRUE);
    
    charPtr = &(FileName[0]);
    while (*string)
        *charPtr++ = *string++;
    *charPtr = 0;
    
    if (FileName[0] == 0)
        return;
    
    if (!XOpenFile(FileName, UserName, Password, MAINFILE))
      {
        TtyBlinkError("Open File Failed");
        return;
      }
    

    if (GetFileLength(MAINFILE) == 0)	/* its a new file */
	return;				/* don't try to read it */
    LexSource = (char *) -1;
    OpenInputFile = MAINFILE;
    ParseFile();

    GotFileName = TRUE;
    ResetFileName(FileName);
    TtyCRLF();

    LexSource = NIL;
    return;
}

/* ResetScratchFile: if necessary, opens the scratch file, and sets
 * things up so that the next read or write occurs at the beginning of the
 * file.  It returns 1 if successful and 0 if not.
 */

#define ScratchFileName "_yale_scratch"

ResetScratchFile()
{
  static BOOLEAN ScratchFileOpenP = FALSE;

  if (!ScratchFileOpenP)	/* gotta open the scratch file */
      {
      if (!XOpenFile(ScratchFileName, UserName, Password, SCRATCHFILE))
	  {
	  TtyBlinkError("Open Scratch File Failed");
	  return(0);
	  }
      ScratchFileOpenP = TRUE;
      }
  ResetOutputFile(SCRATCHFILE);
  return(1);
}
