/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yaleinsert.c */

#include "aledefs.h"

extern short CurrentFB;

yaleInsRefPt()
{
  char *string, *TtyGetPromptedString();
  short relRefX, relRefY, button;
  REFERENCE_POINT_ER refPtr;
  LISTTYPE FindSelectedObject (), list;
  short globalName, displacement, openCellSin, worldMouseX, worldMouseY;
  short saveSelectedRef;
  short xmin, xmax, ymin, ymax;

  TtyPutString("ref. pt. relative to ref pt. B: ");
  GetMouseClick( &relRefX, &relRefY, &button);
  if (button == 7)
      {
      TtyCRLF();
      return;
      }
  list = FindSelectedObject(YaleSDF,relRefX, relRefY, GlobalVGT, JustRefPt);
  if (list.NumOfElements == 0)
       {
       TtyCRLF();
       return;
       }
/*	Shouldn't be necessary -- TRD 
  if (list.NumOfElements > 1)
      {
      TtyCRLF();
      TtyBlinkError("Ambiguous Selection");
      return;
      }
 */  
  TtyPutString("\012\015New position B:");
  GetMouseClick( &worldMouseX, &worldMouseY, &button);
  if (button == 7)
      {
      TtyCRLF();
      return;
      }
  string = TtyGetPromptedString("Reference Point Name:", TRUE);
  lowercasestring(string);
    
  refPtr = SunInstanceArray[globalName = list.Header->item].ptr.refPtr;
  saveSelectedRef = (refPtr->isXvar) ?
      OpenCellDefinition->xSelectedRef->sunInstanceNumber :
      OpenCellDefinition->ySelectedRef->sunInstanceNumber;
    
  XSelectRefPt(globalName);
    
  InquireItem(YaleSDF, globalName, &xmin, &xmax, &ymin, &ymax, NULL, NULL, NULL);
  displacement = (refPtr->isXvar) ?
       worldMouseX -(xmax+xmin)/2 :
       worldMouseY -(ymax+ymin)/2;

  if (XInsRefPt(refPtr->isXvar ? Vertical : Horizontal,
		     displacement, string) == -1) /* failure */
	return;
  refPtr = refPtr->son;	/* point to new one */

  openCellSin = OpenCellDefinition->expandedSunIds[2];
  EditSymbol(YaleSDF, openCellSin);
  if (refPtr->isXvar)
    {
      AddItem(YaleSDF, refPtr->sunInstanceNumber,
	  worldMouseX - 3, worldMouseX + 3, -32767, 32767,
	  worldMouseX, SDF_VERTICAL_REF, refPtr->symTblPtr->stringPtr);
      FrameStack[CurrentFB + refPtr->symTblPtr->frameDisplacement]
		 	   = worldMouseX;
    }
  else
    {
      AddItem(YaleSDF, refPtr->sunInstanceNumber, -32767,
	  32767, worldMouseY - 3, worldMouseY + 3, worldMouseY,
	  SDF_HORIZONTAL_REF, refPtr->symTblPtr->stringPtr);
      FrameStack[CurrentFB + refPtr->symTblPtr->frameDisplacement]
			    = worldMouseY;
    }
  EndSymbol(YaleSDF, openCellSin, 0);

  XSelectRefPt(saveSelectedRef);
  yaleSelectRefPoint (refPtr->sunInstanceNumber);
}

