/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yalefe.c 
 *
 * Implementation of the new YALE interface, aimed at CADLINC and SUN
 * Microsystems SUNs.
 *
 * VAX conditionals added by Bill Nowicki October 1, 1982
 */

#include "aledefs.h"

extern BOOLEAN BackupOpen;
PROCESS_LAYER DefaultLayer = NM;
short DefaultLayerWidth = 4;

extern short AltSDF;

short Debug;

short 	DefaultPolyWidth = 2,
	DefaultDiffWidth = 2,
	DefaultMetalWidth = 4,
	DefaultBuriedWidth = 6,
	DefaultGlassWidth = 4,
	DefaultImplantWidth = 4,
	DefaultContactWidth = 2;

/* YALE menu definitions: */

#define C_CREATE 1
#define C_DEFAULT 2
#define C_DELETE 3
#define C_EXPAND 4
#define C_IO 5
#define C_MOVE 6
#define C_QUIT 7
#define C_REREF 8
#define C_SELECT 9
#define C_DEBUG 10
#define C_CELL_DEF 11
#define C_CELL_INST 12
#define C_REF_PT 13
#define C_SELECTIONS 16
#define C_ADD_SELECT 17
#define C_REF_PT_DEPS 18
#define C_ARRAY 19
#define C_WINDOW 20
#define C_SHOW 21
#define C_COPY_DEF 22

static PopUpEntry mainPopup[] =
  {
    "Create/Insert", C_CREATE,
    "Default Widths", C_DEFAULT,
    "Delete", C_DELETE,
    "Expand Cell", C_EXPAND,
    "Input/Output", C_IO,
    "Move", C_MOVE,
    "Quit", C_QUIT,
    "Re-reference", C_REREF,
    "Select", C_SELECT,
    "Show", C_SHOW,
    "Debug", C_DEBUG,
# ifndef VAX
    "Window Manager", C_WINDOW,
# endif
    0, 0
   };

static PopUpEntry createPopup[] =
  {
    "Array", C_ARRAY,
    "Cell Definition", C_CELL_DEF,
    "Cell Instance", C_CELL_INST,
    "Copy of Cell Defn", C_COPY_DEF,
    "Reference Point", C_REF_PT,
    0, 0
  };

static PopUpEntry deletePopup[] =
  {
    "Cell Definition", C_CELL_DEF,
    "Reference Point", C_REF_PT,
    "Selections", C_SELECTIONS,
    0, 0
  };

static PopUpEntry movePopup[] =
  {
    "Selections", C_SELECTIONS,
    "Reference Point", C_REF_PT,
    0, 0
  };

static PopUpEntry selectPopup[] =
  {
    "Add Selection", C_ADD_SELECT,
    "Ref Pt. Dependents", C_REF_PT_DEPS,
    0, 0
  };

static PopUpEntry depthPopup[] =
  {
    "0", 0,
    "1", 1,
    "2", 2,
    "3", 3,
    "4", 4,
    "5", 5,
    "all", 32767,
    "Typein", 9,
    0, 0
  };

/* Tokens for the last command issued */

#define CMD_NONE 1
#define CMD_INS_RECT 2
#define CMD_SELECT 3
#define CMD_CREATE_REF 4
#define CMD_CREATE_CELL_INS 5
#define CMD_CREATE_CELL_DEF 6
#define CMD_DEFAULT_WIDTH 7
#define CMD_DEFAULT_EXP 8
#define CMD_DEL_SELNS 9
#define CMD_DEL_CELL_DEF 10
#define CMD_EXPAND 11
#define CMD_IO_INIT 12
#define CMD_IO_OPEN 13
#define CMD_IO_CLOSE 14
#define CMD_IO_USER 15
#define CMD_IO_SET_MAIN 16
#define CMD_IO_READ_MAIN 17
#define CMD_IO_WRITE_MAIN 18
#define CMD_IO_READ_AUX 19
#define CMD_IO_WRITE_AUX 20
#define CMD_MOVE_SELNS 21
#define CMD_MOVE_REF 22
#define CMD_REREF 23
#define CMD_ADD_SELN 24
#define CMD_SEL_REF_DEPS 25
#define CMD_LAYER_SELECT 26
#define CMD_SET_DEPTH 27
#define CMD_SET_WIDTH 28
#define CMD_CREATE_ARRAY 29

short YaleSDF;

static initialize(oldStyle)
{
    YaleSDF = CreateSDF();
    InitSunInstanceArray();
    SymbInit();	
    InitTtyVGT();
    TtyPutString("Distributed Layout Editor\r\n");
    TtyPutString("Copyright (c) 1983 Stanford University\r\n");    
    InitStatusVGT();
    
	/* 
	 * create a default sized graphics window,
	 * without any cell definitions in it yet
	 */
    GlobalVGT = CreateVGT(YaleSDF, GRAPHICS + ZOOMABLE, 0, "Yale Editor");
    if (oldStyle)
        CreateView(GlobalVGT, 500, 120, 1000, 720, 0, 0, 2, TRUE);
    else
        CreateView(GlobalVGT, 16, 16, 536, 280, 0, 0, 1, TRUE);

    lexinit();
    LeafInit(oldStyle);
}

main1(oldStyle)
  {
    initialize(oldStyle);
    mainYaleLoop();
  }

SignalCatcher()
  {
    TtyBlinkError("YALE Aborted");
    Quit();
  }


mainYaleLoop()
  {
    short x, y, buttons;
    short display;

    while (TRUE)
      {
        display = GetMouseClick( &x, &y, &buttons);
        DoMouseCommand(x, y, buttons, display);
      }
}

static short LastCommand = CMD_NONE;
char *TtyGetString();

DoMouseCommand(x, y, buttons, display)
  short x, y, buttons, display;
{
  short popCommand, popup();

  if (display == StatusVGT)
    {
      StatusLayerSelect(x, y);
      TtyPutString("Select default layer.\012\015");
/*      LastCommand = CMD_LAYER_SELECT; */
      return;
    }
    
  if (display != GlobalVGT)
    {
      if (Debug) printf("Weird display %d, global=%d\r\n", display, GlobalVGT );
      return;
    }

  switch (buttons)
      {
      case LeftButton+RightButton:	/* nonsense */
# ifdef VAX
	  DeleteVGT(StatusVGT,1);
	  DeleteVGT(GlobalVGT,1);
	  DeleteSDF(AltSDF);
	  DeleteSDF(YaleSDF);
	  Quit();	/* escape hatch for debugging */
# endif VAX
      case 0:				/* impossible (?) */
      case MiddleButton+RightButton:	/* nonsense */
      case LeftButton+RightButton+
      	MiddleButton:			/* three button abort */
	  return;

      case LeftButton+MiddleButton:
	  CommandRepeat(x, y);
	  return;

      case LeftButton:	/* insert rectangle */
	  TtyPutString("Add rectangle: bug other end with MB1 B.\012\015");
	  yaleInsertRectangle(x, y);
/*	  LastCommand = CMD_INS_RECT; */
	  return;

      case MiddleButton:	/* select item */
	  TtyPutString("Select item.\012\015");
	  yaleselect(x, y, TRUE);
/*	  LastCommand = CMD_SELECT; */
	  return;

      case RightButton:	/* main popup */
	  DoMainYalePopup();
	  return;
      }
}

/* CommandRepeat: repeats the last useful command.  At present, those
 * are defined to be Add Selection, Delete Selections, and Create Cell
 * Instance.  For now, the user will just have to remember what the last
 * one was.
 */

CommandRepeat(x, y)
  short x, y;
{
  switch(LastCommand)
      {
      case CMD_NONE:
	  return;
      case CMD_ADD_SELN:
	  TtyPutString("\015Add to selections.\012\015");
	  yaleselect(x, y, FALSE);
	  return;
      case CMD_DEL_SELNS:
	  TtyPutString("Delete selections.\012\015");
	  yaleDeleteSelections();
	  return;
      case CMD_CREATE_CELL_INS:
	  yaleInsertSymbol();
	  return;
      }
}

DoMainYalePopup()
{
  short popCommand, popup();
  char *string, *TtyGetPromptedString(), *PutUpRecentMenu();

  popCommand = popup(mainPopup);
  switch (popCommand)
    {
      case C_CREATE:
	  TtyPutString("Create ");
	  DoCreatePopup();
	  break;

      case C_DEFAULT:
	  GetDefaultWidth();
	  break;

      case C_DELETE:
	  TtyPutString("Delete ");
	  DoDeletePopup();
	  break;

      case C_EXPAND:
	  TtyPutString("Expand cell named M:");
	  string = PutUpRecentMenu();
	  lowercasestring(string);
	  TtyCRLF();
	  if ((string == NIL) || (*string == '\0'))
	      return;
	  XOpenCellDef(string);
	  XCellExpand(string);
	  ResetCellName(string);
	  TouchString(string);

/*	  LastCommand = CMD_EXPAND; */
	  break;
      case C_IO:
	  TtyPutString("I/O: ");
	  yaleIO();
	  break;

      case C_MOVE:
	  TtyPutString("Move ");
	  DoMovePopup();
	  break;

      case C_QUIT:
	  string = TtyGetPromptedString("Type \"y<CR>\" to confirm: ", TRUE);
	  if ((string[0] == 'Y' || string[0] == 'y') && string[1] == 0)
	    {
	      OutputString(NIL, MAINFILE);
	      XCloseFile(MAINFILE);
	      if (BackupOpen)
		{
		  OutputString(NIL, BACKUPFILE);
		  XCloseFile(BACKUPFILE);
		}
	      XCloseConnection();
	      DeleteVGT(StatusVGT,1);
	      DeleteVGT(GlobalVGT,1);
	      DeleteSDF(AltSDF);
	      DeleteSDF(YaleSDF);
	      Quit();
	    }
	  break;

      case C_REREF:
	  yaleReReference();
	  break;

      case C_SELECT:
	  TtyPutString("Select ");
	  DoSelectPopup();
	  break;

      case C_SHOW:
	  TtyPutString("Show Cell Definition Names\012\015");
	  yaleShowCellNames();
	  break;

      case C_DEBUG:
	  Debug = !Debug;
	  break;
      case C_WINDOW:
	  manager();
	  break;
      }
}

DoCreatePopup()
{
  short popCommand, popup();
  char *string, *TtyGetPromptedString();
  char oldName[20], *ptr;

  switch (popCommand = popup(createPopup))
    {
      case C_ARRAY:
	  yaleInsertArray();
/*	  LastCommand = CMD_CREATE_ARRAY; */
	  return;

      case C_COPY_DEF:
	  TtyPutString("copy of cell named T: ");
	  string = PutUpRecentMenu();
	  if ((string == NIL) || (*string == '\0'))
	    {
	      TtyCRLF();
	      return;
	    }
	  lowercasestring(string);
	  strcpy(oldName, string);
	  string = TtyGetPromptedString("New cell name T: ",TRUE);
	  lowercasestring(string);
	  if (*string == '\0')
	      return;
	  XCopyCellDef(oldName, string);
	  TouchString(string);
	  XOpenCellDef(string);
	  XCellExpand(string);
	  ResetCellName(string);
	  return;

      case C_CELL_DEF:
	  string = TtyGetPromptedString("cell named T: ",TRUE);
	  lowercasestring(string);
	  if (*string == '\0')
	      return;
    	  XInsCellDef(string);
    	  TouchString(string);
    	  XOpenCellDef(string);
    	  XCellExpand(string);
    	  ResetCellName(string);
/*	  LastCommand = CMD_CREATE_CELL_DEF; */
	  return;

      case C_CELL_INST:
	  yaleInsertSymbol();
	  LastCommand = CMD_CREATE_CELL_INS;
	  ResetRepeatCmd("Create Inst");
	  return;

      case C_REF_PT:
	  yaleInsRefPt();
/*	  LastCommand = CMD_CREATE_REF; */
	  return;
      }
}



DoDeletePopup()
{
  short popCommand, popup();
  char *cellName, *PutUpRecentMenu();

  switch (popCommand = popup(deletePopup))
    {
      case C_REF_PT:
	  yaleDelRefPt();
	  return;
      case C_SELECTIONS:
	  TtyPutString("selections.\012\015");
	  yaleDeleteSelections();
	  LastCommand = CMD_DEL_SELNS;
	  ResetRepeatCmd("Delete Selns");
	  return;
      case C_CELL_DEF:
	  TtyPutString("cell definition M:");
	  cellName = PutUpRecentMenu();
	  lowercasestring(cellName);
	  TtyCRLF();
	  if ((cellName == NIL) || (*cellName == '\0'))
	      return;
	  yaleDelCellDef(cellName);
/*	  LastCommand = CMD_DEL_CELL_DEF; */
	  return;
    }
}

DoSelectPopup()
{
  short popCommand, popup(), x, y, display;

  switch (popCommand = popup(selectPopup))
      {
      case C_ADD_SELECT:
	  TtyPutString("\015Add to selections.\012\015");
	  display = GetMouseClick(&x, &y, NULL);
	  if (display != GlobalVGT)
	      return;
	  yaleselect(x, y, FALSE);
	  LastCommand = CMD_ADD_SELN;
	  ResetRepeatCmd("Add Selns");
	  return;
      case C_REF_PT_DEPS:
	  TtyPutString("items dependent on ref. pt. B:");
	  display = GetMouseClick(&x, &y, NULL);
	  TtyCRLF();
	  if (display != GlobalVGT)
	      return;
	  yaleSelectDependentItems(x, y);
/*	  LastCommand = CMD_SEL_REF_DEPS; */
	  return;
      }
}

DoMovePopup()
{
  short popCommand, popup(), x, y, display;

  switch (popCommand = popup(movePopup))
      {
      case C_SELECTIONS:
	  yaleMoveSelections();
/*	  LastCommand = CMD_MOVE_SELNS; */
	  return;
      case C_REF_PT:
	  TtyPutString("reference point from B: ");
	  display = GetMouseClick(&x, &y, NULL);
	  if (display != GlobalVGT)
	      {
	      TtyCRLF();
	      return;
	      }
	  yaleMoveRefPoint(x, y);
	  TtyCRLF();
	  return;	  
      }
}

static PopUpEntry layerPopUp[] =
  {
    "Buried", NB,
    "Contact cut", NC,
    "Diffusion", ND,
    "Glass", NG,
    "Implant", NI,
    "Metal", NM,
    "Polysilicon", NP,
    0, 0
  };

static PopUpEntry widthPopUp[] =
  {
    "2", 2,
    "3", 3,
    "4", 4,
    "5", 5,
    "6", 6,
    "8", 8,
    "16", 16,
    "Typein", 9,
    0, 0
  };

GetNumberFromMenu(numberPopUp)
PopUpEntry *numberPopUp;
{
  short popup(), width;

  width = popup(numberPopUp);
  if (width == 9)
      {
      TtyCRLF();
      width = TtyGetNumber("Type number:");
      }
  return(width);
}

GetDefaultWidth()
{
    short popup(), width;
    PROCESS_LAYER layer;
    
    TtyPutString("Default width for layer M:");
    layer = popup(layerPopUp);
    if (layer != -1)
      {
	TtyPutString(" is M:");
        width = GetNumberFromMenu(widthPopUp);
        if (width == -1)
    	    layer = -1;
      }
    
    TtyCRLF();
    if (layer == DefaultLayer)
        DefaultLayerWidth = width;
    
    switch (layer)
    {
    case NB:
	DefaultBuriedWidth = width;
	break;
    case NC:
	DefaultContactWidth = width;
	break;
    case ND:
	DefaultDiffWidth = width;
	break;
    case NG:
	DefaultGlassWidth = width;
	break;
    case NI:
	DefaultImplantWidth = width;
	break;
    case NM:
	DefaultMetalWidth = width;
	break;
    case NP:
	DefaultPolyWidth = width;
	break;
    }
  WriteWidthLine ();
}

