/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: yaledelete.c */

#include "aledefs.h"

yaleDelRefPt()
{
  short refX, refY, buttons;
  REFERENCE_POINT_ER refPtr;
  LISTTYPE FindSelectedObject(), list;
  short globalId, sin;

  TtyPutString("reference point at B:");
  GetMouseClick(&refX, &refY, &buttons);
  TtyCRLF();
  if (buttons == 7)
      return;
  list = FindSelectedObject(YaleSDF, refX, refY, GlobalVGT, JustRefPt);
  if (list.NumOfElements == 0)
      return;
  globalId = list.Header->item;
  /*refPtr = SunInstanceArray[globalId = list.Header->item].ptr.refPtr;*/
  if (XDelRefPt(globalId))/*RemoveReferencePoint(refPtr)*/
      {
      sin = OpenCellDefinition->expandedSunIds[2];
      EditSymbol(YaleSDF, sin);
      DeleteItem(YaleSDF, globalId);
      EndSymbol(YaleSDF, sin, GlobalVGT);
      }
}

/* yaleDeleteSelections: deletes everything which is currently selected
 * (except for reference points).  Right now, all it does is delete
 * rectangles and cell instances.
 */

yaleDeleteSelections()
{
    RECTANGLE_CONS_PTR rectConsPtr;
    RECTANGLE_PTR rectPtr;
    INSTANCE_CONS_PTR instConsPtr;
    CELL_INSTANCE_PTR instPtr;
    short sin, rectNum, symNum;

    if (OpenCellDefinition == NIL)
        return;
    rectConsPtr = OpenCellDefinition->selectedRectangleList;
    sin = OpenCellDefinition->expandedSunIds[2];
    EditSymbol(YaleSDF, sin);
    while (rectConsPtr != NIL)
      {
        rectPtr = rectConsPtr->value;
        rectConsPtr = rectConsPtr->next;
	if (rectPtr==NIL) continue;
        if (rectPtr -> selectedEdgeset == AllEdges)
    	  {
    	    rectNum = rectPtr->sunInstanceNumber;
    	    RemoveRectangle(rectPtr);
    	    DeleteItem(YaleSDF, rectNum);		/* erase rectangle */
    	    DeleteItem(YaleSDF, rectNum + EDGECODE);	/* and outline     */
    	  }
      }
    
    instConsPtr = OpenCellDefinition->selectedSubcellList;
    while (instConsPtr != NIL)
      {
        instPtr = instConsPtr->value;
        instConsPtr = instConsPtr->next;
	if (instPtr==NIL) continue;
        symNum = instPtr->sunInstanceNumber;
        
        RemoveCellInstance(instPtr);
    
        /* Now we need to remove the outline, the call, and the symbol
         * definition itself from the SDF.
         */
        DeleteItem(YaleSDF, symNum);
        DeleteItem(YaleSDF, symNum + EDGECODE);
      }
    
    EndSymbol(YaleSDF, sin, GlobalVGT);
 }

yaleDelCellDef (cellName)
char *cellName;
{
    S_ENTRY_PTR sEntry, LookupSTableEntry ();
    CELL_DEFINITION_PTR deleteCellDef, saveCellDef;
    
    if ((!(sEntry = LookupSTableEntry(cellName, 0))) ||
    	(sEntry->symbolType != SYMBOL_ENTRY))
        {
        TtyBlinkError("Definition not found");
        return;
        }
    deleteCellDef = sEntry->data.symbol.cellPtr;
    
    if (deleteCellDef->instance_list != NIL)
      {
        TtyBlinkError("Definition in use");
        return;
      }
    
/* Looks like it is OK to delete it -- actually, all that will be done
 * is to clobber its symbol-table entry.  +++ Later, we can fix this up to
 * recover all of the free storage.  We must, however, free up its
 * list of symbol calls.
 */

    saveCellDef = OpenCellDefinition;
    OpenCellDefinition = deleteCellDef;

    while (deleteCellDef -> cells != NIL)
        RemoveCellInstance(deleteCellDef->cells);
    while (deleteCellDef -> rectangles != NIL)
	RemoveRectangle(deleteCellDef ->rectangles);
    FreeCellInstance(deleteCellDef->masterInstance);
    FreeRefPtTree(deleteCellDef->xOriginRef);
    FreeRefPtTree(deleteCellDef->yOriginRef);
    FreeConsList(deleteCellDef->localList);
    FreeConsList(deleteCellDef->parameterList);
    FreeConsList(deleteCellDef->exportList);

    FreeSymbolTableEntry(deleteCellDef->symTblPtr);
    UnTouchString(cellName);
    
    OpenCellDefinition = saveCellDef;

    if (deleteCellDef == OpenCellDefinition)
      {
        OpenCellDefinition = NIL;
        ResetCellName("(none)");
        DeleteSDF(YaleSDF);
        YaleSDF = CreateSDF();	/* WIN */
/*	    {
	    char data[20];
	    sprintf(data, "New SDF: %d\n", YaleSDF);
	    TtyMessage(data);
	    }
 */
	DisplayItem(YaleSDF, 0, GlobalVGT );
      }

	/* now free the cell def from the master cell def, and free it.
	 */

    UnlinkCellDef(deleteCellDef);
    FreeCellDef(deleteCellDef);
}

UnlinkCellDef(cellDef)
  CELL_DEFINITION_PTR cellDef;
{
  CELL_DEFINITION_PTR savePtr;

  if (cellDef == MasterCellList)
      {
      MasterCellList = cellDef->next;
      return;
      }
  savePtr = MasterCellList;
  while (savePtr != NIL)
      {
      if (savePtr->next == cellDef)
	  {
	  savePtr->next = savePtr->next->next;
	  return;
	  }
      savePtr = savePtr->next;
      }
}

FreeRefPtTree(refPtr)
  REFERENCE_POINT_ER refPtr;
{
  if (refPtr->son)
      FreeRefPtTree(refPtr->son);
  if (refPtr->next)
      FreeRefPtTree(refPtr->next);
  FreeConsList(refPtr->dependentRectangles);
  FreeConsList(refPtr->dependentInstances);
  FreeSymbolTableEntry(refPtr->symTblPtr);
  FreeReferencePoint(refPtr);
}

FreeConsList(consPtr)
  CONS_PTR consPtr;
{
  CONS_PTR saveCons;

  while (consPtr != NIL)
      {
      saveCons = consPtr;
      consPtr = consPtr->next;
      FreeCons(saveCons);
      }
}
