/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE yalebox.c */

#include "aledefs.h"

extern short CurrentFB;
extern PROCESS_LAYER DefaultLayer;
extern short DefaultLayerWidth;

/* yaleInsertRectangle:  Gets the mouse clicks and figures out where
 * the wire should go.  A wire of the default width is assumed.
 * +++ ought to do some checking to make sure that the mouse is in the
 * proper window.
 * returns 1 if the rectangle is successfully inserted; 0 otherwise.
 */

yaleInsertRectangle(x1,y1)
    short x1, y1;
  {
  	/*
	 * insert a rectange with one point already clicked at x1, y1.
	 * we wait for the other click.
	 */
    short x2, y2;
    short dx, dy, temp, button;
    short vgt2, sin;
    EXPRESSION top, bottom, left, right, MakeRelativeExpression();
    RECTANGLE_PTR rect, MakeRectangle();

    ResetXYStatus(x1, y1);
    if (OpenCellDefinition == NIL)
      {
        TtyBlinkError("No cell open");
        return(0);
      }
    
    vgt2 = GetMouseClick( &x2, &y2, &button);	

    if (button != LeftButton)
        return(0);
    
    if (vgt2 != GlobalVGT)
        return(0);

    ResetXYStatus(x2, y2);

/* Now we've got the two clicks -- we need to decide whether the wire
 * is basically vertical or horizontal.
 */

    dx = x2 - x1;
    dy = y2 - y1;

    if (abs(dy) < abs(dx))
      {
        y2 = y1 + DefaultLayerWidth;	/* we are in half-lambda coords */
        y1 -= DefaultLayerWidth;
        if (dx < 0)
    	  {
	    temp = x1;
	    x1 = x2;
	    x2 = temp;
	  }
      }
    else
      {
        x2 = x1 + DefaultLayerWidth;
        x1 -= DefaultLayerWidth;
        if (dy < 0)
      	  {
    	    temp = y1;
    	    y1 = y2;
    	    y2 = temp;
    	  }
      }

/* Now we've got to build a box from (x1, y1) to (x2, y2), where (x1, y1)
 * is guaranteed to be the lower left corner in the world coordinates.
 */

    top = MakeRelativeExpression(OpenCellDefinition->ySelectedRef, y2);
    bottom = MakeRelativeExpression(OpenCellDefinition->ySelectedRef, y1);
    left = MakeRelativeExpression(OpenCellDefinition->xSelectedRef, x1);
    right = MakeRelativeExpression(OpenCellDefinition->xSelectedRef, x2);
    
    rect = MakeRectangle(OpenCellDefinition, left, right, top, bottom, 
    		DefaultLayer);
    if (rect == NIL)
	return(0);	/* out of free storage */    
    sin = OpenCellDefinition->expandedSunIds[2]; /* 2 = identity hash */
    EditSymbol(YaleSDF, sin);
    PlopRectangle(x1, x2, y2, y1, DefaultLayer, 0, rect->sunInstanceNumber);
    EndSymbol(YaleSDF, sin, GlobalVGT);

/* The next line selects the newly added rectangle, and unselects
 * everything else which is currently selected.  The two 32767's are to
 * make sure that all four edges of the rectangle are selected, no matter
 * where the rectangle is placed.
 */

    yaleSelectRectangle(rect->sunInstanceNumber, TRUE, 15 /* select all edges */);
    return(1);
}

/* MakeRelativeExpression: Takes a reference pointer (which must be to
 * the currently-open cell), and a set of absolute world coordinates, and
 * generates an expression which describes the relative relation of the
 * two.  We also assume that the current stack frame has not been clobbered.
 */

EXPRESSION MakeRelativeExpression(refPointer, worldCoord)
  REFERENCE_POINT_ER refPointer;
  short worldCoord;
{
    short frameDisplacement, currentValue, displacement;
    char *refPointName, *string = "                                     ",
    	*numb, *saveLex, *MakeHalfNumber ();
    EXPRESSION exp, parseexp();
    
    if (refPointer == OpenCellDefinition->xOriginRef ||
        refPointer == OpenCellDefinition->yOriginRef)
    	currentValue = -32767;
    else
      {
        frameDisplacement = refPointer->symTblPtr->frameDisplacement;  
        refPointName = refPointer->symTblPtr->stringPtr;	/* MMT */
    				/* MMT : moved to account for origin. */
        currentValue = FrameStack[CurrentFB + frameDisplacement];
    						/* +++ assumes 0 base */
      }
    
    if (currentValue != -32767)
      {
        displacement = worldCoord - currentValue;
        numb = MakeHalfNumber(displacement);
        if (displacement < 0)
    	    sprintf(string, "%s%s;", refPointName, numb);
          else
    	    sprintf(string, "%s+%s;", refPointName, numb);
      }
    else
      {
        if (worldCoord == -1)	/* special mechanism (= hack) */
    	    string = "-0.5;";
        else if (worldCoord & 1)
    	    sprintf(string, "%d.5;", worldCoord/2);
        else
    	    sprintf(string, "%d;", worldCoord/2);
      }

    saveLex = LexSource;
    LexSource = string;
    exp = parseexp(OpenCellDefinition->sunInstanceNumber);
    lex();						/* eat the semicolon */
    LexSource = saveLex;
    return(exp);
}

/* MakeHalfNumber: returns a pointer to a string representing the input
 * number divided in half.  If the input is -7, the routine returns a
 * pointer to the string "-3.5".  The string is built in the same place
 * over and over again, so the result should be copied out as soon as it
 * is made.
 */

char *MakeHalfNumber(value)
short value;
{
    static char string[10];

    if (value == -1)
        return("-0.5");
    if (value & 1)
        sprintf(string, "%d.5", value/2);
    else
        sprintf(string, "%d", value/2);
    return(string);
}
