/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/*
 * FILE xroutines.c 
 *
 * Top level routines to compile SDF's from parsed SILT symbols.
 */

#include "aledefs.h"

extern short defStackPtr;

short   CurrentFB;

typedef struct minmaxvector
{
    short   xmin,
            xmax,
            ymin,
            ymax;
}                           MIN_MAX, *MIN_MAX_PTR;

 /* ********************************************** */
 /* 		XAddLocalVar:		 	   */
 /* ********************************************** */

XAddLocalVar (strPtr, varType)
char   *strPtr;
ENTRY_TYPE varType;
{
    int     sin;
    S_ENTRY_PTR sEntry, LookupSTableEntry (), EnterHash ();
    VARIABLE_CONS_PTR vCons;
    CONS_PTR GetCons ();

    if (OpenCellDefinition == NIL)
	sin = 0;
    else
	sin = OpenCellDefinition -> sunInstanceNumber;
    if ((sEntry = LookupSTableEntry (strPtr, sin)) != NIL)
    {
	ErrorPrint (65);
	return;
    }
    sEntry = EnterHash (strPtr, sin);
    sEntry -> symbolType = varType;
    sEntry -> frameDisplacement
	= (OpenCellDefinition -> frameEnd)++;
    sEntry -> data.isExport = FALSE;

    vCons = (VARIABLE_CONS_PTR) GetCons ();
    if (vCons == NIL)
	return;	/* out of free storage */
    vCons -> value = sEntry;
    vCons -> next = OpenCellDefinition -> localList;
    OpenCellDefinition -> localList = vCons;
}

 /* ********************************************** */
 /* 		XAddExportVar:			   */
 /* ********************************************** */

/* XAddExportVar takes the name of a variable to be exported from the
 * cell currently begin edited, and makes sure that all the appropriate
 * data structures are updated.  If no entry for the variable appears, it
 * is added, and if an entry of type xvar, yvar, or scalar appears, it is
 * changed into type export.  The cell (and possibly some others dependent
 * upon it) may be (automatically) recompiled.  If any errors occur,
 * nothing in the cell's data-base is changed.
 */

XAddExportVar (strPtr, varType)
char   *strPtr;
ENTRY_TYPE varType;
{
    int     sin;
    S_ENTRY_PTR sEntry, LookupSTableEntry (), EnterHash ();

    if (OpenCellDefinition == NIL)
    {
	ErrorPrint (58);
	return;
    }

    sin = OpenCellDefinition -> sunInstanceNumber;
    sEntry = LookupSTableEntry (strPtr, sin);

    if (sEntry != NIL && sEntry -> symbolType != varType)
    {
	ErrorPrint (59);
	return;
    }

    if (sEntry == NIL)		/* then life is easy -- just add it. */
    {
	sEntry = EnterHash (strPtr, sin);
	sEntry -> symbolType = varType;
	AddExportVariable (OpenCellDefinition, sEntry, TRUE);
	return;
    }

    AddExportVariable (OpenCellDefinition, sEntry, TRUE);

/* N.B. this leaves the old slot in the local frame, but it won't hurt
 * too much.  We still need to remove it from the local list, however.
 */
    GeneralConsRemove (&(OpenCellDefinition -> localList), sEntry);

}

 /* ********************************************** */
 /* 		XCellExpand:			   */
 /* ********************************************** */

/* XCellExpand takes a cell definition name and expands it.  It works
 * essentially by expanding the master instance of the cell using the
 * recursive routine CellInstExpand.  This is the top level entry
 * to the faster recursive function.
 */

XCellExpand (strPtr)
char   *strPtr;
{
    S_ENTRY_PTR sEntry, LookupSTableEntry ();
    short   fb;			/* frame base */
    MATRIX identity;
    MIN_MAX mm;
    CELL_DEFINITION_PTR cellDefPtr;
    short i, sin;
    INSTANCE_CONS_PTR instConsPtr;

    DeleteSDF(YaleSDF);
    YaleSDF = CreateSDF();	/* WIN */
/*	{
	char data[20];
	sprintf(data, "SDF number: %d\n", YaleSDF);
	TtyMessage(data);
	}
 */
    cellDefPtr = MasterCellList;
    while (cellDefPtr != NIL)
      {
	for (i = 0; i < 8; i++)
	    cellDefPtr->expandedSunIds[i] = 0;
	cellDefPtr = cellDefPtr->next;
      }

    identity.x11 = identity.x22 = 1;
    identity.x12 = identity.x21 = identity.x31 = identity.x32 = 0;

    if ((!(sEntry = LookupSTableEntry (strPtr, 0)))
	|| (sEntry -> symbolType != SYMBOL_ENTRY))
      {
	ErrorPrint (53);
	return;
      }

/* +++ we may need some stuff here to set up the stack_frame */
    CurrentFB = fb =
	EvalParameterList( sEntry -> data.symbol.cellPtr -> masterInstance,
	    sEntry -> data.symbol.cellPtr -> masterInstance, 0);
    sin = CellInstExpand(sEntry -> data.symbol.cellPtr -> masterInstance,
	    fb, &identity, 0);
    if (GlobalVGT != -1)
    	DisplayItem(YaleSDF, sin, GlobalVGT );
    defStackPtr = -1;

/* Now make sure that all the selected instances are so displayed --
 * this is not done by the routine CellInstExpand.
 */

    instConsPtr = OpenCellDefinition->selectedSubcellList;
    while (instConsPtr != NIL)
	{
	yaleSelectCellInstance(instConsPtr->value->sunInstanceNumber, FALSE);
	instConsPtr = instConsPtr->next;
	}
}

 /* ********************************************** */
 /* 		XOpenCellDef:			   */
 /* ********************************************** */

XOpenCellDef (strPtr)
char   *strPtr;
{
    S_ENTRY_PTR sEntry, LookupSTableEntry ();

    if ((!(sEntry = LookupSTableEntry (strPtr, 0)))
	|| (sEntry -> symbolType != SYMBOL_ENTRY))
      {
	ErrorPrint (38);
	return;
      }

    if (OpenCellDefinition != NIL)
	UnSelectAll (OpenCellDefinition);

    OpenCellDefinition = sEntry -> data.symbol.cellPtr;
}

 /* ********************************************** */
 /* 		XDelRefPt:			   */
 /* ********************************************** */

XDelRefPt (sin)
int     sin;
{
    S_ENTRY_PTR sEntry;
    REFERENCE_POINT_ER refPtr;
    EXPRESSION_CONS_PTR ePtr;
    BOOLEAN found, VarFind ();
    char FindExpString();

    if (SunInstanceArray[sin].type != SReferencePoint ||
	    (refPtr = SunInstanceArray[sin].ptr.refPtr) -> containingCell
	    != OpenCellDefinition)
    {
	ErrorPrint (48);
	return(0);
    }
    sEntry = refPtr -> symTblPtr;

/* Make sure that it isn't selected */

    if (refPtr == OpenCellDefinition -> xSelectedRef)
	OpenCellDefinition -> xSelectedRef
	    = OpenCellDefinition -> xOriginRef;
    if (refPtr == OpenCellDefinition -> ySelectedRef)
	OpenCellDefinition -> ySelectedRef
	    = OpenCellDefinition -> yOriginRef;

/* ... and try to remove it */

    ErrorCount = 0;
    RemoveReferencePoint (refPtr);
    if (ErrorCount)
	return(0);		/* Screw up -- abort */

/* At this point, we need to remove the parameter-list entry and the
 * symbol-table entry.
 */
    ePtr = OpenCellDefinition -> defaultList;
    found = FALSE;
    while (ePtr != NIL && !found)
    {
/*	if (VarFind (&string[ePtr -> value.string], sEntry -> stringPtr))*/
	if (VarFind(FindExpString(ePtr->value), sEntry -> stringPtr))
	    found = TRUE;
	else
	    ePtr = ePtr -> next;
    }
    if (found)
	GeneralConsRemove (&(OpenCellDefinition -> defaultList),
		ePtr -> value);

    GeneralConsRemove (&(OpenCellDefinition -> parameterList), sEntry);

/* And finally, remove the symbol table entry. */

    FreeSymbolTableEntry (sEntry);
    return(1);
}

 /* ********************************************** */
 /* 		VarFind:			   */
 /* ********************************************** */

/* VarFind returns TRUE if symStr is an initial string of assStr.
 * It is used to see if assStr is something like foo := ***, where
 * symStr is foo.
 */

BOOLEAN VarFind (assStr, symStr)
char   *assStr,
       *symStr;
{
    while (*symStr)
	if (*(assStr++) != *(symStr++))
	    return (FALSE);
    return (TRUE);
}

 /* ********************************************** */
 /* 		XInsRefPt:			   */
 /* ********************************************** */

int     XInsRefPt (i, displacement, strPtr)
char   *strPtr;
int     i;	/* i == Horizontal or i == Vertical */
int	displacement;	/* in screen coordinates */
{
    S_ENTRY_PTR sEntry, LookupSTableEntry (), EnterHash ();
    REFERENCE_POINT_ER newRefPtr, relRefPt, AddRefSon ();
    int     sin;		/* sun instance number for open cell */

    if (OpenCellDefinition == NIL)
    {
	ErrorPrint (45);
	return (-1);
    }
    sin = OpenCellDefinition -> sunInstanceNumber;
    if (sEntry = LookupSTableEntry (strPtr, sin))
    {
	ErrorPrint (46);
	return (-1);
    }
    sEntry = EnterHash (strPtr, sin);
    if (i == Horizontal)
    {
	relRefPt = OpenCellDefinition -> ySelectedRef;
	newRefPtr = AddRefSon (relRefPt);
	if (newRefPtr == NIL)
	    return;	/* out of free storage */
	sEntry -> symbolType = YVAR_ENTRY;
    }
    else			/* vertical */
    {
	relRefPt = OpenCellDefinition -> xSelectedRef;
	newRefPtr = AddRefSon (relRefPt);
	if (newRefPtr == NIL)
	    return;	/* out of free storage */
	sEntry -> symbolType = XVAR_ENTRY;
    }
    newRefPtr -> symTblPtr = sEntry;
    AddParameter (OpenCellDefinition, sEntry);

    AddDefaultDisplacement (OpenCellDefinition, sEntry,
	    relRefPt, displacement, NIL);
    return (newRefPtr -> sunInstanceNumber);
}

 /* ********************************************** */
 /* 		XSelectRefPt:			   */
 /* ********************************************** */

XSelectRefPt (instNum)
int     instNum;
{
    REFERENCE_POINT_ER refPt;

    if (OpenCellDefinition == NIL)
    {
	ErrorPrint (44);
	return;
    }
    if (SunInstanceArray[instNum].type != SReferencePoint ||
	    SunInstanceArray[instNum].ptr.refPtr -> containingCell
	    != OpenCellDefinition)
    {
	ErrorPrint (47);
	return;
    }
    refPt = SunInstanceArray[instNum].ptr.refPtr;
    if (refPt -> isXvar)
	OpenCellDefinition -> xSelectedRef = refPt;
    else
	OpenCellDefinition -> ySelectedRef = refPt;
}

 /* ********************************************** */
 /* 		XInsRectangle:			   */
 /* ********************************************** */

XInsRectangle (eTop, eBottom, eLeft, eRight, layer)
EXPRESSION eTop, eBottom, eLeft, eRight;
PROCESS_LAYER layer;

{
    RECTANGLE_PTR rPtr, MakeRectangle ();

    if (OpenCellDefinition == NIL)
    {
	ErrorPrint (39);
	return (ERROR);
    }
    rPtr = MakeRectangle (OpenCellDefinition, eLeft, eRight, eTop, eBottom, layer);
    if (rPtr == NIL)
	return(NIL);	/* out of free storage */
    return (rPtr -> sunInstanceNumber);
}

 /* ********************************************** */
 /* 		XRemRectangle:			   */
 /* ********************************************** */

XRemRectangle (sunNum)
int     sunNum;
{
    RECTANGLE_PTR rPtr;

    if (SunInstanceArray[sunNum].type != SRectangle)
    {
	ErrorPrint (40);
	return;
    }
    rPtr = SunInstanceArray[sunNum].ptr.rect_ptr;
    if (rPtr -> containingCell != OpenCellDefinition)
    {
	ErrorPrint (41);
	return;
    }
    RemoveRectangle (rPtr);
}

/* XInsCellDef builds a new cell definition entry having the name
 * pointed to by strPtr.  It is inserted into the symbol table, and
 * initialized.
 */

 /* ********************************************** */
 /* 		XInsCellDef:			   */
 /* ********************************************** */

XInsCellDef (strPtr)
char   *strPtr;
{
    S_ENTRY_PTR sEntry, LookupSTableEntry (), EnterHash ();
    CELL_DEFINITION_PTR cellPtr, MakeCellDefinition ();

    if (sEntry = LookupSTableEntry (strPtr, 0))
    {
	ErrorPrint (37);
	return(0);
    }
    sEntry = EnterHash (strPtr, 0);
    sEntry -> symbolType = SYMBOL_ENTRY;

    cellPtr = MakeCellDefinition (sEntry);
    if (cellPtr == NIL)
	return(0);
    sEntry -> data.symbol.cellPtr = cellPtr;

/* now open the new cell for editing */

    if (OpenCellDefinition != NIL)
	UnSelectAll (OpenCellDefinition);

    OpenCellDefinition = cellPtr;
    return(1);
}

 /* ********************************************** */
 /* 		XDelCellInstance:		   */
 /* ********************************************** */

XDelCellInstance (sin)
short   sin;
{
    CELL_INSTANCE_PTR cellPtr;

    if (SunInstanceArray[sin].type != SCellInstance ||
	    (cellPtr = SunInstanceArray[sin].ptr.instPtr) -> containingCell
	    != OpenCellDefinition)
    {
	ErrorPrint (54);
	return;
    }
    RemoveCellInstance (cellPtr);
}

 /* ********************************************** */
 /* 		XInsCellInstance:		   */
 /* ********************************************** */

CELL_INSTANCE_PTR XInsCellInstance
(cellName, instName, paramList, transPtr)
TRANS_MATRIX *transPtr;
char   *cellName,
       *instName;
EXPRESSION_CONS_PTR paramList;
{
    int     sin,
            expBlockSize;
    S_ENTRY_PTR sEntry, newSEntry, LookupSTableEntry (), EnterHash ();
    CELL_INSTANCE_PTR newCell, MakeCellInstance ();
    CELL_DEFINITION_PTR instanceDef;
    INSTANCE_CONS_PTR GeneralPointerFind ();
    CELL_DEFINITION_CONS_PTR cons;
    CONS_PTR GetCons ();
    REFERENCE_POINT_ER refPtr, FindInvolvedRefPt ();
    BOOLEAN IsCalledBy ();

    if (OpenCellDefinition == NIL)
    {
	ErrorPrint (50);
	return (NIL);
    }
    sin = OpenCellDefinition -> sunInstanceNumber;
    if (LookupSTableEntry (instName, sin))
    {
	ErrorPrint (51);
	return (NIL);
    }
    if ((*cellName) && (!(sEntry = LookupSTableEntry (cellName, 0))
		|| (sEntry -> symbolType != SYMBOL_ENTRY)))
    {
	ErrorPrint (52);
	return (NIL);
    }

/*	Put me back in later +++++++
if (IsCalledBy(sEntry -> data.symbol.cellPtr, OpenCellDefinition))
    {
    TtyBlinkError("Illegal insertion -- recursive call");
    return (NIL);
    }
 */

/* At this point, everything seems OK -- go ahead and insert it */

    newCell
	= MakeCellInstance
	(sEntry -> data.symbol.cellPtr, OpenCellDefinition);
    if (newCell == NIL)
	return(NIL);	/* out of free storage */
/* for debugging:
    printf ("\nInserted %d\n", newCell -> sunInstanceNumber); */

    if (*instName)
    {
	newSEntry = EnterHash (instName, 0);
	newSEntry -> symbolId = sin;
	newSEntry -> symbolType = INSTANCE0_ENTRY;

    /* now we've gotta figure out what this does to the various frames */

	expBlockSize = sEntry -> data.symbol.cellPtr -> exportEnd;
	newSEntry -> frameDisplacement = OpenCellDefinition -> frameEnd;
	OpenCellDefinition -> frameEnd += expBlockSize;

/* Since the instance is named, if its export list ever changes size,
 * the containing cell must be re-compiled.  For that reason, we nust
 * add a dependent cell entry to the including cell's definition, but
 * only if it is not there already.
 */

	instanceDef = newCell -> instanceOf;

	if (!(cons = (CELL_DEFINITION_CONS_PTR)
		    GeneralPointerFind (instanceDef ->
			dependentCells, OpenCellDefinition)))
	{
	    cons = (CELL_DEFINITION_CONS_PTR) GetCons ();
	    if (cons == NIL)
		return(NIL);	/* out of free storage */
	    cons -> value = OpenCellDefinition;
	    cons -> next = instanceDef -> dependentCells;
	    instanceDef -> dependentCells = cons;
	     /* debug +++ */ printf ("added dependent cons\n");
	}

	newSEntry -> data.dim0.cellInstPtr = newCell;
    }
    else
	newSEntry = NIL;
    newCell -> symTblPtr = newSEntry;
    newCell -> parameterList = paramList;
    newCell -> trans.x11 = transPtr -> x11;
    newCell -> trans.x12 = transPtr -> x12;
    newCell -> trans.x21 = transPtr -> x21;
    newCell -> trans.x22 = transPtr -> x22;
    newCell -> trans.x31 = transPtr -> x31;
    newCell -> trans.x32 = transPtr -> x32;

    refPtr = FindInvolvedRefPt(transPtr->x31, Vertical);
    LinkDependentInstance(newCell, refPtr);
    refPtr = FindInvolvedRefPt(transPtr->x32, Horizontal);
    LinkDependentInstance(newCell, refPtr);

    return (newCell);
}

/* IsCalledBy: This routine returns TRUE if checkCell is called by
 * masterCell, either directly or recursively.  It is used to make sure
 * that no loops can be created in cell calling sequences.
 */

BOOLEAN IsCalledBy(masterCell, checkCell)
CELL_DEFINITION_PTR masterCell, checkCell;
{
CELL_INSTANCE_PTR instPtr;

if (masterCell == checkCell)
    return(TRUE);
instPtr = masterCell->cells;	/* point to beginning of list */
while (instPtr != NIL)
    {
    if (IsCalledBy(instPtr->instanceOf, checkCell))
	return(TRUE);
    instPtr = instPtr -> next;
    }
return(FALSE);	/* made it through without finding anything */
}
