/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: symbol.c */

/* Routines for managing a symbol table */

#include "aledefs.h"
/* hash returns an integer between 1 and HASHSIZE.  It
 * assumes that the string is zero-terminated
 */

	/************************************************/
	/*		hash:				*/
	/************************************************/

hash(sp)
char *sp;
{
    int i,j;
    i = 1;
    while (j= *(sp++)) i = i*j + 17;
    if (i < 0) i = -i;
    i %= HASHSIZE;
    return(i);
}

/* LookupHash takes a ptr to a string and sees if there is an 
 * entry for it in the hash table.  A ptr to the entry is 
 * returned if successful, and 0 is returned otherwise. If
 * symbolTablePtr is 0, the search starts from the hash array;
 * otherwise, it starts from symbolTablePtr.  This allows multiple
 * entries of the same name in the symbol table.
 */

	/************************************************/
	/*		LookupHash:			*/
	/************************************************/

S_ENTRY_PTR LookupHash(sp, symbolTablePtr)
char *sp;
S_ENTRY_PTR symbolTablePtr;
{
    S_ENTRY_PTR sPtr;
    if (!(sPtr = symbolTablePtr))
	{
	sPtr = hasharray[hash(sp)];
	if (!sPtr) return(0); /* not found */
	}
    else
	if (!(sPtr = sPtr->link)) return(0);
    while (1)
	{
	if (strcmp(sp, sPtr->stringPtr)) return(sPtr);
	if (!(sPtr = sPtr->link)) return(0);
	}
}

/* EnterHash takes a string ptr and makes an entry in the */
/* symbol table for it.  It does no checking to see if an entry */
/* for the string already exists.  A ptr to the new entry is */
/* returned. */

	/************************************************/
	/*		EnterHash:			*/
	/************************************************/

S_ENTRY_PTR EnterHash(sp, symbolNumber)
char *sp;
short symbolNumber;
{
char *AddString();

    S_ENTRY_PTR sPtr, GetSEntry();
    int hashval;
    hashval = hash(sp);
    sPtr = GetSEntry();
    sPtr->link = hasharray[hashval];
    sPtr->symbolType = UNDEFINED_ENTRY;
    sPtr->symbolId = symbolNumber;
    sPtr->stringPtr = AddString(sp);/*&string[AddString(sp)];*/
    hasharray[hashval] = sPtr;
    return(sPtr);
}

EXPRESSION AddExpression(exp)
  EXPRESSION exp;
{
int len;
char *newspace, *ptr1, *GetStorageChunk();

len = ExpressionLength(exp);
/*printf("len = %d: ", len);	DEBUG */
if ((newspace = GetStorageChunk(len+1)) == 0)
    return(NIL);

ptr1 = newspace;
while(len--)
  {
/*  printf("%d ", (int) *exp);	 DEBUG */
  *ptr1++ = *exp++;
  }
/*putchar('\n');	DEBUG */
*ptr1 = '\0';
return(newspace);
}

	/************************************************/
	/*		AddString:			*/
	/************************************************/

char *AddString(ptr)
char *ptr;
{
int len;
char *newspace, *ptr1, *GetStorageChunk();

len = strlen(ptr);
if ((newspace = GetStorageChunk(len+1)) == 0)
    return(NIL);

ptr1 = newspace;
while (*ptr)
    *ptr1++ = *ptr++;
*ptr1 = '\0';
return(newspace);

/*
unsigned short top;

if (STRINGSIZE - StringTOS < 100)
    TtyMessage("WARNING: String space low!!");
top = StringTOS;
while (string[StringTOS++] = *(ptr++))
    if (StringTOS == STRINGSIZE)
	{
	ErrorPrint(94);
	SignalCatcher();
	}
return(top);
 */
}

/* LowOnSpace: returns true if we are low either on string space, or on
 * expression space.

BOOLEAN LowOnSpace()
{
  if ((STRINGSIZE - StringTOS) < 100)
      return(TRUE);
  if (ExpArrayLength - FreeExp < 100)
      return(TRUE);
  return(FALSE);
}
*/

/* LookupSTableEntry finds an entry matching both the symbol number
 * and the string_name given to it.  It returns NIL if it fails.
 */

	/************************************************/
	/*		LookupSTableEntry:		*/
	/************************************************/

S_ENTRY_PTR LookupSTableEntry(strPtr, symbolNum)
char *strPtr;
int symbolNum;
{
S_ENTRY_PTR sPtr, LookupHash();

if (strPtr == NIL)
    return(NIL);
sPtr = LookupHash(strPtr, NIL);
while (TRUE)
    {
    if (!sPtr)
	return(NIL);
    if (sPtr->symbolId == symbolNum)
	return(sPtr);
    else
	sPtr = LookupHash(strPtr, sPtr);
    }
}

	/************************************************/
	/*		GetConnPoint:			*/
	/************************************************/

short GetConnPoint()
{
    /* brute force method for now */
    static short nextFree = 1;  /* zero is used for NIL */
    if (nextFree < MaxConnPts)
	return(nextFree++);
    ErrorPrint(34);
    return(0);
}

/* strcmp compares two strings for equality and returns 1 or 0 */
/* if they are equal or not */

	/************************************************/
	/*		strcmp:				*/
	/************************************************/

strcmp(sp1, sp2)
char *sp1, *sp2;
{
    if (sp1 == NIL || sp2 == NIL)
	return(0);
    while ((*sp1 != '\0') && (*sp2 != '\0'))
	if (*(sp1++) != *(sp2++)) return(0);
    return(*sp1 == *sp2);
}

/* SymbInit enters all of the reserved words into the symbol table */

struct ResArray_entry {char *str; TOKEN_TYPE word} foo, ResArray[] =
    {
    "all", ALL,
    "and", AND,
    "at", AT,
    "begin", BEGIN,
    "box", BOX,
    "buried", BURIED,
    "butt", BUTT,
    "cif_list", CIF_LIST,
    "connect", CONNECT,
    "constant", CONSTANT,
    "constraint", CONSTRAINT,
    "contact", CONTACT,
    "cut", CUT,
    "default", DEFAULT,
    "diff", DIFF,
    "diff_metal", DIFF_METAL,
    "diff_poly", DIFF_POLY,
    "div", DIV,
    "do", DO,
    "end", END,
    "export", EXPORT,
    "file", PHYLE,
    "flipped", FLIPPED,
    "for", FOR,
    "glass", GLASS,
    "if", IF,
    "implant", IMPLANT,
    "lr", LR,
    "metal", METAL,
    "metal_poly", METAL_POLY,
    "mod", MOD,
    "none", NONE,
    "not", NOT,
    "or", OR,
    "place", PLACE,
    "poly", POLY,
    "rl", RL,
    "rotated", ROTATED,
    "scalar", SCALAR,
    "signal", SIGNAL,
    "symbol", SYMBOL,
    "then", THEN,
    "to", TO,
    "ud", UD,
    "with", WITH,
    "x", X,
    "xmax", XMAX,
    "xmin", XMIN,
    "xvar", XVAR,
    "y", Y,
    "ymax", YMAX,
    "ymin", YMIN,
    "yvar", YVAR
    };

extern S_ENTRY_PTR FreeSEntryPtr;

	/************************************************/
	/*		SymbInit:			*/
	/************************************************/

SymbInit()
{
    S_ENTRY_PTR sPtr;
    int i;

/* First allocate space for the symbol table entries.  We may
 * wish to change this later if we want the user to be able to
 * change the default size allocated by means of a switch.
 */

    SymbolTableSize = DEFAULT_SymbolTableSize;
    MaxConnPts = DEFAULT_MaxConnPts;
/*
    ConnPointArray = (CONNECTION_POINT_ER)
	calloc(MaxConnPts, sizeof(CONNECTION_POINT));
    SymTblArray = (S_ENTRY_PTR)calloc(SymbolTableSize,
						sizeof(S_ENTRY));
*/
/* Now link all of the symbol table entries together on the free list
 * pointed to by FreeSEntryPtr:
 */

FreeSEntryPtr = &(SymTblArray[0]);
for (i=0; i < SymbolTableSize-1; i++)
    {
    SymTblArray[i].link = &(SymTblArray[i+1]);
    }
SymTblArray[SymbolTableSize].link = NIL;

    for (i=0; i < sizeof(ResArray)/sizeof(foo); i++)
	{
	sPtr = EnterHash(ResArray[i].str, 0);
	sPtr->symbolType = RESERVED_ENTRY;
	sPtr->data.word = ResArray[i].word;
	sPtr->symbolId = 0; /* reserved words are defined everywhere */
	}
}
