/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE siltprint.c */

/* 9/20/82 TRD: Hacked ExpPrint to use the string following Eend
 */

#include "aledefs.h"
static char data[100];

	/************************************************/
	/*		XPrintFile:			*/
	/************************************************/

XPrintFile(mainSymbolName, filetype)
  short filetype;
  char *mainSymbolName;
{
CELL_DEFINITION_PTR cellDef;
S_ENTRY_PTR sEntry, LookupSTableEntry();

if (!(sEntry = LookupSTableEntry(mainSymbolName, 0)) ||
	(sEntry->symbolType != SYMBOL_ENTRY))
	    {
	    ErrorPrint(42);
	    return;
	    }

sprintf(data,"\nfile %s_file;\n", mainSymbolName);
OutputString(data, filetype);

cellDef = MasterCellList;
while (cellDef != NIL)
    {
    CPrintCell(cellDef->symTblPtr, filetype, NIL);
    cellDef = cellDef->next;
    }

OutputString("begin\n", filetype);
sprintf(data,"place %s() at (0, 0);\n", mainSymbolName);
OutputString(data, filetype);
OutputString("end.\n", filetype);
}

	/************************************************/
	/*		CPrintCell:			*/
	/************************************************/

/* if newName is NIL, the cell is printed out using its real name.
 * Otherwise, the new name is substituted for the old.  This is a crock to
 * allow simple copying of cell definitions.
 */

CPrintCell(sEntry, filetype, newName)
  char *newName;
  short filetype;
  S_ENTRY_PTR sEntry;
{
RECTANGLE_PTR rectPtr;
CELL_DEFINITION_PTR cellPtr;
CELL_INSTANCE_PTR instPtr;

sprintf(data,"\nsymbol %s",(newName == NIL) ? sEntry->stringPtr: newName);
OutputString(data, filetype);
cellPtr = sEntry->data.symbol.cellPtr;

if (cellPtr->parameterList != NIL)
    PrintFParamList(cellPtr->parameterList, filetype);

OutputString(";\n", filetype);

PrintLocals(cellPtr, filetype);
PrintExports(cellPtr->exportList, filetype);

if (cellPtr->defaultList != NIL)
    PrintDefaultList(cellPtr->defaultList, filetype);

/* more declarations go here eventually +++ */

OutputString("begin\n", filetype);

instPtr = cellPtr->cells;
while (instPtr != NIL)
    {
    PrintInstance(instPtr, filetype);
    instPtr = instPtr->next;
    }

rectPtr = cellPtr->rectangles;
while (rectPtr != NIL)
    {
    PrintBox(rectPtr, filetype);
    rectPtr = rectPtr->next;
    }

OutputString("end;\n", filetype);
}

	/************************************************/
	/*		PrintBox:			*/
	/************************************************/

PrintBox(rectPtr, filetype)
  short filetype;
  RECTANGLE_PTR rectPtr;
{
OutputString("box (", filetype);
ExpPrint(rectPtr->l, filetype);
OutputString(",", filetype);
ExpPrint(rectPtr->b, filetype);
OutputString(",", filetype);
LayerPrint(rectPtr->layer, filetype);
OutputString(") to (", filetype);
ExpPrint(rectPtr->r, filetype);
OutputString(",", filetype);
ExpPrint(rectPtr->t, filetype);
OutputString(");\n", filetype);
}

	/************************************************/
	/*		PrintInstance:			*/
	/************************************************/

PrintInstance(instPtr, filetype)
  short filetype;
  CELL_INSTANCE_PTR instPtr;
{
if (instPtr->symTblPtr != NIL)
    {
    sprintf(data,"%s:: ",instPtr->symTblPtr->stringPtr);
    OutputString(data, filetype);
    }

sprintf(data,"place %s(", instPtr->instanceOf->symTblPtr->stringPtr);
OutputString(data, filetype);

PrintParameterList(instPtr, filetype);

OutputString(") ", filetype);

/* now for the rotation and reflection stuff */
switch (instPtr->trans.x11)
    {
    case 1:
	if (instPtr->trans.x22 == -1)
	    OutputString("flipped ud ", filetype);
	break;
    case 0:
	switch (instPtr->trans.x12)
	    {
	    case 1:
		if (instPtr->trans.x21 == 1)
		    OutputString("flipped lr, rotated 3 ", filetype);
		else
		    OutputString("rotated 9 ", filetype);
		break;
	    case -1:
		if (instPtr->trans.x21 == 1)
		    OutputString("rotated 3 ", filetype);
		else
		    OutputString("flipped lr, rotated 9 ", filetype);
		break;
	    }
	    break;
    case -1:
	if (instPtr->trans.x22 == 1)
	    OutputString("flipped lr ", filetype);
	else
	    OutputString("rotated 6 ", filetype);
	break;
    }

OutputString("at (", filetype);
ExpPrint(instPtr->trans.x31, filetype);
OutputString(",", filetype);
ExpPrint(instPtr->trans.x32, filetype);
OutputString(");\n", filetype);
}

	/************************************************/
	/*		PrintParameterList:		*/
	/************************************************/

PrintParameterList(instPtr, filetype)
  short filetype;
  CELL_INSTANCE_PTR instPtr;
{
  VARIABLE_CONS_PTR defParamPtr;
  EXPRESSION_CONS_PTR instParamPtr;
  BOOLEAN isFirstParameter;
  char *FindExpString();

isFirstParameter = TRUE;
instParamPtr = instPtr->parameterList;
defParamPtr = instPtr->instanceOf->parameterList;
while (instParamPtr != NIL)
    {
    if (instParamPtr->value/*.postfix*/ != NIL_EXPRESSION)
	{
	if (!isFirstParameter)
	    {
	    OutputString(", ", filetype);
	    }
	isFirstParameter = FALSE;
/*	sprintf(data,"%s =%s", defParamPtr->value->stringPtr,
			  &string[instParamPtr->value.string]);
 */
	sprintf(data,"%s =%s", defParamPtr->value->stringPtr,
			FindExpString(instParamPtr->value));
	OutputString(data, filetype);
	}
    instParamPtr = instParamPtr->next;
    defParamPtr = defParamPtr->next;
    }
}

	/************************************************/
	/*		ExpPrint:			*/
	/************************************************/

ExpPrint(exp, filetype)
  short filetype;
  EXPRESSION exp;
{
  char *stringBegin, *FindExpString();

    stringBegin = FindExpString(exp);
    sprintf(data,"%s", stringBegin);
    OutputString(data, filetype);
}

	/************************************************/
	/*		FindExpString:			*/
	/************************************************/

/* FindExpString takes an expression, and returns a pointer to the
 * first character in the string representation of its printname.
 */

char *FindExpString(exp)
  EXPRESSION exp;
{
  char *stringBegin;

  if (exp == NIL_EXPRESSION || *exp == Eend)
      return("0");
  stringBegin = exp;
  while (*stringBegin != Eend)
    switch (*stringBegin++)
      {
      case E16int:
      case Esymbol:
          stringBegin++;
      case E8int:
          stringBegin++;
          break;
      default:
          break;
      }
  stringBegin++;
  return(stringBegin);
}

ExpressionLength(exp)
  EXPRESSION exp;
{
  char *stringBegin, *stringSave;
  if (exp == NIL_EXPRESSION || *exp == Eend)
      return(0);
  stringSave = stringBegin = exp;
  while (*stringBegin != Eend)
    switch (*stringBegin++)
      {
      case E16int:
      case Esymbol:
          stringBegin++;
      case E8int:
          stringBegin++;
          break;
      default:
          break;
      }
  while (*(++stringBegin));
  return(stringBegin - stringSave);
}

	/************************************************/
	/*		LayerPrint:			*/
	/************************************************/

LayerPrint(layer, filetype)
  short filetype;
  PROCESS_LAYER layer;
{
switch (layer)
    {
    case NM:
	OutputString("metal", filetype); break;
    case NP:
	OutputString("poly", filetype); break;
    case ND:
	OutputString("diff", filetype); break;
    case NI:
	OutputString("implant", filetype); break;
    case NC:
	OutputString("contact", filetype); break;
    case NB:
	OutputString("buried", filetype); break;
    case NG:
	OutputString("glass", filetype); break;
    }
}

	/************************************************/
	/*		PrintDefaultList:		*/
	/************************************************/

PrintDefaultList(defList, filetype)
  short filetype;
  EXPRESSION_CONS_PTR defList;
{
  char *FindExpString();

OutputString("\ndefault ", filetype);
while (defList != NIL)
    {
/*    sprintf(data,"%s; ", &string[defList->value.string]);*/
    sprintf(data,"%s; ", FindExpString(defList->value));
    OutputString(data, filetype);
    defList = defList->next;
    }
OutputString("\n", filetype);
}

	/************************************************/
	/*		PrintFParamList:		*/
	/************************************************/

PrintFParamList(paramList, filetype)
  short filetype;
  VARIABLE_CONS_PTR paramList;
{
ENTRY_TYPE currentEntry;
BOOLEAN needsSemicolon;

currentEntry = UNDEFINED_ENTRY;
needsSemicolon = FALSE;

OutputString("(", filetype);

while (paramList != NIL)
    {
    if (paramList->value->symbolType == currentEntry)
	{
	OutputString(",", filetype);
	sprintf(data, "%s", paramList->value->stringPtr);
	OutputString(data, filetype);
	}
    else
	{
	if (needsSemicolon)
	    OutputString("; ", filetype);
	needsSemicolon = TRUE;
	switch(currentEntry = paramList->value->symbolType)
	    {
	    case XVAR_ENTRY:
		OutputString("xvar ", filetype);
		break;
	    case YVAR_ENTRY:
		OutputString("yvar ", filetype);
		break;
	    case SIGNAL_ENTRY:
		OutputString("signal ", filetype);
		break;
	    case SCALAR_ENTRY:
		OutputString("scalar ", filetype);
		break;
	    }
	sprintf(data, "%s", paramList->value->stringPtr);
	OutputString(data, filetype);
	}
    paramList = paramList->next;
    }
OutputString(")", filetype);
}
	/************************************************/
	/*		PrintExports:			*/
	/************************************************/

PrintExports(vCons, filetype)
  short filetype;
  VARIABLE_CONS_PTR vCons;
{
BOOLEAN is_first;

if (vCons == NIL)
    return;
OutputString("export ", filetype);
is_first = TRUE;
while (vCons != NIL)
    {
    if (!is_first)
	OutputString(",", filetype);
    is_first = FALSE;
    OutputString(vCons->value->stringPtr, filetype);
    vCons = vCons->next;
    }
OutputString(";\n", filetype);
}

	/************************************************/
	/*		PrintVarList:			*/
	/************************************************/

BOOLEAN PrintVarList(vCons, type, isBegun, needsSemicolon, filetype)
  short filetype;
  VARIABLE_CONS_PTR vCons;
  ENTRY_TYPE type;
  BOOLEAN isBegun, needsSemicolon;
{
while (vCons != NIL)
    {
    if (vCons->value->symbolType == type)
	{
	if (needsSemicolon)
	    {
	    OutputString("; ", filetype);
	    needsSemicolon = FALSE;
	    }
	if (isBegun)
	    {
	    isBegun = TRUE;
	    switch (type)
		{
		case XVAR_ENTRY:
		    OutputString("xvar ", filetype);
		    break;
		case YVAR_ENTRY:
		    OutputString("yvar ", filetype);
		    break;
		case SIGNAL_ENTRY:
		    OutputString("signal ", filetype);
		    break;
		case SCALAR_ENTRY:
		    OutputString("scalar ", filetype);
		    break;
		}
	    }
	else
	    OutputString(",", filetype);
	sprintf(data, "%s", vCons->value->stringPtr);
	OutputString(data, filetype);
	}
    vCons = vCons->next;
    }
return(isBegun);
}

	/************************************************/
	/*		PrintLocals:			*/
	/************************************************/

PrintLocals(cellPtr, filetype)
  short filetype;
  CELL_DEFINITION_PTR cellPtr;
{
BOOLEAN hasBegun, PrintVarList();

hasBegun = PrintVarList(cellPtr->exportList, XVAR_ENTRY, FALSE, FALSE, filetype);
hasBegun = PrintVarList(cellPtr->localList, XVAR_ENTRY, hasBegun, FALSE, filetype);
if (hasBegun)
    OutputString(";\n", filetype);

hasBegun = PrintVarList(cellPtr->exportList, YVAR_ENTRY, FALSE, FALSE, filetype);
hasBegun = PrintVarList(cellPtr->localList, YVAR_ENTRY, hasBegun, FALSE, filetype);
if (hasBegun)
    OutputString(";\n", filetype);

hasBegun = PrintVarList(cellPtr->exportList, SCALAR_ENTRY, FALSE, FALSE, filetype);
hasBegun = PrintVarList(cellPtr->localList, SCALAR_ENTRY, hasBegun, FALSE, filetype);
if (hasBegun)
    OutputString(";\n", filetype);

hasBegun = PrintVarList(cellPtr->exportList, SIGNAL_ENTRY, FALSE, FALSE, filetype);
hasBegun = PrintVarList(cellPtr->localList, SIGNAL_ENTRY, hasBegun, FALSE, filetype);
if (hasBegun)
    OutputString(";\n", filetype);

}
