/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE gc.c */

/* A collection of routines for allocating and de-allocating the
 * data structures associated with cell definition.  Also
 * contains an initialization routine for the SunInstanceArray.
 */

#include "aledefs.h"

/* extern char FreeStorage[];
 */
S_ENTRY_PTR FreeSEntryPtr;

	/************************************************/
	/*		InitSunInstanceArray:		*/
	/************************************************/

InitSunInstanceArray()
{
int i;

for (i=0; i < SUN_INSTANCE_COUNT; i++)
    {
    SunInstanceArray[i].type = SFreeInstance;
    SunInstanceArray[i].ptr.free_slot = i+1;
    }
SunInstanceArray[SUN_INSTANCE_COUNT-1].ptr.free_slot = -1;
FreeSunInstancePtr = 0;
}

	/************************************************/
	/*		GetSunInstanceNumber:		*/
	/************************************************/

int GetSunInstanceNumber()
{
int number;
if (FreeSunInstancePtr == -1)
    {
    ErrorPrint(42);
    return(-1);
    }
number = FreeSunInstancePtr;
FreeSunInstancePtr = SunInstanceArray[number].ptr.free_slot;
return(number);
}

	/************************************************/
	/*		FreeSunInstanceNumber:		*/
	/************************************************/

FreeSunInstanceNumber(number)
    int number;
{
SunInstanceArray[number].type= SFreeInstance;
SunInstanceArray[number].ptr.free_slot = FreeSunInstancePtr;
FreeSunInstancePtr = number;
}

	/************************************************/
	/*		FreeStorageCount:		*/
	/************************************************/

/* returns the amount of storage remaining in the free list in bytes */
/*
 * int FreeStorageCount()
 * {
 * return(((int) &(FreeStorage[FreeStorageSize])) - ((int) FreeStoragePtr));
 * }
 */

/*
freeYale(ptr)
  int *ptr;
{
  char data[20];

  sprintf(data, "[%d]", *(ptr-1) - (int)(ptr-1));
  TtyPutString(data);
free(ptr);
}

/* static CELL_INSTANCE_PTR FreeCellList = NIL; */

	/************************************************/
	/*		GetCellInstance:		*/
	/************************************************/

CELL_INSTANCE_PTR GetCellInstance()
{
char *GetStorageChunk();
/*CELL_INSTANCE_PTR savePtr;*/

return((CELL_INSTANCE_PTR) GetStorageChunk(sizeof(CELL_INSTANCE)));
/*
 * if (FreeCellList == NIL)
 *     return((CELL_INSTANCE_PTR)
 * 		GetStorageChunk(sizeof(CELL_INSTANCE)));
 * savePtr = FreeCellList;
 * FreeCellList = FreeCellList->next;
 * return(savePtr);
 */
}

	/************************************************/
	/*		FreeCellInstance:		*/
	/************************************************/

FreeCellInstance(instPtr)
CELL_INSTANCE_PTR instPtr;
{
free(instPtr);

/* instPtr->next = FreeCellList;
 * FreeCellList = instPtr;
 */
}

static RECTANGLE_PTR FreeRectangleList = NIL;

	/************************************************/
	/*		GetRectangle:			*/
	/************************************************/

RECTANGLE_PTR GetRectangle()
{
char *GetStorageChunk();

return((RECTANGLE_PTR) GetStorageChunk(sizeof(RECTANGLE)));

/* RECTANGLE_PTR savePtr;

if (FreeRectangleList == NIL)
    return((RECTANGLE_PTR) GetStorageChunk(sizeof(RECTANGLE)));
savePtr = FreeRectangleList;
FreeRectangleList = FreeRectangleList->next;
return(savePtr);
 */
}

	/************************************************/
	/*		FreeRectangle:			*/
	/************************************************/

FreeRectangle(rectPtr)
RECTANGLE_PTR rectPtr;
{
free(rectPtr);

/*rectPtr->next = FreeRectangleList;
 *FreeRectangleList = rectPtr;
 */
}

	/************************************************/
	/*		GetReferencePoint:		*/
	/************************************************/

REFERENCE_POINT_ER GetReferencePoint()
{
char *GetStorageChunk();

return((REFERENCE_POINT_ER) GetStorageChunk(sizeof(REFERENCE_POINT)));
/*return((REFERENCE_POINT_ER) malloc(sizeof(REFERENCE_POINT)));*/
}

	/************************************************/
	/*		FreeReferencePoint:		*/
	/************************************************/

FreeReferencePoint(ptr)
REFERENCE_POINT_ER ptr;
{
free(ptr);
}

	/************************************************/
	/*		GetCellDef:			*/
	/************************************************/

CELL_DEFINITION_PTR GetCellDef()
{
char *GetStorageChunk();

return((CELL_DEFINITION_PTR) GetStorageChunk(sizeof(CELL_DEFINITION)));
/*return((CELL_DEFINITION_PTR) malloc(sizeof(CELL_DEFINITION)));*/
}

	/************************************************/
	/*		FreeCellDef:			*/
	/************************************************/

FreeCellDef(ptr)
CELL_DEFINITION_PTR ptr;
{
free(ptr);
}

static CONS_PTR FreeConsList = NIL;

	/************************************************/
	/*		GetCons:			*/
	/************************************************/

CONS_PTR GetCons()
{
char *GetStorageChunk();

return((CONS_PTR) GetStorageChunk(sizeof(CONS)));
/*
CONS_PTR saveCons;

if (FreeConsList == NIL)
    return((CONS_PTR) GetStorageChunk(sizeof(CONS)));
saveCons = FreeConsList;
FreeConsList = FreeConsList->next;
return(saveCons);
 */
}
	/************************************************/
	/*		FreeCons:			*/
	/************************************************/

FreeCons(ptr)
CONS_PTR ptr;
{
free(ptr);
/*
 * ptr->next = FreeConsList;
 * FreeConsList = ptr;
 */
}

	/************************************************/
	/*		FreeExpression:			*/
	/************************************************/

FreeExpression(exp)
EXPRESSION exp;
{
if (exp != NIL)
    free(exp);
/*
unsigned short exp_num;
if ((exp_num = exp) == NIL_EXPRESSION) return;
while (expArray[exp_num] != Eend)
    expArray[exp_num++] = Eunused;
expArray[exp_num] = Eunused;
 */
}

	/************************************************/
	/*		FreeSymbolTableEntry:		*/
	/************************************************/

FreeSymbolTableEntry(sPtr)
    S_ENTRY_PTR sPtr;
{
int hash_value;
S_ENTRY_PTR lastPtr;
char data [20];	/* debug */

if (sPtr == NIL || *(sPtr->stringPtr) == '\0')
    return;
hash_value = hash(sPtr->stringPtr);
if ((lastPtr = hasharray[hash_value]) == sPtr)  /* first in the chain */
    hasharray[hash_value] = sPtr->link;
else
    {
    while ((lastPtr != NIL) && (lastPtr->link != sPtr))
	lastPtr = lastPtr->link;
    if (lastPtr != NIL)
	lastPtr->link = sPtr->link;
    else
	{
	ErrorPrint(49);
	return;
	}
    }

/* Now we must free the space in the string array. */

free(sPtr->stringPtr);

/* And now free the pointer. */

sPtr->link = FreeSEntryPtr;
FreeSEntryPtr = sPtr;

}

	/************************************************/
	/*		GetSEntry:			*/
	/************************************************/

S_ENTRY_PTR GetSEntry()
{
S_ENTRY_PTR newPtr;

if (FreeSEntryPtr == NIL)
    {
    ErrorPrint(27);
    return(NIL);
    }
newPtr = FreeSEntryPtr;
FreeSEntryPtr = newPtr->link;
return(newPtr);
}

	/************************************************/
	/*		FreeExpressionConsList:		*/
	/************************************************/

FreeExpressionConsList(consPtr)
EXPRESSION_CONS_PTR consPtr;
{
if (consPtr != NIL)
    {
    FreeExpressionConsList(consPtr->next);
    FreeExpression(consPtr->value); /* ++++ screws up free storage */
    FreeCons(consPtr);
    }
}
