/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: expandcell.c */

#include "aledefs.h"

#define SWAP(X,Y) {temp = X; X = Y; Y = temp;}
#define DefStackLength 600

short defStack[DefStackLength];
short defStackPtr = -1;
#define PUSH(X) {defStack[++defStackPtr] = X; if (defStackPtr > (DefStackLength - 3)) PrintStackOverflowMsg();}
#define POP defStack[defStackPtr--]

typedef struct minmaxvector
    {
    short xmin, xmax, ymin, ymax;
    } MIN_MAX, *MIN_MAX_PTR;

PrintStackOverflowMsg()
{
TtyBlinkError("Too many symbol calls");
defStackPtr -= 30;	/* A wild guess about how to handle the problem */
}

/* CellInstExpand takes a cell instance pointer, together with an
 * absolute orientation in the screen space, and returns an SDF pointer to
 * a SDF cell definition which will draw the cell in question.  It assumes
 * that the parameter list has already been evaluated and the the values
 * have been stuffed into the appropriate slots in the local stack frame.
 * All expansion is done under the assumption that the origin of the cell
 * is at (0, 0), but all objects in the cell are rotated/reflected as
 * indicated by the matrix pointed to by mPtr.
 */
	/************************************************/
	/*		CellInstExpand:			*/
	/************************************************/

short CellInstExpand (instPtr, frameBase, mPtr, time)
    short time;
    MATRIX_PTR mPtr;
    CELL_INSTANCE_PTR instPtr;
    short frameBase;
{
    CELL_DEFINITION_PTR instDef;
    short symNum, HashTransformation ();
    short transHash;
    short xTrans, yTrans;
    short symbolNum, callNumber;

    instDef = instPtr->instanceOf;

    symNum = UNIQUE;

    transHash = HashTransformation(mPtr);
    instDef->expandedSunIds[transHash] = symNum;

    PUSH(-1);
    ExpandInstanceList(instPtr, frameBase, mPtr, time);

    DefineSymbol(YaleSDF, symNum, instDef->symTblPtr->stringPtr);

    while (-1 != (xTrans = POP))
      {
        yTrans = POP;
        symbolNum = POP;
        callNumber = POP;
        TransPoint(&xTrans, &yTrans, mPtr);
        AddCall(YaleSDF, time == 0 ? callNumber : 0, 
		xTrans, yTrans, symbolNum);
      }
    ExpandRectangleList(instDef->rectangles, frameBase, mPtr, time);
    
    if (time == 0)
    expandReferencePoints(instPtr, frameBase);

/*
    FrameStack[frameBase++] = mm.ymax;
    FrameStack[frameBase++] = mm.xmax;
    FrameStack[frameBase++] = mm.ymin;
    FrameStack[frameBase++] = mm.xmin;
 */

    EndSymbol(YaleSDF, symNum, 0);
    
    PUSH(symNum);
    return(symNum);
}

/* EvalParameterList evaluates the parameters in a call on a cell
 * relative to the frameBase given.  It returns as a value the new
 * frameBase.  For purposes of speed, EvalParameterList assumes that
 * the parameters are in a strict form.  The parameters in the call
 * must be in the same order as they were declared, and the defaults
 * must also be in exactly the same order.
 *
 * EvalParameterList also zeroes out the rest of the local frame.
 */

	/************************************************/
	/*		EvalParameterList:		*/
	/************************************************/

short EvalParameterList(instOf, instPtr, frameBase)
  CELL_INSTANCE_PTR instPtr, instOf;
  short frameBase;
{
    short newFB;	/* return this eventually */
    EXPRESSION_CONS_PTR defList, paramList;
    VARIABLE_CONS_PTR varList;
    int eValue;
    int i, imax;

    newFB = frameBase + instOf->instanceOf->frameEnd;
    defList = instPtr->instanceOf->defaultList;

/* First, zero out the local frame. */

    imax = instPtr->instanceOf->frameEnd+newFB;
    for (i=newFB; i < imax; i++)
        FrameStack[i] = 0;
    
    if (instPtr->parameterList == NIL)
      {	/* just fill in the defaults */
        while (defList != NIL)
    	  {
    	    evalexp(defList->value, newFB);
    	    defList = defList->next;
    	  }
      }
    else
        {	/* go down parameter and default lists together */
          paramList = instPtr->parameterList;
          varList = instPtr->instanceOf->parameterList;
          while (paramList != NIL)
    	    {
    	      if (paramList->value/*.postfix*/ == 0)
    	        evalexp(defList->value, newFB);
 	      else
    	        {
    	          eValue = evalexp(paramList->value, frameBase);
	          FrameStack[newFB+varList->value->frameDisplacement]=eValue;
	        }
	      paramList = paramList->next;
	      varList = varList->next;
	      defList = defList->next;
	    }
        }
    while (defList != NIL)
      {
        evalexp(defList->value, newFB);
        defList = defList->next;
      }
    return(newFB);
}

	/************************************************/
	/*		ExpandInstanceList:		*/
	/************************************************/

ExpandInstanceList(inst, framePtr, mPtr, time)
  short time;
  MATRIX_PTR mPtr;
  CELL_INSTANCE_PTR inst;
  short framePtr;
{
    CELL_INSTANCE_PTR instList;
    short fb;		/* instance frame pointer */
    short frameStart, frameCount;
    MATRIX localMatrix;
    /* int xmax, xmin, ymax, ymin, x1, x2, y1, y2; */
    short oldHash, newHash, HashMultiply (), oldGlobal;
    TRANS_MATRIX trans;

    trans.x11 = mPtr->x11;
    trans.x12 = mPtr->x12;
    trans.x21 = mPtr->x21;
    trans.x22 = mPtr->x22;

    instList = inst->instanceOf->cells;
    
    oldHash = HashTransformation(&trans);
    
    while (instList != NIL)
      {
        fb = EvalParameterList(inst, instList, framePtr);
        trans.x11 = instList->trans.x11;
        trans.x12 = instList->trans.x12;
        trans.x21 = instList->trans.x21;
        trans.x22 = instList->trans.x22;

        newHash = HashTransformation(&trans);
        newHash = HashMultiply(newHash, oldHash);
        if (oldGlobal=(instList->instanceOf->expandedSunIds[newHash]))
 	  {
    	    PUSH(instList->sunInstanceNumber);
    	    PUSH(oldGlobal);
    	  }
        else
    	  {
    	    TransformationEval(instList, framePtr, &localMatrix);
    	    MatrixMult(&localMatrix, mPtr);
	    PUSH(instList->sunInstanceNumber);
	    CellInstExpand(instList, fb, &localMatrix, time+1);
	  }

    PUSH(evalexp(instList->trans.x32, framePtr));
    PUSH(evalexp(instList->trans.x31, framePtr));

/* now we must add back the exports, if any.  This is tricky, since the
 * first four exports are special -- xmin, ymin, ...  They must be transformed
 * into the local cell's coordinates by post-multiplying by the inverse of
 * the matrix pointed to by mPtr.
 */

/*    if (instList->symTblPtr != NIL)	/* move back exports
	{
	  frameStart = framePtr + instList->symTblPtr->frameDisplacement;
	  frameCount = instList->instanceOf->exportEnd - 4;
	  ymax = FrameStack[fb++];
	  xmax = FrameStack[fb++];
	  ymin = FrameStack[fb++];
	  xmin = FrameStack[fb++];

	  x1 = xmax*mPtr->x11 + ymax*mPtr->x12 - mPtr->x31*mPtr->x11
					       - mPtr->x32*mPtr->x12;
	  y1 = xmax*mPtr->x21 + ymax*mPtr->x22 - mPtr->x31*mPtr->x21
					       - mPtr->x32*mPtr->x22;
	  x2 = xmin*mPtr->x11 + ymin*mPtr->x12 - mPtr->x31*mPtr->x11
					       - mPtr->x32*mPtr->x12;
	  y2 = xmin*mPtr->x21 + ymin*mPtr->x22 - mPtr->x31*mPtr->x21
					       - mPtr->x32*mPtr->x22;

	  FrameStack[frameStart++] = max(y1, y2);
	  FrameStack[frameStart++] = max(x1, x2);
	  FrameStack[frameStart++] = min(y1, y2);
	  FrameStack[frameStart++] = min(x1, x2);
	  while ((frameCount--) > 0)
	      FrameStack[frameStart++] = FrameStack[fb++];
						/* stub +++ transform
	  } */
        instList = instList->next;
    }
}

	/************************************************/
	/*		TransformationEval:		*/
	/************************************************/

TransformationEval(instPtr, framePtr, matrixPtr)
  CELL_INSTANCE_PTR instPtr;
  short framePtr;
  MATRIX_PTR matrixPtr;
{
    matrixPtr->x11 = instPtr->trans.x11;
    matrixPtr->x12 = instPtr->trans.x12;
    matrixPtr->x21 = instPtr->trans.x21;
    matrixPtr->x22 = instPtr->trans.x22;
    matrixPtr->x31 = /* evalexp(instPtr->trans.x31, framePtr)*/ 0;
    matrixPtr->x32 = /* evalexp(instPtr->trans.x32, framePtr)*/ 0;
}

	/************************************************/
	/*		MatrixMult:			*/
	/************************************************/

MatrixMult(m1, m2)
MATRIX_PTR m1, m2;
{
    short x11, x12, x21, x22, x31;
    
    x11 = ((m1->x11)*(m2->x11)) + ((m1->x12)*(m2->x21));
    x12 = ((m1->x11)*(m2->x12)) + ((m1->x12)*(m2->x22));
    x21 = ((m1->x21)*(m2->x11)) + ((m1->x22)*(m2->x21));
    x22 = ((m1->x21)*(m2->x12)) + ((m1->x22)*(m2->x22));
    x31 = ((m1->x31)*(m2->x11)) + ((m1->x32)*(m2->x21)) + m2->x31;
    m1->x32 = ((m1->x31)*(m2->x12)) + ((m1->x32)*(m2->x22)) + m2->x32;
    m1->x31 = x31; m1->x11 = x11; m1->x12 = x12; m1->x21 = x21; m1->x22 = x22;
}

	/************************************************/
	/*		ExpandRectangleList:		*/
	/************************************************/

ExpandRectangleList(rectList, framePtr, mPtr, time)
short time;
MATRIX_PTR mPtr;
RECTANGLE_PTR rectList;
short framePtr;
{
    short l,r,t,b, l1, r1, t1, b1, temp;
    
    while (rectList != NIL)
      {
        l1 = evalexp(rectList->l, framePtr);
        r1 = evalexp(rectList->r, framePtr);
        t1 = evalexp(rectList->t, framePtr);
        b1 = evalexp(rectList->b, framePtr);
        l = mPtr->x11*l1 + mPtr->x21*b1;
        b = mPtr->x12*l1 + mPtr->x22*b1;
        r = mPtr->x11*r1 + mPtr->x21*t1;
        t = mPtr->x12*r1 + mPtr->x22*t1;
        if (t < b)
    	SWAP(t, b)
        if (r < l)
    	SWAP(r, l)
/*
        mmPtr->xmin = min(mmPtr->xmin, l);
        mmPtr->xmax = max(mmPtr->xmax, r);
        mmPtr->ymin = min(mmPtr->ymin, b);
        mmPtr->ymax = max(mmPtr->ymax, t);
 */
/*        rectList->selectedEdgeset = 0;	 shouldn't really be necessary */

        PlopRectangle(l,r,t,b,rectList->layer, rectList->selectedEdgeset,
			(time==0) ? rectList->sunInstanceNumber : 0);
        rectList = rectList->next;
    }
}

PlopRectangle(l, r, t, b, layer, edgeset, sin)
  short l,r,t,b, sin, edgeset;
  PROCESS_LAYER layer;
{
    AddItem(YaleSDF, sin, l, r, b, t, layer, SDF_FILLED_RECTANGLE, NULL);
    if (edgeset != 0)
        AddItem(YaleSDF, EDGECODE+sin, l, r, b, t, edgeset, SDF_OUTLINE, NULL);
}

	/************************************************/
	/*		LPrint:				*/
	/************************************************/
/*
 * LPrint(layer)
 * PROCESS_LAYER layer;
 * {
 *     switch (layer)
 *       {
 *         case NM:	printf("metal"); 	break;
 *         case NP:    	printf("poly"); 	break;
 *         case ND:    	printf("diff"); 	break;
 *         case NI:    	printf("implant"); 	break;
 *         case NC:    	printf("contact"); 	break;
 *         case NB:    	printf("buried"); 	break;
 *         case NG:	printf("glass"); 	break;
 *     }
 * }
 *
 */
/* The following static variables are used as pseudo-globals to avoid
 * passing them recursively through the parameter lists of the routines
 * DrawHorizRefs and DrawVertRefs.
 */

static REFERENCE_POINT_ER selectedRefPtr;
static short refFrameBase;

/* expandReferencePoints: is a routine which drops reference points
 * into the currently open sdf cell definition.  There is no need for any
 * transformation matrix, since the only reference points which will be
 * displayed are for the top level cell.
 */

expandReferencePoints(instPtr, frameBase)
  CELL_INSTANCE_PTR instPtr;
  short frameBase;
{
    REFERENCE_POINT_ER refPointer;

    refPointer = instPtr->instanceOf->yOriginRef;
    selectedRefPtr = instPtr->instanceOf->ySelectedRef;
    refFrameBase = frameBase;

    DrawHorizRefs(refPointer, TRUE);

    refPointer = instPtr->instanceOf->xOriginRef;
    selectedRefPtr = instPtr->instanceOf->xSelectedRef;

    DrawVertRefs(refPointer, TRUE);
}


DrawHorizRefs(refPtr, isOrigin)
  REFERENCE_POINT_ER refPtr;
  BOOLEAN isOrigin;
{
    short yWorld;

    if (refPtr == NIL)
	return;
    yWorld = isOrigin ? 0: FrameStack[refFrameBase +
		refPtr->symTblPtr->frameDisplacement];

    AddItem(YaleSDF, refPtr->sunInstanceNumber,
	  -32767, 32767, yWorld - 3, yWorld + 3, yWorld,
	  (refPtr == selectedRefPtr) ? SDF_SEL_HORIZ_REF : SDF_HORIZONTAL_REF,
	  isOrigin ? "Org" : refPtr->symTblPtr->stringPtr);

    if (refPtr->next)
        DrawHorizRefs(refPtr->next, FALSE);
    if (refPtr->son)
        DrawHorizRefs(refPtr->son, FALSE);
}

DrawVertRefs(refPtr, isOrigin)
  REFERENCE_POINT_ER refPtr;
  BOOLEAN isOrigin;
{
    short xWorld;

    if (refPtr == NIL)
	return;
    xWorld = isOrigin ? 0 : FrameStack[refFrameBase +
    		refPtr->symTblPtr->frameDisplacement];

    AddItem(YaleSDF, refPtr->sunInstanceNumber,
	  xWorld - 3, xWorld + 3, -32767, 32767, xWorld,
	  (refPtr == selectedRefPtr) ? SDF_SEL_VERT_REF : SDF_VERTICAL_REF,
	  isOrigin ? "Org" : refPtr->symTblPtr->stringPtr );

    if (refPtr->next)
        DrawVertRefs(refPtr->next, FALSE);
    if (refPtr->son)
        DrawVertRefs(refPtr->son, FALSE);
}

/* HashTransformation: generates a number from 0 to seven, depending
 * upon which of the 8 possible rotation/reflection matrices the instance
 * is called with.
 */

short HashTransformation(trans)
  TRANS_MATRIX *trans;
{
    short hashPair ();

    if (trans->x11)
      return(hashPair(trans->x11,trans->x22));
    return(4+hashPair(trans->x12,trans->x21));
}

static short hashPair(a, b)
short a, b;
{
    return ((a + 1) + ((b&2)>>1));
}

/* HashMultiply:  This routine implements multiplications of the
 * matrices above in terms of their hashed values.  For future reference,
 * what follows is the hash of each matrix, and a multiplication table.
 *
 * [1 0]: 2   [1  0]: 3   [-1 0]: 0   [-1  0]: 1
 * [0 1]      [0 -1]      [ 0 1]      [ 0 -1]
 *
 * [0 1]: 6   [ 0 1]: 7   [0 -1]: 4   [ 0 -1]: 5
 * [1 0]      [-1 0]      [1  0]      [-1  0]
 *
 *	T0 T1 T2 T3 T4 T5 T6 T7
 *    + -----------------------
 *  T0| T2 T3 T0 T1 T6 T7 T4 T5
 *  T1| T3 T2 T1 T0 T7 T6 T5 T4
 *  T2| T0 T1 T2 T3 T4 T5 T6 T7
 *  T3| T1 T0 T3 T2 T5 T4 T7 T6
 *  T4| T5 T7 T4 T6 T1 T3 T0 T2
 *  T5| T4 T6 T5 T7 T0 T2 T1 T3
 *  T6| T7 T5 T6 T4 T3 T1 T2 T0
 *  T7| T6 T4 T7 T5 T2 T0 T3 T1
 */

short HashMultiply(firstMtx, secondMtx)
  short firstMtx, secondMtx;
{
  static short multiplicationTable[8][8] =
    {2, 3, 0, 1, 6, 7, 4, 5,
     3, 2, 1, 0, 7, 6, 5, 4,
     0, 1, 2, 3, 4, 5, 6, 7,
     1, 0, 3, 2, 5, 4, 7, 6,
     5, 7, 4, 6, 1, 3, 0, 2,
     4, 6, 5, 7, 0, 2, 1, 3,
     7, 5, 6, 4, 3, 1, 2, 0,
     6, 4, 7, 5, 2, 0, 3, 1};
  return(multiplicationTable[firstMtx][secondMtx]);
}

/* TransPoint: transforms a point (x, y) by a matrix.  This routine
 * calls all its parameters by reference.  It doesn't make use of the
 * translation part of the matrix.
 */

TransPoint(xPtr, yPtr, mPtr)
  short *xPtr, *yPtr;
  MATRIX_PTR mPtr;
{
    short x, y;
    x = *xPtr * mPtr->x11 + *yPtr * mPtr->x21;
    y = *xPtr * mPtr->x12 + *yPtr * mPtr->x22;
    *xPtr = x;
    *yPtr = y;
}
