/********************************************************/
/*							*/
/*		YALE layout editor			*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*		THOMAS R. DAVIS				*/
/*							*/
/********************************************************/

/* FILE: aledefs.h */

/*
 * Window package definitions
 */

# include <Vgts.h>

/*
 * Yale definitions
 */

#define NIL_EXPRESSION 0	/* used for undefined expressions */
#define EDGECODE 16384		/* code added to item number for outline */
#define ILLEGAL_NUMBER -32768

#define Horizontal 10		/* kinds of reference Lines */
#define Vertical 11


/* File type information: */

#define MAINFILE 0
#define LIBFILE 1
#define BACKUPFILE 2
#define SCRATCHFILE 3

/* Size definitions */

#define MAX_ERRORS 30  /* lex gives up with more errors than this */
#define HASHSIZE 211  /* better be prime! */
#define STRINGSIZE 2500  /* size of string array */	/* MMT from 10000 */
#define ExpArrayLength 2000  /* expression array length */
				/* MMT from 10000 */
#define TOKBUFSIZE 31  /* maximum length of identifier or string */
#define LAYER_STACK_LENGTH 20
#define DEFAULT_SymbolTableSize 300	/* MMT from 1000 */
#define DEFAULT_MaxConnPts 1		/* MMT from 200 */
#define SUN_INSTANCE_COUNT 3500		/* MMT from 2000 */
#define READ_BUF_SIZE 100
#define EVAL_STACK_SIZE 60
#define FRAME_STACK_LENGTH 400
/* #define FreeStorageSize 10000		bytes */
				/* MMT from 250000 */

/* Expression definitions -- must fit in 8 bits */

#define Eplus       1
#define Eminus      2
#define Etimes      3
#define Ediv        4
#define Emod        5
#define Euminus     6
#define Edotx       7
#define Edoty       8
#define Eand        9
#define Eor        10
#define Enot       11
#define EgreaterEq 12
#define ElessEq    13
#define EnotEq     14
#define Eequal     15
#define E8int      16 /* 8 bit constant follows */
#define E16int     17
#define Esymbol    18 /* 16 bit symbol pointer follows */
#define Ead0       19 /* array -- dimension = 0 */
#define Ead1       20
#define Ead2       21
#define Esigvec    22
#define Eend       23 /* marks the end of an expression */
#define Eunused    24 /* for garbage collection (?) */
#define Elparen    25
#define Elocal     26 /* causes the last thing to be local to an instance */
#define Eassign    27
#define EQsymbol   28 /* QUOTEd symbol -- save frame displacement */
#define Elsigvec   29 /* local signal vector */
#define EQdotx     30
#define EQdoty     31


#define UNIQUE UniqueNumber--

typedef unsigned char TOKEN_TYPE;

#define NUMBER 0
#define IDENTIFIER 1
#define STRING 2
#define L_PAREN 3
#define R_PAREN 4
#define L_BRACKET 5
#define R_BRACKET 6
#define ASSIGNMENT 7
#define EQUAL 8
#define COLON 9
#define DOUBLE_COLON 10
#define PERIOD 11
#define COMMA 12
#define DOUBLE_PERIOD 13
#define LESS_OR_EQUAL 14
#define GREATER_OR_EQUAL 15
#define NOT_EQUAL 16
#define GREATER_THAN 17
#define LESS_THAN 18
#define SEMICOLON 19
#define TIMES 20
#define QUOTIENT 21
#define PLUS 22
#define MINUS 23
#define DOT_X 24
#define DOT_Y 25
#define UNARY_MINUS 26

		/* the following are the SILT reserved words */

#define ALL 27
#define AND 28
#define AT 29
#define BEGIN 30
#define BOX 31
#define BURIED 32
#define BUTT 33
#define CIF_LIST 34
#define CONNECT 35
#define CONSTANT 36
#define CONSTRAINT 37
#define CONTACT 38
#define CUT 39
#define DEFAULT 40
#define DIFF 41
#define DIFF_METAL 42
#define DIFF_POLY 43
#define DIV 44
#define DO 45
#define END 46
#define EXPORT 47
#define PHYLE 48
#define FLIPPED 49
#define FOR 50
#define GLASS 51
#define IF 52
#define IMPLANT 53
#define LR 54
#define METAL 55
#define METAL_POLY 56
#define MOD 57
#define NONE 58
#define NOT 59
#define OR 60
#define PLACE 61
#define POLY 62
#define RL 63
#define ROTATED 64
#define ROUTE 65
#define SCALAR 66
#define SIGNAL 67
#define SYMBOL 68
#define THEN 69
#define TO 70
#define UD 71
#define WITH 72
#define X 73
#define XMAX 74
#define XMIN 75
#define XVAR 76
#define Y 77
#define YMAX 78
#define YMIN 79
#define YVAR 80
#define ENDOFFILE 255

typedef unsigned char ENTRY_TYPE;


#define CONSTANT_ENTRY 0
#define INSTANCE0_ENTRY 1
#define INSTANCE1_ENTRY 2
#define INSTANCE2_ENTRY 3
#define RESERVED_ENTRY 4
#define SCALAR_ENTRY 5
#define SIGNAL_ENTRY 6
#define SIGNAL_VECTOR_ENTRY 7
#define SYMBOL_ENTRY 8
#define UNDEFINED_ENTRY 9
#define XVAR_ENTRY 10
#define YVAR_ENTRY 11

typedef unsigned char PROCESS_LAYER;

union symbol_data
  {
    int value; /* for CONSTANT */
    BOOLEAN isExport; /* for XVAR, YVAR, SCALAR, SIGNAL */
    struct {char isExport, LB, UB} sig; /* SIGNAL_VECTOR */
    struct {struct cell_inst *cellInstPtr} dim0; /* for INSTANCE0 */
    struct {struct cell_inst *cellInstPtr;
	    char LB, UB} dim1; /* for INSTANCE1, */
    struct {struct cell_inst *cellInstPtr;
	    char LB1, UB1, LB2, UB2} dim2; /* for INSTANCE2 */
    TOKEN_TYPE word; /* for reserved words */
    struct {struct cell_def *cellPtr} symbol /* for SYMBOL */
  };

typedef struct sym_tbl_entry
  {
    ENTRY_TYPE symbolType;
    char *stringPtr;		/* ptr into global array string */
    short symbolId; 		/* id of symbol in which entry is defined */
    struct sym_tbl_entry *link;	/* to chain entries with same hash */
    short frameDisplacement;   /* to find it during expansion */
    union symbol_data data;
  } S_ENTRY, *S_ENTRY_PTR;


typedef unsigned char CMD_TYPE;

#define BOX_COMMAND 0
#define BUTT_COMMAND 1
#define CUT_COMMAND 2
#define CONNECT_COMMAND 3
#define CONNECT_ALL_COMMAND 4
#define ASSIGN_COMMAND 5
#define WITH_COMMAND 6
#define ITERATE_COMMAND 7
#define CIF_LIST_COMMAND 8
#define BLOCK_COMMAND 9
#define CONDITIONAL_COMMAND 10
#define ROUTE_COMMAND 11
#define SYMBOL_CALL_COMMAND 12

/*typedef struct {unsigned short postfix, string;} EXPRESSION,*EXPRESSION_PTR;*/
typedef char *EXPRESSION, **EXPRESSION_PTR;

#include "alerecs.h"

/* the following definitions are for the NLS-like i/o stuff */

#define BACKSPACE_ABORT(L) {read_buf_ptr= read_buf;putchar('\r');goto L;}
#define GET_CMD(V,W,L) V = read_command(W);if(V==-1)BACKSPACE_ABORT(L)

/* in the define above, V is the variable, W is the wordlist, and L is
 * the label
 */

#define GET_STRING(S,L) if (read_string(S,TRUE) == -1)BACKSPACE_ABORT(L)
#define GET_PWD(S,L) if (read_string(S,FALSE) == -1)BACKSPACE_ABORT(L)

/* the define above uses the string pointer S and the label L. */

#define GET_NUM(N,L) if((N=read_number())==ILLEGAL_NUMBER)BACKSPACE_ABORT(L)

/* N is the number, and L is the error label. */

#define GET_OK(L) if (read_ok() == -1) BACKSPACE_ABORT(L)

typedef struct cmd_word
    {
    char *minwidth, *full, *noise;
    short id			/*  the cmd-word identifier */
    } CMD_WORD, *CMD_WORD_PTR;

typedef struct matrix
    {
    short x11, x12, x21, x22, x31, x32
    } MATRIX, *MATRIX_PTR;

extern S_ENTRY SymTblArray[]; /* really an array, but allocated */
extern CONNECTION_POINT ConnPointArray[];  /* ditto */
extern S_ENTRY_PTR hasharray[];
extern char string[];
extern unsigned short StringTOS;
extern int CurrentLine, CurrentColumn;
extern TOKEN_TYPE LexToken;
extern PROCESS_LAYER DefaultLayerStack [];
extern int LayerStackTop;
extern int LexNumber;
extern char *LexString;
extern int FreeExp;
extern char expArray[];
extern int SymbolTableSize;
extern int FreeSunInstancePtr;
extern SUN_INSTANCE_RECORD SunInstanceArray[];
extern int MaxConnPts;
extern char *LexSource;
extern int ErrorCount;
extern BOOLEAN PeekFlag;
extern char read_buf[], *read_buf_ptr;
extern CELL_DEFINITION_PTR OpenCellDefinition;  /* cell being edited */
extern BOOLEAN LexSaveFlag;
extern char *LexSavePtr;
extern short FrameStack[];
extern CELL_DEFINITION_PTR MasterCellList;
extern char *FreeStoragePtr; /* +++ fix later for gc */
extern short UniqueNumber;
extern short GlobalVGT;			/* graphics vgt */
extern short StatusVGT;			/* The status vgt index */
extern short YaleSDF;
extern short Debug;			/* turns on debugging printouts */
