/* xlVsys.c - xlisp Vsystem functions */

#include "xlisp.h"

/* external variables */
extern NODE *xlstack;

FORWARD LOCAL xlistmsg();
FORWARD LOCAL NODE *xmsglist();
FORWARD NODE *xlmatch();
FORWARD NODE *xlsave();

/* turn a list of 8 ints into a message */
LOCAL xllistmsg(args, msg)
NODE **args;
Message msg;
  {
    NODE *l, *ip;
    register int i;
    
    l = xlmatch(LIST, args);
    for (i = 0; i < 8; i++)
      {
        ip = xlmatch(INT, &l);
	msg[i] = ip->n_int;
      }
  }

/* turn a msg into a list of 8 ints */
LOCAL NODE *xlmsglist(msg)
Message msg;
  {
    NODE *n, last, ip, *oldstk;
    register int i;
    
    last.n_ptr = NIL;
    oldstk = xlsave(&ip, &last, NULL);
    
    for (i = 7; i >= 0; i--)
      {
        ip.n_ptr = newnode(INT);
	ip.n_ptr->n_int = msg[i];
	n = newnode(LIST);
	rplaca(n, ip.n_ptr);
	rplacd(n, last.n_ptr);
	last.n_ptr = n;
      }
      
    xlstack = oldstk;
    return(last.n_ptr);
  }

NODE *xSend(args)
NODE *args;
  {
    NODE val, *di, *ld, *oldstk, *pid;
    ProcessId dest;
    Message msg;
    
    xllistmsg(&args, msg);
    pid = xlmatch(INT, &args);
    xllastarg(args);
    
    oldstk = xlsave(&val, NULL);
    
    dest = Send(msg, pid->n_int);
    val.n_ptr = newnode(LIST);
    di = newnode(INT);
    di->n_int = dest;
    rplaca(val.n_ptr, di);
    ld = newnode(LIST);
    rplacd(val.n_ptr, ld);
    rplaca(ld, xlmsglist(msg));
    
    xlstack = oldstk;
    return(val.n_ptr);
  }

NODE *xReceive(args)
NODE *args;
  {
    NODE val, *si, *ld, *oldstk;
    ProcessId pid;
    Message msg;
    
    xllastarg(args);
    
    pid = Receive(msg);
    
    oldstk = xlsave(&val, NULL);
    
    val.n_ptr = newnode(LIST);
    si = newnode(INT);
    si->n_int = pid;
    rplaca(val.n_ptr, si);
    ld = newnode(LIST);
    rplacd(val.n_ptr, ld);
    rplaca(ld, xlmsglist(msg));
    
    xlstack = oldstk;
    return(val.n_ptr);
  }

NODE *xReply(args)
NODE *args;
  {
    NODE val, *oldstk, *dp, *n, *ml;
    ProcessId pid, dest;
    Message msg;
    
    oldstk = xlsave(&val, NULL);
    val.n_ptr = NIL;
    
    xllistmsg(&args, msg);
    pid = xlmatch(INT, &args)->n_int;
    xllastarg(args);
    
    dest = Reply(msg, pid);
    
    val.n_ptr = newnode(LIST);
    dp = newnode(INT);
    rplaca(val.n_ptr, dp);
    dp->n_int = dest;
    ml = xlmsglist(msg);
    n = newnode(LIST);
    rplacd(val.n_ptr, n);
    rplaca(n, ml);
    
    xlstack = oldstk;
    return(val.n_ptr);
  }
