#include <Venviron.h>
#include <Vteams.h>
#include <Vgroupids.h>
#include <Vdirectory.h>
#include <Vquerykernel.h>


#define LINE_SIZE 45

HostStatusRecord hoststat;

main()
  {
    Message msg ;
    UpdateHostStatusRequest * updaterequest = (UpdateHostStatusRequest *) msg;
    int i, count = 0 ;
    struct hostStatMsg *hsmtable ;
    int entcmp() ;
    SystemCode rc ;
    
    if ((hsmtable = (struct hostStatMsg *) malloc (100 * sizeof (struct hostStatMsg))) ==0)
	  printf("malloc returns 0\n") ;

    resetStatusMsg( &(hsmtable[0]) ) ;
    hsmtable[0].avail = AVAIL_RELEVANT ;

    count = getHostDescriptors (100, hsmtable, hsmtable) ;
    if (count)
      {
        char *table ;

        table = (char *) calloc (count, LINE_SIZE) ;
	if (! table)
	  {
	    fprintf(stderr, "malloc (%d) failed\n", LINE_SIZE*count) ;
	    exit(1) ;
          }
        printf ("    user         host         LHN     idle  \n\n") ;
        for (i=0; i < count; i++)
          {
	    rc = Gethoststatus( hsmtable[i].pid, &hoststat ) ;
	    if ( rc != OK )
	      {
	        printf("updaterequest to %x failed: %s\n", 
		     hsmtable[i].pid,
		     ErrorString(rc)) ;
	      }
	    else
	      {
                sprintf (table+LINE_SIZE*i, "%-13.13s %-14.14s %4x    %4d",
                    hoststat.userName, 
                    hoststat.hostName, 
	            (hsmtable[i].pid>>16) & 0xFFFF, 
	            hsmtable[i].minIdleTime) ;
	      }
          }
	qsort (table, count, LINE_SIZE, entcmp);
	for (i=0; i<count; i++ )
	  printf("%s\n",table+i*LINE_SIZE) ;
        free (table) ;
      }  
    free(hsmtable) ;
  }


entcmp(c1, c2)
	char *c1, *c2;
{
	return (strcmp(c1, c2));
}


