/*	vedit.c:	 V editor - main program			*/
/*			Kenneth Brooks, Nov. 1982			*/
/*									*/
/* This is a display editor which runs under the V kernel and VGTS. 	*/
/* Its commands resemble emacs: it is not line-oriented.  It can 	*/
/* handle multiple buffers in multiple windows, and uses its invoking	*/
/* window for interaction text, such as search strings.  The mouse can	*/
/* be used to make selections and cut and paste.			*/
	
/*
 * RJN - 4/83 - Added tag function to ved.  Follows same conventions
 *		as unix tag file.
 * RJN - 8/83 - wrote code to handle context naming conventions of V.
 *	 	Deleted the ved's banners and put file name in vgt banner.
 *		Command vgt displays the current context in its banner.
 *		Fixed a few bugs with file names and changed backups to
 *		to do a copy operation (versus remote execution).
 * TPM 8/31/83  Corrected arguments to GetPid().
 * CRZ 5/20/85  Changed filename lengths for .CKP and .BAK files to be 256.
 *		Changed it so that the .CKP and .BAK names are the old names
 *		with .BAK or .CKP added (used to truncate to 14 chars).
 *		Added capability to have all the .CKP files created during the
 *		current session to be deleted upon normal exit (^x-^z or ^x-d).
 *		Made ^x-d work correctly for all windows (ie. select another
 *		valid window, or exit if there are none left.
 */
#include <Venviron.h>
#include <Vioprotocol.h>
#include <Vtermagent.h>
#include <Vgts.h>
#include "vedit.h"
#include "chardef.h"
#include "ansipad.h"
#include "menu.h"

/* The following variables are the current buffer record, and correspond
   to the record type BufferRec.  They are not expressed as a record because
   they occur all over the program, and making them record elements would
   make this code vastly uglier.  */

struct	ckpdesc	*CkpNames = NULL;/* head of the list which hold ckp file names*/
char	filename[80];
short	Nrows;			/* Number of rows in the current buffer. */
short	NrowsDefault = NrowsInitialDefault;	/* Default setting for Nrows. */
Rowrec	*rows;
Marklink Marklist;	/* a quick way of finding all the permanent Marks */
Mark	headmark, endmark, regionmark;
Mark	curmark, mousemark;
Pos	curpos;
short	modified = 0;	/* the modified bit for the current buffer */
short	ckpmodified = 0;/* the checkpoint modified bit for the current buffer */
			/* Set when the file to be checkpointed is modified */
			/* Reset when the file is saved or backed up */
short	selectionexists = 0;	/* selection flag */
short	incommandwindow = 0;	/* on when stdin is selected for input */
Padtype	pad;		/* pad's output file descriptor and handle in general */
File	*infile;	/* pad's input file descriptor */
Process_id keyproc;	/* this pad's keyboard input watcher */
/* end of the current buffer record */

     /* thisbuffer stores the buffer i.d. of the current active buffer */
int	thisbuffer = -1;	/* -1 means no buffer exists */

Chunk	readchunk;
Mark	tempmark;	/* used by BlockInsert and BlockDelete, also
			 * usable by anything that just uses single-char
			 * inserts and deletes
			 */
Mark	eolmark;	/* for use with PreAdjust/AdjustDisplay */
Vedmsg	commandmsg;
int	debug = 0;	  /* a bit vector controlling various printout */
int	backupoption = 1; /* if 1, .BAK files are made when writing */
SystemCode paderr;
Pos	zeropos = {0,0};
Pos	eolpos;	  /* stores a parameter for AdjustDisplay */

     /* the data type string, when used in ved, uses the (pointer, length) */
     /* representation - null termination is provided for debugger 	   */
     /* compatibility, but is not important.				   */
char	searchstring[80], repstring[80], linebuf[81], filename2[80];
int	searchlen, replen;

int	wishcol;   /* the column where ^N or ^P would like to land */
int	oktoquit = 0;	/* signal that the user intends to quit */
int	addmarkfail = 0;	/* signal that Addmark calloc failed */
Process_id mainproc = 0;/* the editor process */
Process_id rootproc;	/* the underlying process that survives crashes */

/* Checkpointing information */
#define CHECKPOINT_INTERVAL 500
int ActionCount = 0;		/* The number of keyboard or mouse actions
				   performed since the last checkpoint was
				   taken. */
int CheckPointInterval = CHECKPOINT_INTERVAL;
				/* Number of actions after which to take a
				   checkpoint. */

/* Buffer to store keyboard input on.  This buffer allows functions to 
   unget input and also to generate additional input for later processing. */
#define USER_INPUT_BUFFER_SIZE 32
int UserInputBuffer[USER_INPUT_BUFFER_SIZE];
int UserInputQend = 0;
int UserInputQfront = 0;

struct BUFTABLE buffers[Maxbufs] = {  
         /* numbers are default window positions */
	{NULL, 160, 170, NULL},
	{NULL, 330, 10,  NULL},
	{NULL, 15,  15,  NULL},
	{NULL, 10,  330, NULL},
	{NULL, 325, 325, NULL},
	{NULL, 180, 20,  NULL},
	{NULL, 20,  190, NULL},
	{NULL, 140, 320, NULL},
	{NULL, 330, 150, NULL},
	{NULL, 160, 170, NULL},	/* Just stack the rest in the same place. */
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL},
	{NULL, 160, 170, NULL}
	};

extern Mainloop();
extern File *OpenName();
extern InitFixedMenu();

int GetUserInputBuffer();




main(argc,argv)  int argc;  char **argv;
{ 
  int n;
  Process_id donepid;
  Message msg;  
  static char TmpName[ MAX_FILE_NAME_LEN ];
  int saveMode;

  rootproc = GetPid(ACTIVE_PROCESS, LOCAL_PID);
  saveMode = QueryPad(stdout);	/* Save the pad's state so we can reset it
				   on exit. */
  ModifyPad(stdout, LF_Output);	/* I'll do the echoing */

  InitKeyTable();

  if ((argc > 1) && (argv[1][0] == '-'))
    {
      NrowsDefault = atoi(&argv[1][1]);
      argc--;
      argv++;
    }
  Nrows = NrowsDefault;

  if (argc > 2)
      sscanf(argv[2],"%x",&debug);

  if (debug) {printf("debug is %x\n",debug);  Flush(stdout);}

  if (argc < 2) {
    readchunk = 0;
    filename[0] = '\0';
    NewMsg("no file");
/*^*/ myprint(8)("No file: headmark.chunk=%x\n",headmark.chunk);
    }
  else {
    TmpName[0]= '\0';
    strncat( TmpName, argv[1], MAX_FILE_NAME_LEN );
    readchunk = ReadFile( OpenName( filename, TmpName ) );
    }

  SetContextBanner();
  InitFixedMenu( );

  n = NewBuffer(readchunk, Nrows);

  if (!n)
      return;	/* user aborted or no memory */
  else
       StoreBuffer( thisbuffer); /* this puts the globals into the structures */

  while (!oktoquit) {
    mainproc = Create(20, Mainloop, 2000 );
    if (mainproc == 0) {
	printf("Failed to create mainproc!!\n");
	Flush(stdout);
	}
    Ready(mainproc,0);
    do {
      donepid = ReceiveSpecific(msg, mainproc);
      if ( donepid != 0 ) {
	switch (msg[0]) {
	    case CREATE_KEYPROC:
		keyproc = Create(9, ReaderProcess, Keyprocstack);
		Ready(keyproc, 2, msg[1], infile);
		Reply(msg, mainproc);
		break;
	    case DESTROY_KEYPROC:
		DestroyProcess(keyproc);
		Reply(msg, mainproc);
		break;
	    case RESTART_MAINPROC:
		DestroyProcess(mainproc);
		donepid = 0;
	    }  /* end switch */
	}
      }
     while (donepid != 0);

    if (oktoquit) break;
    SelectPad(stdout);
    printf("\nEditor crash!  Shall I try to save the current buffer? ");
    if (Yesno() > 0) WriteFile(filename,headmark,endmark);
    printf("\nTry to continue? ");
    if (Yesno() <= 0) break;
    SelectPad(pad);
    }
  ModifyPad(stdout, saveMode);	/* Restore previous pad mode. */
  printf("\n");			/* Leave cursor on a new line. */
  }

/* Mainloop: a separate process so we can restart it after a strange crash */
/* We waitfor mouse or keyboard action, and act on it.			   */
/*
 * CRZ 5/16/85 Took backuption swapping stuff out and moved it into the
 * 	       CheckpointModifiedFiles procedure; reasons: keep implementation
 *	       hidden, and keep gross stuff closest to where it's used.
 */
Mainloop()
  {
    int n, c;
    Process_id pid;
    int msgtype, bufid;

    while(1)
      {
	BackToPad();
	if (selectionexists)
	    PadCursorOff(pad);
	else
	    PadCursorOn(pad);
	UpdateBanner();
	Flush(pad);
	RedrawPad(pad);

	ActionCount++;
	if (ActionCount >= CheckPointInterval)
	  {
	    CheckpointModifiedFiles();
	    ActionCount = 0;
	  }

	pid = Receive(&commandmsg);
	Reply(&commandmsg, pid);

	msgtype = commandmsg.type;
	bufid = commandmsg.bufid;

	if (bufid != thisbuffer)
	    PickBuffer(bufid);

/*^*/ myprint(8)("Msg type %d  buffer %d  x=%o\n",msgtype,bufid,
	  commandmsg.x);  Flush(stdout);

	n = 0;
	if ((msgtype != Mouse) && (msgtype != Key))
	  {
	    printf("WARNING - The main process received a message which ");
	    printf("neither a Mouse nor a Key event.\n");
	    Flush(stdout);
	    continue;		/* Should never get here! */
	  }
	if (msgtype == Mouse)
	  {
	    /* take action on menu driven command */
	    c = MouseAction(&commandmsg);
	  }
	else	/* Key */
	  {
	    if (!quoted && !hiquote)
		c = StateMachine(commandmsg.x);
	    else
		c = commandmsg.x;
	  }
	if (c >= 0)
	  {
	    /* Process the user's input. */
	    if (selectionexists)
		n = SelectionKeyAction(c);
	    else
		n = KeyAction(c);
	    /* Process any input that may have been generated during
	       KeyAction. */
	    while ((c = GetUserInputBuffer()) >= 0)
	      {
		if (!quoted && !hiquote)
		    c = StateMachine(c);
		if (c >= 0)
		  {
		    if (selectionexists)
			n = SelectionKeyAction(c);
		    else
			n = KeyAction(c);
		  }
	      }
	  }
	if (n == -1)
	  {
/*^*/	myprint(255)("Good-bye\n");
	    oktoquit = 1;
	    return;
	  }
      }
  }


/* ReaderProcess: read chars and mouse clicks from the pad and
   send them to mainproc.
   One of these exists for each editing pad - whenever a pad is not selected,
   the process reading it just remains blocked on input.  Parameters are
   buffer index and pad input file descriptor. */
ReaderProcess(mybuf, myinpad)  
  int mybuf;  
  File *myinpad;
{ 
  Vedmsg msg;
  short x, y, buttons;
  register int n, j, k;
  char charbuf[20];
  short LastButtons = 0;

  while (1) {
    n = GetEvent(myinpad, &x, &y, &buttons, charbuf);
    if (n < 0) {
	printf("Pad file error: %s", ErrorString(myinpad->lastexception));
	continue;
	}

    msg.code = 0;
    msg.bufid = mybuf;
    if (n > 0) {	/* keyboard message */
	for (j=0; j < n; j++) {
	    msg.type = Key;
	    msg.x = charbuf[j];
	    k = Send(&msg, mainproc);
	    if (k == 0) printf("reader %d send failure!\n",mybuf);
	    }
	}
    else {	/* mouse message */
	/* send down transitions only for all buttons, but the Left */
	/* The left is sent on the up transition */
	if ( (buttons != 0 && buttons == LeftButton)
	     || LastButtons == MiddleButton
	     || LastButtons == RightButton )
	  {
	    msg.buttons = buttons ? buttons : LastButtons; 
	    msg.type = Mouse;
	    msg.x = x;
	    msg.y = y;
	    k = Send(&msg, mainproc);
	    if (k == 0) printf("reader %d send failure!\n",mybuf);
	  }
	LastButtons = buttons;
	}
    }
  }


/*
 * PutUserInputBuffer:
 * Enqueue a keyboard input on the UserInputBuffer.
 */

PutUserInputBuffer(c)
    unsigned int c;
  {
    register int qEndP1;

    /* Check for queue overflow. */
    if (UserInputQend == (USER_INPUT_BUFFER_SIZE - 1))
      {
	qEndP1 = 0;
      }
    else
      {
        qEndP1 = UserInputQend + 1;
      }
    if (qEndP1 == UserInputQfront)
      {
	NewMsg("WARNING - overflow of user input buffer.");
	NewMsg("Discarding last input.");
	return;
      }
    /* Enqueue the input. */
    UserInputBuffer[UserInputQend] = c;
    UserInputQend = qEndP1;
  }

/*
 * GetUserInputBuffer:
 * Dequeue the keyboard input at the front of the UserInputBuffer.
 * Returns -1 if empty.
 */

int GetUserInputBuffer()
  {
    int c;

    if (UserInputQfront == UserInputQend)
      {
	return(-1);
      }
    c = UserInputBuffer[UserInputQfront];
    if (UserInputQfront == (USER_INPUT_BUFFER_SIZE - 1))
      {
	UserInputQfront = 0;
      }
    else
      {
	UserInputQfront++;
      }
    return(c);
  }


/*
 * UngetUserInputBuffer:
 * Return a keyboard input to the front of the queue.
 */

UngetUserInputBuffer(c)
    int c;
  {
    register int qFrontM1;

    /* Check for queue overflow. */
    if (UserInputQfront == 0)
      {
	qFrontM1 = USER_INPUT_BUFFER_SIZE - 1;
      }
    else
      {
	qFrontM1 = UserInputQfront - 1;
      }
    if (qFrontM1 == UserInputQend)
      {
	NewMsg("WARNING - overflow of user input buffer.");
	NewMsg("Discarding last input.");
	return;
      }
    /* Put the input in the front of the queue. */
    UserInputQfront = qFrontM1;
    UserInputBuffer[UserInputQfront] = c;
  }


/* Yesno: Get a y or n answer from the user.  y returns 1, n returns 0,	*/
/* Return returns 2 ("default answer"), ^G returns -1,			*/
/* all others ask "y or n please." 					*/
int Yesno()
{ register char ch;

 SelectPad(stdout);
 incommandwindow = 1;
 while (1) {
  Flush(stdout);
  ch = getchar();
  if (ch == '\07') {	/* control-G */
    return(-1);
    }
  if (ch == 'y' || ch == 'Y') {
    putchar(ch);
    Flush(stdout);
    return(1);
    }
  if (ch == 'n' || ch == 'N') {
    putchar(ch);
    Flush(stdout);
    return(0);
    }
  if (ch == '\r') return(2);
  else printf("\nyes or no? ");
  }
 }


/* PickWindow: Ask the user to indicate an editor window, by clicking	*/
/* in it with the mouse.  If mode is nonzero a keystroke will abort it	*/
/* and be returned as the negative of its ASCII value;			*/
/* ^G will do that regardless of mode.					*/
/* Stdin/stdout are not used and must not be selected, or the ^G key	*/
/* cannot be read.  PickWindow returns a buffer number.			*/
int PickWindow(mode)  int mode;
{ register int bufid;
  Process_id pid;
  Vedmsg msg;
  char ch;

  while (1) {
    Flush(stdout);
    pid = Receive(&msg);  /* await a mouse click from one of my pads */
    Reply(&msg, pid);
    if (msg.type == Mouse) {
	bufid = msg.bufid;
	return(bufid);
	}
    else {
	ch = msg.x;
	if (ch == 0) continue;	/* NUL is ignored, just for simplicity */
	if (ch == '\07' || mode != 0) return(-ch);
	}
    /* else we just ignore the keystroke */
    } /* end while (1) */
  }


Mark nonMark = {NULL, NULL};  /* meaning "not found" */

/* Search: given a string and its length (NOT the null-termination convention)
   find its first occurrence in the text after (but not at) curmark.  If found,
   curmark and mousemark are set to the beginning and end, respectively, of the
   found string, and Search returns 1.  Otherwise they are unchanged and Search
   returns 0. Not defined for strings of length 0.  When search succeeds, any
   existing selection is deselected since curmark and mousemark are moved.
 */
int Search(str,len)  char *str;  int len;
{ register char *searchpt, *scanpt, *stringpt;
  char *searchecp, *scanecp;
  register Chunk srchunk, scanchunk;
  register int i;

  if (Atend(curmark)) return(0);
  srchunk = curmark.chunk;  searchpt = curmark.cp + 1;
  searchecp = Chunkend(srchunk);

  while (1) { /* main search loop */
    for (; searchpt < searchecp; searchpt++) { /* in-chunk loop for speed */
      if (*searchpt == *str) { /* found first character */
	stringpt = str; scanpt = searchpt; scanchunk = srchunk;
	scanecp = searchecp;
	for (i=0; i<len && (*scanpt++ == *stringpt++); i++) {
	  if (scanpt >= scanecp) { /* i.e. our find crosses a chunk boundary */
	    if (!scanchunk->next) break; /*not return, might be end of a find*/
	    scanchunk = scanchunk->next; scanpt = scanchunk->text;
	    scanecp = Chunkend(scanchunk);
	    }
	  }
	if (i == len)  {  /* found! */
	    if (selectionexists) Deselect();
	    curmark = Makemark(srchunk, searchpt);
	    mousemark = Makemark(scanchunk, scanpt);
	    return(1);
	    }
	}  /* end of "found first character" */
      }  /* end in-chunk loop */
   /* main search: next chunk */
    if (!srchunk->next)  return(0);
    srchunk = srchunk->next;  searchpt = srchunk->text;
    searchecp = Chunkend(srchunk);
    }  /* end while(1) */
  }

/* ReverseSearch: just like Search only backward.  Just like Search, will not
   find an instance starting right at the cursor.  Will find an instance
   starting before the cursor and extending past it.  */
int ReverseSearch(str,len)  char *str;  int len;
{ register char *searchpt, *scanpt, *stringpt;
  char *searchecp, *scanecp;
  register Chunk srchunk, scanchunk;
  register int i;

  if (Atstart(curmark)) return(0);
  srchunk = curmark.chunk;  searchpt = curmark.cp - 1;
  searchecp = Chunkend(srchunk);

  while (1) { /* main search loop */
    for (; searchpt >= srchunk->text; searchpt--) { /* in-chunk loop */
      if (*searchpt == *str) { /* found first character */
	stringpt = str; scanpt = searchpt; scanchunk = srchunk;
	scanecp = searchecp;
	for (i=0; i<len && (*scanpt++ == *stringpt++); i++) {
	  if (scanpt >= scanecp) { /* i.e. our find crosses a chunk boundary */
	    if (!scanchunk->next) break;
	    scanchunk = scanchunk->next; scanpt = scanchunk->text;
	    scanecp = Chunkend(scanchunk);
	    }
	  }
	if (i == len)  {  /* found! */
	    if (selectionexists) Deselect();
	    curmark = Makemark(srchunk, searchpt);
	    mousemark = Makemark(scanchunk, scanpt);
	    return(1);
	    }
	}  /* end of "found first character" */
      }  /* end in-chunk loop */
   /* main search: next chunk */
    if (!srchunk->prev)  return(0);
    srchunk = srchunk->prev;  searchecp = Chunkend(srchunk);
    searchpt = searchecp - 1;
    }  /* end while(1) */
  }


/* SelFind:  To be called with the output of Search or ReverseSearch.	*/
/* If the search succeeded, the text found is displayed and selected,	*/
/* otherwise the message "not found" is printed.			*/
SelFind(foundit)  int foundit;
{
  BackToPad();
  if (foundit) {
    DispSetcursor(curmark);
    Select(curmark, mousemark);
    }
  else NewMsg("Not found");
  }

/* Beep: the simplest available signal that something is wrong.	*/
Beep(ch)
    int ch;
  {
    putchar('\007');
    Flush(stdout);
  }

/* ErrorMsg: united here so that it can easily be redefined */
ErrorMsg(s) char *s;
{ printf(s);  Flush(stdout);
}

/*************************** Debugging Subroutines **************************/

DumpChunks(chunk)  Chunk chunk;
{ for ( ; chunk!=NULL; chunk=chunk->next)
    printf("Chunk %x (%c%c%c%c): %d chars, end %x, prev %x, next %x\n",
        chunk,chunk->text[0],chunk->text[1],chunk->text[2],chunk->text[3],
	chunk->length,chunk->text+chunk->length,
        chunk->prev,chunk->next);
  Flush(stdout);
  }

/* SixRows: dumps the data for the first 6 Rowrecs			*/
SixRows()
{ register int i;
  putchar('\n');
  for (i=0; i<6; i++) DumpRow(i);
  Flush(stdout);
  }

LastRows()
{ register int i;
  putchar('\n');
  for (i=Nrows-5; i<=Nrows; i++) DumpRow(i);
  Flush(stdout);
  }

DumpRow(n)  int n;
{ register Rowrec *r = rows + n;
  register char ch;
  printf("Row %d  ", n);
  if (r->exists) {
    ch = *r->cp;
    if (ch == '\n') ch = 01;	/* control-A, a down arrow */
    printf("'%c'  chunk %x cp %x  length %d ",ch,r->chunk,r->cp,r->length);
    if (r->continues) putchar('<');
    if (r->continued) putchar('>');
    }
  else putchar('-');
  putchar('\n');
  }
