/*	chartab.c:	editor display tables				*/
/*	Principle: there is no such thing as a non-printing character.	*/
/*	Control characters are shown in "^A" style, while eighth-bit	*/
/*	characters are shown in "\200" style.				*/

unsigned char charsize[256] = {
/* 32 control characters */
  2, 2, 2, 2, 2, 2, 2, 2,  2, 2, 0, 2, 2, 2, 2, 2, /* the 0 is '\n' */
  2, 2, 2, 2, 2, 2, 2, 2,  2, 2, 2, 2, 2, 2, 2, 2,
/* 95 printing ASCII characters */
  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,  1, 1, 1, 1, 1, 1, 1, 2, /* that's DEL */
/* 128 high-bit-on characters, printed as octal escape sequences */
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4,  4, 4, 4, 4, 4, 4, 4, 4};

char chartab[] = "^@^A^B^C^D^E^F^G^H^I^J^K^L^M^N^O^P^Q^R^S^T^U^V^W^X^Y^Z\
^[^\\^]^^^_ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_\
`abcdefghijklmnopqrstuvwxyz{|}~^?\
\\200\\201\\202\\203\\204\\205\\206\\207\
\\210\\211\\212\\213\\214\\215\\216\\217\
\\220\\221\\222\\223\\224\\225\\226\\227\
\\230\\231\\232\\233\\234\\235\\236\\237\
\\240\\241\\242\\243\\244\\245\\246\\247\
\\250\\251\\252\\253\\254\\255\\256\\257\
\\260\\261\\262\\263\\264\\265\\266\\267\
\\270\\271\\272\\273\\274\\275\\276\\277\
\\300\\301\\302\\303\\304\\305\\306\\307\
\\310\\311\\312\\313\\314\\315\\316\\317\
\\320\\321\\322\\323\\324\\325\\326\\327\
\\330\\331\\332\\333\\334\\335\\336\\337\
\\340\\341\\342\\343\\344\\345\\346\\347\
\\350\\351\\352\\353\\354\\355\\356\\357\
\\360\\361\\362\\363\\364\\365\\366\\367\
\\370\\371\\372\\373\\374\\375\\376\\377";

short charpt[256] = {
  0,  2,  4,  6,  8,  10, 12, 14,   16, 18, 20, 22, 24, 26, 28, 30,
  32, 34, 36, 38, 40, 42, 44, 46,   48, 50, 52, 54, 56, 58, 60, 62,

  64, 65, 66, 67, 68, 69, 70, 71,   72, 73, 74, 75, 76, 77, 78, 79,
  80, 81, 82, 83, 84, 85, 86, 87,   88, 89, 90, 91, 92, 93, 94, 95,
  96, 97, 98, 99,100,101,102,103,  104,105,106,107,108,109,110,111,
 112,113,114,115,116,117,118,119,  120,121,122,123,124,125,126,127,
 128,129,130,131,132,133,134,135,  136,137,138,139,140,141,142,143,
 144,145,146,147,148,149,150,151,  152,153,154,155,156,157,158,159, 

 161,165,169,173,177,181,185,189,  193,197,201,205,209,213,217,221,
 225,229,233,237,241,245,249,253,  257,261,265,269,273,277,281,285,
 289,293,297,301,305,309,313,317,  321,325,329,333,337,341,345,349,
 353,357,361,365,369,373,377,381,  385,389,393,397,401,405,409,413,
 417,421,425,429,433,437,441,445,  449,453,457,461,465,469,473,477,
 481,485,489,493,497,501,505,509,  513,517,521,525,529,533,537,541,
 545,549,553,557,561,565,569,573,  577,581,585,589,593,597,601,605,
 609,613,617,621,625,629,633,637,  641,645,649,653,657,661,665,669};
