/* 	chardef.h:  character definitions and modifier functions used	*/
/*	by ved.  Includes character codes for two types of keyboards,	*/
/*	those provided by Cadlinc and by Sun Microsystems Inc. (SMI).	*/

/* character modifiers used by ved */
#define CONTROL(c) 	(c-'@')
#define ESCAPE(c)	(c+0x100)
#define CONTROLX(c)	(c+0x200)
#define ANSI(c)		(c+0x400)

/* standard characters */
#define ESC		'\033'
#define DEL		'\177'

/* special keys on SMI keyboards */
#define SMI_PF1		(0x800 + 'P')
#define SMI_PF2		(0x800 + 'Q')
#define SMI_PF3		(0x800 + 'R')
#define SMI_PF4		(0x800 + 'S')

/* special keys on Cadlinc keyboards */
#define PF1	0366
#define PF2	0367
#define PF3	0368
#define PF4	0369

#define NO_SCRL	0260
#define SET_UP	0376
#define BREAK	0340
#define UP_ARROW	0361
#define DOWN_ARROW	0362
#define LEFT_ARROW	0363
#define RIGHT_ARROW	0364

#define KPERIOD	0262
#define KCOMMA	0323
#define KMINUS	0344
#define ENTER	0303

#define K0	0261
#define K1	0300
#define K2	0301
#define K3	0302
#define K4	0320
#define K5	0321
#define K6	0322
#define K7	0341
#define K8	0342
#define K9	0343
