/* ansipad.h:  purpose: to transform my use of pad routines into a
   standardized use of escape sequences.  */

/* redirected routines */
#define PadPosition	PadPutCursor
#define PadIndex	PadScrollUp
#define PadReverseIndex	PadScrollDown

/* standard interface to survive external world changes */
#define PadSend(p,c)	putc(c,p)

/* routines transformed into escape sequences */
#define PadCursorForward(p)  PadEscSequence(p,"[C")
#define PadCursorBackward(p) PadEscSequence(p,"[D")

#define PadHome(p)	PadEscSequence(p,"[H")
#define PadClear(p)	PadSend(p,'\014')
#define PadClearToEOL(p) PadEscSequence(p,"K")
#define PadClearToEOS(p) PadEscSequence(p,"J")

#define PadReturn(p)	PadSend(p,'\r')
#define PadNewLine(p)	PadSend(p,'\n')
#define PadInsertLine(p) PadEscSequence(p,"L")
#define PadDeleteLine(p) PadEscSequence(p,"[0M")

/* new operations not in pad.c */
#define PadInverse(p)	PadEscSequence(p,"[1m")
#define PadNormal(p)	PadEscSequence(p,"[0m")

/* nullified operations */
#define PadCursorOn(p)
#define PadCursorOff(p)
#define PadRedraw(p)
