/* Machine dependent routines for unexec */

#include <Vio.h>
#include <Vprocess.h>
#include <b.out.h>

/* return the offset of the start of the symbol table */

long StartOfSymbolTable(header)
struct bhdr *header;
  {
    return (N_SYMOFF(*header));
  }

/* return the offset of the start of the program text */

long StartOfText(header)
struct bhdr *header;
  {
    return (N_TXTOFF(*header));
  }


/* return the offset of the given C symbol */

long OffsetOfSymbol(symbol, objFile, objHeader)
char *symbol;
File *objFile;
struct bhdr *objHeader;
  {
    long symbolAddress = AddressOfSymbol(symbol, objFile, objHeader);
    
    return(N_TXTOFF(*objHeader) + symbolAddress - TEAM_ORIGIN);
  }

long AddressOfSymbol(symbol, objFile, objHeader)
char *symbol;
File *objFile;
struct bhdr *objHeader;
  {
    struct nlist sym;
    char symname[128];	/* no legal maximum */
    char cSymbol[128], *cp;
    long oldpos;

    sprintf(cSymbol, "_%s", symbol);
    
    fseek(objFile, N_SYMOFF(*objHeader), ABS_BYTE);
    
    while (ftell(objFile) < N_SYMOFF(*objHeader) + objHeader->ssize)
      {
        fread(&sym, sizeof(sym), 1, objFile);
	oldpos = ftell(objFile);
	fseek(objFile, N_STROFF(*objHeader) + sym.n_un.n_strx, ABS_BYTE);
	/* read symbol name up to null */
	for(cp = symname;
	    (cp < &symname[128]) && (*cp = getc(objFile));
	    cp++);
	symname[127] = '\0';
	fseek(objFile, oldpos, ABS_BYTE);

	if (strcmp(cSymbol, symname) == 0)
	    return(sym.n_value);
      }
    fprintf(stderr, "Couldn't find %s in symbol table\n", cSymbol);
  }
