/*
 * This function executes in a separate process on either the same team or
 * a different team from the Sender process.
 */

#include "timeipc.h"

Receiver()
  {
    Message		message;
    register TimingMsg	*msg = (TimingMsg *) message;
    register unsigned	msgCounter;
    register ProcessId	senderPid;
    register SystemCode	typeOfTest;
    register char	*localSegmentPtr;

    ProcessId		myPid;
    unsigned		interHost, msgsPerTrial;
    unsigned		localSegmentSize, receivedSegmentSize;
    double		overheadSeconds, idleSeconds;

    extern char		*malloc();
    extern SystemCode	SetProcessPriority();

    myPid = GetPid( ACTIVE_PROCESS, LOCAL_PID );

    localSegmentPtr  = NULL;
    localSegmentSize = 0;

    for(;;)
      {
	senderPid = Receive( msg );
	switch( msg->timingCode )
	  {
	    case START_TRIAL:

		break;

	    case SET_TEAM_PRIO:

		msg->timingCode = ChangeTeamPriority( myPid, msg->interHost );
		Reply( msg, senderPid );
		goto next_trial;

	    case SET_PROC_PRIO:

		msg->timingCode = SetProcessPriority( myPid, msg->interHost,0 );
		Reply( msg, senderPid );
		goto next_trial;

	    default:

		msg->timingCode = BAD_STATE;
		Reply( msg, senderPid );
		goto next_trial;
	  }

	typeOfTest   = msg->typeOfTest;
	interHost    = msg->interHost;
	msgsPerTrial = msg->msgsPerTrial;

	if( localSegmentSize != msg->segmentSize )
	  {
	    if( localSegmentPtr != NULL ) free( localSegmentPtr );
	    if( (localSegmentSize = msg->segmentSize) == 0 )
	      {
		localSegmentPtr = NULL;
	      }
	    else if( (localSegmentPtr = malloc( localSegmentSize )) == NULL )
	      {
		localSegmentSize = 0;
		msg->timingCode = NO_MEMORY;
		Reply( msg, senderPid );
		goto next_trial;
	      }
	  }

	switch( typeOfTest )
	  {

	    case MSG_TEST:

		msgCounter = msgsPerTrial;

		/**********************************************************/
		/* BEWARE: Time- and priority-critical stuff starts here. */
		/* For interHost tests, the Looper process sucks up all   */
		/* unused CPU cycles.  Be careful if making changes!      */
		/**********************************************************/

		if( interHost ) CreateLooper();

		msg->timingCode = OK;
		Reply( msg, senderPid );	/* reply to START_TRIAL */

		if( interHost ) StartTiming();

		do		/* here's the inner loop for MSG_TEST */
		  {
		    senderPid = Receive( msg );
		    if( msg->timingCode != typeOfTest )
		      {
			if( interHost ) DestroyLooper();
			msg->timingCode = BAD_STATE;
			Reply( msg, senderPid );
			goto next_trial;
		      }
		    msg->timingCode = OK;
		    Reply( msg, senderPid );
		  }
		while( --msgCounter );

		if( interHost )
		  {
		    StopTiming( NULL, &idleSeconds );
		    DestroyLooper();
		  }

		senderPid = Receive( msg );	/* await REPORT_TIMES */

		/*******************************************************/
		/* RELAX: Time- and priority-critical stuff ends here. */
		/*******************************************************/

		break;


	    case SHORT_READ_TEST:

		msgCounter = msgsPerTrial;

		/**********************************************************/
		/* BEWARE: Time- and priority-critical stuff starts here. */
		/* For interHost tests, the Looper process sucks up all   */
		/* unused CPU cycles.  Be careful if making changes!      */
		/**********************************************************/

		if( interHost ) CreateLooper();

		msg->timingCode = OK;
		Reply( msg, senderPid );	/* reply to START_TRIAL */

		if( interHost ) StartTiming();

		do	    /* here's the inner loop for SHORT_READ_TEST */
		  {
		    senderPid = Receive( msg );
		    if( msg->timingCode != typeOfTest )
		      {
			if( interHost ) DestroyLooper();
			msg->timingCode = BAD_STATE;
			Reply( msg, senderPid );
			goto next_trial;
		      }
		    msg->timingCode = OK;
		    ReplyWithSegment( msg, senderPid, localSegmentPtr,
					msg->segmentPtr, msg->segmentSize );
		    /* NOTE: lost reply segments are not detected! */
		  }
		while( --msgCounter );

		if( interHost )
		  {
		    StopTiming( NULL, &idleSeconds );
		    DestroyLooper();
		  }

		senderPid = Receive( msg );	/* await REPORT_TIMES */

		/*******************************************************/
		/* RELAX: Time- and priority-critical stuff ends here. */
		/*******************************************************/

		break;


	    case SHORT_WRITE_TEST:

		msgCounter = msgsPerTrial;
		receivedSegmentSize = localSegmentSize;

		/**********************************************************/
		/* BEWARE: Time- and priority-critical stuff starts here. */
		/* For interHost tests, the Looper process sucks up all   */
		/* unused CPU cycles.  Be careful if making changes!      */
		/**********************************************************/

		if( interHost ) CreateLooper();

		msg->timingCode = OK;
		Reply( msg, senderPid );	/* reply to START_TRIAL */

		if( interHost ) StartTiming();

		do	  /* here's the inner loop for SHORT_WRITE_TEST */
		  {
		    senderPid = ReceiveWithSegment( msg, localSegmentPtr,
						    &receivedSegmentSize );
		    if( msg->timingCode != typeOfTest ||
			receivedSegmentSize != msg->segmentSize )
		      {
			if( interHost ) DestroyLooper();
			msg->timingCode = (msg->timingCode != typeOfTest) ?
						BAD_STATE : BAD_BYTE_COUNT;
			Reply( msg, senderPid );
			goto next_trial;
		      }
		    msg->timingCode = OK;
		    Reply( msg, senderPid );
		  }
		while( --msgCounter );

		if( interHost )
		  {
		    StopTiming( NULL, &idleSeconds );
		    DestroyLooper();
		  }

		senderPid = Receive( msg );	/* await REPORT_TIMES */

		/*******************************************************/
		/* RELAX: Time- and priority-critical stuff ends here. */
		/*******************************************************/

		break;


	    case LONG_READ_TEST:

		msgCounter = msgsPerTrial;

		/**********************************************************/
		/* BEWARE: Time- and priority-critical stuff starts here. */
		/* For interHost tests, the Looper process sucks up all   */
		/* unused CPU cycles.  Be careful if making changes!      */
		/**********************************************************/

		if( interHost ) CreateLooper();

		msg->timingCode = OK;
		Reply( msg, senderPid );	/* reply to START_TRIAL */

		if( interHost ) StartTiming();

		do	    /* here's the inner loop for LONG_READ_TEST */
		  {
		    senderPid = Receive( msg );
		    if( msg->timingCode != typeOfTest )
		      {
			if( interHost ) DestroyLooper();
			msg->timingCode = BAD_STATE;
			Reply( msg, senderPid );
			goto next_trial;
		      }
		    MoveTo( senderPid, msg->segmentPtr,
				localSegmentPtr, msg->segmentSize );
		    msg->timingCode = OK;
		    Reply( msg, senderPid );
		  }
		while( --msgCounter );

		if( interHost )
		  {
		    StopTiming( NULL, &idleSeconds );
		    DestroyLooper();
		  }

		senderPid = Receive( msg );	/* await REPORT_TIMES */

		/*******************************************************/
		/* RELAX: Time- and priority-critical stuff ends here. */
		/*******************************************************/

		break;


	    case LONG_WRITE_TEST:

		msgCounter = msgsPerTrial;

		/**********************************************************/
		/* BEWARE: Time- and priority-critical stuff starts here. */
		/* For interHost tests, the Looper process sucks up all   */
		/* unused CPU cycles.  Be careful if making changes!      */
		/**********************************************************/

		if( interHost ) CreateLooper();

		msg->timingCode = OK;
		Reply( msg, senderPid );	/* reply to START_TRIAL */

		if( interHost ) StartTiming();

		do	   /* here's the inner loop for LONG_WRITE_TEST */
		  {
		    senderPid = Receive( msg );
		    if( msg->timingCode != typeOfTest )
		      {
			if( interHost ) DestroyLooper();
			msg->timingCode = BAD_STATE;
			Reply( msg, senderPid );
			goto next_trial;
		      }
		    MoveFrom( senderPid, localSegmentPtr,
				msg->segmentPtr, msg->segmentSize );
		    msg->timingCode = OK;
		    Reply( msg, senderPid );
		  }
		while( --msgCounter );

		if( interHost )
		  {
		    StopTiming( NULL, &idleSeconds );
		    DestroyLooper();
		  }

		senderPid = Receive( msg );	/* await REPORT_TIMES */

		/*******************************************************/
		/* RELAX: Time- and priority-critical stuff ends here. */
		/*******************************************************/

		break;


	    default:

		msg->timingCode = BAD_ARGS;
		Reply( msg, senderPid );	/* reply to START_TRIAL */
		goto next_trial;
	  }

	if( msg->timingCode != REPORT_TIMES )
	  {
	    msg->timingCode = BAD_STATE;
	    Reply( msg, senderPid );
	    goto next_trial;
	  }

	/* measure overhead */

	switch( typeOfTest )
	  {
	    case MSG_TEST:
	    case SHORT_READ_TEST:
	    case LONG_READ_TEST:
	    case LONG_WRITE_TEST:

		msg->timingCode = OK;
		typeOfTest = OK;
		msgCounter = OVERHEAD_LOOPS;
		StartTiming();
		do
		  {
		    if( msg->timingCode != typeOfTest )
			abort( "I don't believe it!" );
		    msg->timingCode = OK;
		  }
		while( --msgCounter );
		StopTiming( &overheadSeconds, NULL );
		break;

	    case SHORT_WRITE_TEST:

		receivedSegmentSize = msg->segmentSize;
		msg->timingCode = OK;
		typeOfTest = OK;
		msgCounter = OVERHEAD_LOOPS;
		StartTiming();
		do
		  {
		    if( msg->timingCode != typeOfTest ||
			receivedSegmentSize != msg->segmentSize )
			abort( "I don't believe it!" );
		    msg->timingCode = OK;
		  }
		while( --msgCounter );
		StopTiming( &overheadSeconds, NULL );
		break;
	  }

	/* convert to microseconds per message */

	msg->overheadPerMsg = ( ( overheadSeconds / OVERHEAD_LOOPS )
							* 1000000.0 ) + 0.5;
	msg->idlePerMsg     = ( ( idleSeconds / msgsPerTrial )
							* 1000000.0 ) + 0.5;

	msg->timingCode = OK;
	Reply( msg, senderPid );	/* reply to REPORT_TIMES */

next_trial:
	;  /* loop back for another trial */
      }
  }
