/*
 * Timing Module -- measures elapsed time and/or idle CPU time in millisec.
 * Steve Deering, October 1985
 */

#include <Venviron.h>

#define LOOPER_PRIO	254	/* lowest executable process priority */
#define LOOPER_STACK	100


static ProcessId	LooperPid   = 0;
static unsigned		LoopCounter = 0;
static unsigned		StartSec    = 0;
static unsigned		StartClick  = 0;


static Looper()
  {
    loop:
	LoopCounter++;
	goto loop;
  }


CreateLooper()
  {
    LooperPid = Create( LOOPER_PRIO, Looper, LOOPER_STACK );
    Ready( LooperPid, 0 );
  }


DestroyLooper()
  {
    Destroy( LooperPid );
  }


StartTiming()
  {
    LoopCounter = 0;
    StartSec = GetTime( &StartClick );
  }


StopTiming( elapsedSeconds, idleSeconds )
    double *elapsedSeconds, *idleSeconds;
  {
    unsigned stopSec, stopClick, elapsedClicks;
    unsigned idleCounts, countsPerSec;

    stopSec = GetTime( &stopClick );
    idleCounts = LoopCounter;

    if( elapsedSeconds != NULL )
      {
	elapsedClicks = ( ( stopSec - StartSec ) * CLICKS_PER_SEC ) +
			( stopClick - StartClick );

	*elapsedSeconds = (double) elapsedClicks / (double) CLICKS_PER_SEC;
      }

    if( idleSeconds != NULL )
      {
	LoopCounter = 0;	/* let Looper count for 1 second */
	Delay( 1, 0 );		/* (give or take a click)        */
	countsPerSec = LoopCounter;

	*idleSeconds = ( countsPerSec == 0 ) ? 0.0 :
		       (double) idleCounts / (double) countsPerSec;
      }
  }
