/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1984				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * TerminalType -- returns type of terminal associated with "file".
 * This version pokes around in several places to figure out the terminal
 * type; each terminal agent ought to provide a query operation to return
 * this information!
 *
 * WARNING: the returned string is a literal character string, statically
 * allocated, so the caller should avoid changing it if this function is to
 * be called more than once.
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vtermagent.h>

char *TerminalType( file )
    File *file;
  {
    Message msg;
    struct ModifyMsg *req = (struct ModifyMsg *) msg;
    SystemCode QueryWorkstationConfig();
    char *type;

    type = "                    ";	/* room for 20 chars */

    /* First check config info. */
    if( QueryWorkstationConfig( "terminal-type", type, 20 ) == OK )
      {
	if( strncmp( type, "vgts", 4 ) != 0 ) return( type );
      }

    /*
     * If no config info found (or if config info claims type is "vgts..."),
     * assume it is a vgts pad; query the vgts to get number of lines.
     */
    req->requestcode = QueryPadRequest;
    req->fileid = file->fileid;
    req->lines = 0;	/* will be untouched if term agent is the sts */
    Send( msg, file->fileserver );

    if( req->requestcode != OK ||
	req->lines < 1 || req->lines > 99 ) return( "unknown" );

    sprintf( type, "vgts%d", req->lines );
    return( type );
  }
