/*
 * iphost [hostname]
 * Prints IP addresses of named host or, if no name specified,
 * of the invoking host.
 * Should also report list of names for a given IP address!
 */

#include <Vio.h>
#include <Venviron.h>

#define MAX_IPS 10

main( argc, argv )
    int argc;
    char **argv;
  {
    int i, n;
    char name[100];
    unsigned long a, b, c, d, ip, ips[MAX_IPS];
    SystemCode error, QueryWorkstationConfig();

    if( argc > 1 )	/* host name specified */
      {
	printf( "host name:    %s\n", argv[1] );
	printf( "IP addresses:" );
	fflush( stdout );

	/* find out our own IP address first */
	if( QueryWorkstationConfig( "ip-address", name, 100 ) == OK &&
		sscanf( name, "[%d.%d.%d.%d]", &a, &b, &c, &d ) == 4 )
	    ip = (a<<24) | (b<<16) | (c<<8) | d;
	else
	    ip = 0;

	/* then look for specified host's addresses, relative to ours */
	if( (n = NameToIpAddrs( argv[1], ip, ips, MAX_IPS )) == 0 )
	  {
	    printf( " none found\n" );
	  }
	else
	  {
	    for( i=0; i<n; ++i )
	      {
		ip = ips[i];
		printf( " %d.%d.%d.%d",
		(ip>>24), (ip>>16)&0xFF, (ip>>8)&0xFF, ip&0xFF );
	      }
	    printf( "\n" );
	  }
      }
    else		/* no host name specified */
      {
	printf( "local host name: " );
	fflush( stdout );
	if( (error = QueryWorkstationConfig( "name", name, 100 )) == OK )
	    printf( " %s\n", name );
	else
	    printf( " unknown  (config query error: %s)\n",
			ErrorString(error) );

	printf( "local IP address:" );
	fflush( stdout );
	if( (error = QueryWorkstationConfig( "ip-address", name, 100 )) == OK)
	  {
	    if( sscanf( name, "[%d.%d.%d.%d]", &a, &b, &c, &d ) == 4 )
		printf( " %d.%d.%d.%d\n", a, b, c, d );
	    else
		printf( " %s  (malformed)\n", name );
	  }
	else
	    printf( " unknown  (config query error: %s)\n",
			ErrorString(error) );
      }
    exit();
  }
