/* withvgts.c: main program for a team1 with vgts linked in - desirable to
 * save memory. *
 * Kenneth Brooks, 11/16/83
 *
 */

# include <Venviron.h>
# include <Vioprotocol.h>
# include "Vgts.h"

extern vgtsmain();

main()
  {
    ProcessId vgtspid;

    InitFirstTeam();
    vgtspid = Create(10, vgtsmain, 2048);
    Ready(vgtspid, 0);
    ExecServer();
  }

/* material almost identical to .../servers/vgts/init.c */
extern short TtyVGT, TtySDF;
extern short Unique, InputVGT;		/* From mux.c */
extern InitExec();
extern ProcessId execserver;

short Debug;

/*
 * vgtsmain:
 * Main routine for the vgts package.
 * This routine sets up the vgts process and any applications
 * processes; in this case, Exec.
 */

vgtsmain()
  {
    Message msg;
    short vgt;
    ProcessId initpid;

    InitVgts( 690, 698, 1100, 790 );

    vgt = PadInit( TtySDF, Unique++, "Executive", PadHeight, PadWidth );
    InputVGT = vgt;
    CreateView( vgt, 8, 304, 8+ViewWidth(PadWidth), 
    		304+ViewHeight(PadHeight), 0, 0, 0, 0);

    TtyMessage( "SUN Virtual Graphics Terminal Service" );
    TtyMessage( "With multiple executives" );
	/*
	 * set up stderr to go to the VGTS
	 */
    stderr = (File *)malloc(sizeof(File));
    *stderr = *stdout;
    stderr->fileid = TtyVGT;
    stderr->fileserver = GetPid(VGT_SERVER,ANY_PID);

    SpawnExec(InputVGT);

    /*
     * The main VGTS loop: wait for a message and take appropriate action,
     * forever.
     */
    while (1) GetMessage( 0, 0, msg );
 }


