/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Main program for the server exec.
 *
 * Tim Mann (TPM), 8/19/83, Created
 * Kenneth Brooks, ??/??/??, Hacked
 * TPM 3/28/84, Changed to use QueryWorkstationConfig.
 */

#include <Venviron.h>
#include <Vioprotocol.h>
#include <Vgts.h>

int RootStackSize = 0x8000;

short ExecDebug;		/* extra debugging information */

/* This structure is a truncated form of ExecDescriptor, containing only
 * the fields which the Exec is going to write in.  No use is made of this
 * information in the standalone exec.
 */
struct {
    ProcessId execPid;		/* pid of exec if any */
    ProcessId programPid;	/* program being executed if any */
    short status;		/* free, loading, or running */
    }  fakedescriptor;


/*
 * main:
 */

main()
  {
    File *startupScript;
    char startupScriptName[32];
    SystemCode error;
    ProcessId myPid;
    Message msg;

    InitFirstTeam();

    /* Figure out which startup script to read */
    error = QueryWorkstationConfig("startup-script", startupScriptName, 32);
    if (error != OK)
      {
	printf("Can't find startup script name: %s\n", ErrorString(error));
	exit(1);
      }

    startupScript = Open(startupScriptName, FREAD, &error);
    if (error != OK)
      {
	printf("Can't read startup script '%s': %s\n", 
	    startupScriptName, ErrorString(error));
	exit(1);
      }

    Exec(stdin, stdout, stderr, startupScript, &fakedescriptor);

    Close(startupScript);

    /* Hang forever */
    myPid = GetPid(ACTIVE_PROCESS, LOCAL_PID);
    ReceiveSpecific(msg, myPid);
  }
