/* autostart.c
 *
 * Kenneth Brooks, November 1983
 * 
 * Designed to be part of a world-root team.  It provides a convenient way
 * for that first team to start up other teams in order to get the world
 * going.  "progs" is an array of character pointers, each naming a program
 * to be started.  These programs will be invoked without arguments.
 */

#include <Vio.h>
#include <Vteams.h>

extern ProcessId GetPid();

char *autoargv[2] = {"", NULL};  /* the second one NULL is what matters */

AutoStart(count, progs, teamprio)
  int count;
  char *progs[];
  int teamprio;		/* scheduling priority class for auto-started teams */
  {
    int i;
    ProcessId newpid;
    SystemCode error;

    for (i=0; i<count; i++)
      {
	autoargv[0] = progs[i];
	newpid = ExecProgram(autoargv, NULL, NULL, NULL, NULL, &error);
	if (newpid == 0) 
	  {
	    fprintf(stderr, "Failed to start %s: %s\n",
			progs[i], ErrorString(error) );
	    exit(1);
	  }
	ChangeTeamPriority(newpid, teamprio);
      }
  }
