
/*
 * td.c - a kitchen sink demo for SUN graphics
 *
 *
 * Bill Nowicki March 1982
 *	- Parameterized bouncing stuff and worms
 *	- Parameterized the screen orientation
 *	- Added "s" option to change the screen orientation
 *	- Moved the master widgit off the screen in worms and balls
 *	- Separated definitions into td.h
 *	- Created unused.c with unused code in it
 *	- Added stuff for CadLink configurations
 *	- Now reads configuration register!
 *
 * April 16, 1982	Bill Nowicki
 *	- Added GXProbe for new frame buffer address
 *
 * May 15, 1982		Bill Nowicki
 *	- Uses DJB's RasterOp package instead of special hack code
 *	- Fixed off by one problem in clear and set screen
 *	- Fixed bug in Colliding Balls that left scattered garbage
 *	- Changed worms slightly
 *
 * July 6, 1982		Bill Nowicki
 *	- Updated fro new RasterOps
 *	- removed "graphmacs" references
 *	- Used ScreenClear from library
 *
 * AUG 18, 1985		Chris Zuleeg
 * 	- Changed emt_getconfig to K_getconfig
 *	- Changed emt_mayget to K_mayget.
 */

#include "stdio.h"
#include <Vtermagent.h>
# include "td.h"
/* #include <ipl.h> */
# define PortraitBit (1<<3)
#define CTRL(x) ((x) & 31)

char c;
int param, hitkey;

int Xmax = 799,		/* X axis in pixels - changed by the 's' command */
    Ymax = 1023,	/* same for Y axis */
    Mode = 0;		/* 0 = portrait mode, 1 = landscape */
    
extern VRaster *WholeScreen;

main() 
 {   
    int quitting = false;
    long config;

   printf("Starting...");
   Xmax = WholeScreen[-1].bBox.h - 1;
   Ymax = WholeScreen[-1].bBox.v - 1;
#ifdef VAX
/*   Xmax = 1023;   Ymax = 800;*/
   QvssInit();
#else
   Sun2_EnableScreen();
#endif
#if 0
   GXBase  = GXProbe();
   if (GXBase == 0) 
     {
       printf( "No Frame Buffer found!\n" );
       exit(0);
     }
    config = K_getconfig();
    if (config>=0 && (config & PortraitBit) )
      {
 	   /*
	    * Set screen parameters to Landscape mode if
	    * the board has configuration register PROMs
	    */
         Mode = 1;
	 Xmax = 1023;
	 Ymax = 800;
      }
#endif
    ScreenClear();
    param = 0;
    hitkey = false;
    c = '?';
#ifndef STANDALONE
    SpawnTtyReader();
    ModifyPad(stdin, LF_Output);
#endif
    initrandom();
    while (!quitting) 
     {
        switch (c) 
	{
        case 'a':ripple(); continue;
        case 'b':SlidingSquares(); continue;
        case 'c':circle1(); continue;
        case 'd':mysins( Xmax/2, Ymax/2, 390 ); help(); continue; 
        case 'e':munch(); continue;
/*      case 'f':tetra(); continue; */
/*      case 'g':localop(); continue; */
        case 'h':circle2(); continue;
        case 'i':BouncingSquare(); continue;
/*      case 'j':fractal(); continue; */
/*      case 'k':BallsWorms( SET ); continue; */
/*      case 'l':spheres(); continue; */
        case 'm':grandmal(); continue;
        case 'n':WallPaper(); continue;
        case 'o':schwartz(); continue;
        case 'q': case 'Q': case CTRL('Z'): case CTRL('C'): case CTRL('D'):
		quitting=true; continue;
	case 's':ScreenParameters(); continue;
       /* case 't':trees(); continue; */
	case 'u':BallsWorms( CLEAR ); continue;
/*
	case 'v':nkal(); continue;
	case 'w':rotor(); continue;
	case 'x':ncyl(); continue;
	case 'y':burst(); continue;
	case 'z':frect(); continue;
 */
	case ' ':while (!keyhit()); continue;
        default: help(); continue;
        }
    }
}


ScreenParameters()
  {
    /*
     * Toggle the screen parameters.
     * To change the values read from the configuration register
     */
     if (Mode)
       {
         Mode = 0;
	 printf( "\nChange to portrait mode, 800 wide by 1024 high\n");
	 Xmax = 799;
	 Ymax = 1023;
       }
      else
       {
         Mode = 1;
	 printf( "\nChange to landscape mode, 1024 wide by 800 high\n");
	 Xmax = 1023;
	 Ymax = 800;
	}
   while (!keyhit());
  }


#define P       98
#define Q       27
#define Pm1     (P-1)
            
int Table[P];
int I, J;

initrandom() {
  I = Pm1;
  J = (I + Q) % P;
  Table[ 0] = 0020651;
  Table[ 1] = 0147643;
  Table[ 2] = 0164707;
  Table[ 3] = 0125262;
  Table[ 4] = 0104256;
  Table[ 5] = 0074760;
  Table[ 6] = 0114470;
  Table[ 7] = 0052607;
  Table[ 8] = 0045551;
  Table[ 9] = 0134031;
  Table[10] = 0024107;
  Table[11] = 0030766;
  Table[12] = 0154073;
  Table[13] = 0114777;
  Table[14] = 0024540;
  Table[15] = 0111012;
  Table[16] = 0011042;
  Table[17] = 0104067;
  Table[18] = 0056332;
  Table[19] = 0142244;
  Table[20] = 0131107;
  Table[21] = 0034074;
  Table[22] = 0052641;
  Table[23] = 0163046;
  Table[24] = 0026303;
  Table[25] = 0131352;
  Table[26] = 0077724;
  Table[27] = 0002462;
  Table[28] = 0110775;
  Table[29] = 0127346;
  Table[30] = 0020100;
  Table[31] = 0137011;
  Table[32] = 0136163;
  Table[33] = 0145552;
  Table[34] = 0144223;
  Table[35] = 0134111;
  Table[36] = 0075001;
  Table[37] = 0075221;
  Table[38] = 0176705;
  Table[39] = 0000210;
  Table[40] = 0103625;
  Table[41] = 0120246;
  Table[42] = 0062614;
  Table[43] = 0016147;
  Table[44] = 0054723;
  Table[45] = 0151200;
  Table[46] = 0105223;
  Table[47] = 0021001;
  Table[48] = 0016224;
  Table[49] = 0073377;
  Table[50] = 0150716;
  Table[51] = 0014557;
  Table[52] = 0112613;
  Table[53] = 0037466;
  Table[54] = 0002677;
  Table[55] = 0052542;
  Table[56] = 0063572;
  Table[57] = 0105462;
  Table[58] = 0106436;
  Table[59] = 0063302;
  Table[60] = 0053171;
  Table[61] = 0133243;
  Table[62] = 0113130;
  Table[63] = 0123222;
  Table[64] = 0072371;
  Table[65] = 0041043;
  Table[66] = 0163614;
  Table[67] = 0037432;
  Table[68] = 0147330;
  Table[69] = 0153403;
  Table[70] = 0130306;
  Table[71] = 0056455;
  Table[72] = 0175640;
  Table[73] = 0120567;
  Table[74] = 0100601;
  Table[75] = 0042371;
  Table[76] = 0154635;
  Table[77] = 0051133;
  Table[78] = 0074252;
  Table[79] = 0174525;
  Table[80] = 0163223;
  Table[81] = 0052022;
  Table[82] = 0022564;
  Table[83] = 0135512;
  Table[84] = 0021760;
  Table[85] = 0006743;
  Table[86] = 0006451;
  Table[87] = 0067445;
  Table[88] = 0106210;
  Table[89] = 0025417;
  Table[90] = 0066566;
  Table[91] = 0062723;
  Table[92] = 0124224;
  Table[93] = 0144643;
  Table[94] = 0164502;
  Table[95] = 0025342;
  Table[96] = 0003521;
  Table[97] = 0024050;
}

int random() {

  if (I == Pm1) I = 0; else I = I + 1;
  if (J == Pm1) J = 0; else J = J + 1;
  Table[I] = Table[I] ^ Table[J];
  return (Table[I]);
}

ScrPrint() {}

#ifndef STANDALONE
int lastChar = 0;
TtyReader()
  {
    for (;;)
	lastChar = getchar();
  }
SpawnTtyReader()
  {
    Ready(Create(0, TtyReader, 2000), 0);
  }
#endif


int keyhit() 
 {
   	/*
	 * returns true if the user has hit a new key
	 */
#ifdef STANDALONE
    int tmp = K_mayget();
    if (tmp > 0)
      {
	c = tmp;
#else
    if (lastChar != 0)
     {
        c = lastChar; lastChar = 0;
#endif
        if (('0'<=c) && (c<='9')) 
	 {
            if (hitkey) param=0;
            param=param*10+(c-'0');
            hitkey=false;
        } else hitkey = true;
        return (hitkey);
    } else
        return (false);
}

int r (i, j)
int i, j;
  {
    int k;

    k = random() % (j-i+1);
    if (k<0) return(k+j+1);
    else return(k+i);
  }


int sqroot (x)
int x;
 {
    int v, i;
    v=0;
    i=128;
    while (i!=0) {
        if ((v+i<=180) && ((v+i)*(v+i)<=x))
            v=v+i;
        i=i/2;
    }
    return (v);
  }

help()
 {
putchar('\f');
printf ("\n ------ SUN Workstation graphics demo ------ \n");
printf ("\n");
#if 0
printf ("Jeff Mogul, Bill Nowicki, Vaughan Pratt, Mike Spreitzer -- Stanford\n");
printf ("Tom Duff, Dan Silva and John Seamons -- Lucasfilm, Ltd.\n\n");
printf ("Ported to MicroVAX by Per Bothner -- Stanford\n");
printf("    Current screen parameters: %s mode\n\n", Mode ? "landscape" : "portrait" );
    printf ("Type the given single letter:\n");
    printf ("    a for rippling rectangles      s to change screen parameters\n");
    printf ("    b for sliding squares          u for worms\n");
    printf ("    c for xor circle               v for kaleidoscope\n");
    printf ("    d for sinusoids                w for rotating spiral\n");
    printf ("    e for munching squares (*)     x for cylinders\n");
    printf ("    h for random circles           y for sun burst\n");
    printf ("    i for bouncing square          z for fast rectangles\n");
    printf ("    i for bouncing square\n");
    printf ("    j for fractal contour maps   <space> holds the pattern\n");
    printf ("    k for colliding balls\n");
    printf ("    l for shaded spheres\n");
    printf ("    m for grand mal\n");
    printf ("    n for wallpaper\n");
    printf ("    o for a Lillian Schwartz movie\n");
    printf ("    q to quit\n");
#endif
    printf ("Type the given single letter:\n");
    printf ("    a for rippling rectangles\n");
    printf ("    b for sliding squares\n");
    printf ("    c for xor circle\n");
    printf ("    e for munching squares (*)\n");
    printf ("    h for random circles\n");
    printf ("    i for bouncing square\n");
    printf ("    m for grand mal\n");
    printf ("    n for wallpaper\n");
/*  printf ("    o for a Lillian Schwartz movie\n");*/
    printf ("    u for worms\n");
    printf ("   <space> holds the pattern\n");
    printf ("    q to quit\n");
    while (!keyhit());
}

ripple() 
 {
    int XSIZE = 383, YSIZE = 512;
    int x, y, xinc, yinc;
    xinc=1;
    yinc=1;
    ScreenSet();
    x=0;
    y=0;
    GXfunction = NOT;
    while (!keyhit()) {
        if ((x!=0) && (y!=0))
            rasterop1 (x*2, y*2, 384-x, 512-y);
        x=x+xinc;
        if ((x==XSIZE) || (x==0)) xinc= -xinc;
        y=y+yinc;
        if ((y==YSIZE) || (y==0)) yinc= -yinc;
    }
}

SlidingSquares() 
 {
    int x, y, xinc, yinc, i;
    xinc=1;
    yinc=1;
    ScreenSet();
    x=0;
    y=0;
    GXfunction = NOT;
    for (y=0; y<129; x+=2,y+=2)
      rasterop1(129-y, 1, x, y);
    x=0;
    y=0;
    while (!keyhit()) 
     {
        rasterop1 (129, 129, x, y);
        x=x+xinc;
        if ((x==Xmax-129) || (x==0)) xinc= -xinc;
        y=y+yinc;
        if ((y==Ymax-129) || (y==0)) yinc= -yinc;
    }
}

circle1() {
    int x, y;

    ScreenSet();
    GXfunction = NOT;
    for (x=0; x<=180; x++) {
        y=0;
        while ((x*x+y*y)<(180*180)) y=y+1;
        if ((x!=0) && (y!=0))
            rasterop1 (2*x, 2*y, 384-x, 512-y);
    }
    while (!keyhit());
}


munch() {
    int x, y, t, dt, x_max = (Xmax + 1) / 2;
    ScreenSet();
    if (param==0) dt=1; else dt=param;
    t=0;
    GXfunction = NOT;
    while (!keyhit()) {
        for (x=0; x<=x_max; x++) {
            y=2*(x ^ t);
	    if (y + 1 <= Ymax)
        	rasterop1 (2, 2, 2*x, y);
        }
        t=t+dt;
    }
}


circle2() 
 {
    int x, y, z;

    while (!keyhit()) 
     {
        ScreenSet();
        GXfunction = NOT;
        for (x=1; x<=20; x++) {
            y = random() % 179;
            if (y<=0) y=y+179;
            z=1;
            while ((y*y+z*z)<(180*180)) z=z+1;
            rasterop1 (4*z,4*y,384-2*z,512-2*y);
            z = random() % 179;
            if (z<=0) z=z+179;
            y=1;
            while ((y*y+z*z)<(180*180)) y=y+1;
            rasterop1 (4*z,4*y,384-2*z,512-2*y);
        }
        for (x=1; x<=32766; x++)
            for (y=1; y<=2; y++);
    }
}

BouncingSquare() 
 {
    int x, y, vx, vy, z;

    ScreenSet();
    x=0;
    y=0;
    vx=4;
    vy=0;
    GXfunction = NOT;
    while (!keyhit()) 
     {
        rasterop1( 20, 20, x, y );
        x=x+vx;
        if (x>(Xmax-20)) 
	 {
	 	/*
		 * Bounce off the right edge
		 */
            x=2*(Xmax-20)-x;
            vx= -vx;
         }
        else if (x<0) 
	  {
	  	/*
		 * bounce off the right edge
		 */
            x= -x;
            vx= -vx;
         }
        vy=vy+1;
        y=y+vy;
        if (y>=(Ymax-20)) 
	 {
            y=Ymax-20;
            if (vy<20) vy=1-vy;
            else vy=vy / 20 - vy;
            if (vy==0) 
	     {
                x=0;
                y=0;
                vx=4;
                vy=0;
             }
        }
        for (z=0; z<=1000; z++);
    }
}

int nums[1024], done;

int frac_r (n, a, b)
int n, a, b;
 {
    int v;

    v = nums[n] % (b-a+1);
    if (v<0)
        return(v+b+1);
    else
        return(v+a);
 }

surf (x0, y0, size, h0, n0, h1, n1, h2, n2, h3, n3)
int x0, y0, size, h0, n0, h1, n1, h2, n2, h3, n3;
{
    int h01, n01, h12, n12, h23, n23, h30, n30, hc, nc;

    if (!done) 
     {
        done=keyhit();
        if (size==1) {
            if ((((h0+h1+h2+h3) / 4) & 64) != 0)
		GXfunction = XOR;
	    else
		GXfunction = XORNOT;
            rasterop1 (1, 1, x0, y0);
        }
      else 
	  {
            n01=(n0+n1) % 1024;h01=(h0+h1) / 2+frac_r(n01, -size, size);
            n12=(n1+n2) % 1024;h12=(h1+h2) / 2+frac_r(n12, -size, size);
            n23=(n2+n3) % 1024;h23=(h2+h3) / 2+frac_r(n23, -size, size);
            n30=(n3+n0) % 1024;h30=(h3+h0) / 2+frac_r(n30, -size, size);
            nc=(n0+n1+n2+n3)% 1024;
            hc=(h01+h12+h23+h30) / 4+frac_r(nc, -size, size);
            size=size / 2;
            surf(x0     , y0     , size, h0, n0, h01, n01, hc, nc, h30, n30);
            surf(x0+size, y0     , size, h01, n01, h1, n1, h12, n12, hc, nc);
            surf(x0+size, y0+size, size, hc, nc, h12, n12, h2, n2, h23, n23);
            surf(x0     , y0+size, size, h30, n30, hc, nc, h23, n23, h3, n3);
        }
    }
}

fractal() 
  {
    int i;

    ScreenSet();
    done=false;
    while (!done) 
      {
        for (i=0; i<1024; i++) nums[i]=random();
        surf(128, 256, 512, 0, 0, 0, 1, 0, 2, 0, 3);
      }
  }

BallsWorms( op ) 
 short op;
 {
 	/*
	 * This gives you either colliding balls or worms, depending
	 * on the parameter "op".
	 * SET gives you balls, CLEAR gives you worms
	 */
#define N 20
#define OffScreen 816
    int i, j, a, b, d, x0, y0, t;
    int x[N], y[N], vx[N], vy[N];
    short circleBuffer[ (N+15)/16 * N ];

/*
 * First we make a square with a circle in it off the screen
 */
    ScreenSet();
    GXfunction = CLEAR;
    rasterop1 (N, N, OffScreen, OffScreen);
    GXfunction = SET;
    for (i=1; i<=9; i++) 
     {
        j=sqroot(10*10-i*i);
        rasterop1 (2*i, 2*j, 10-i+OffScreen, 10-j+OffScreen);
        rasterop1 (2*j, 2*i, 10-j+OffScreen, 10-i+OffScreen);
     }
       /*
        * Now store away the circle in on-board RAM, plus a bar on top
	* if we are in worm mode.
	*/
    ReasonableGet( OffScreen, OffScreen, N, N, circleBuffer, GXcopy);
    if (op!=SET) 
      {
        circleBuffer[0] = -1;
        circleBuffer[1] = -1;
      }
    for (i=0; i<N; i++) 
      {
        x[i]=r(0, Xmax-N);
        y[i]=r(0, Ymax-N);
        vx[i]=r(-6, 6);
        vy[i]=r(-6, 6);
        ReasonablePut( x[i], y[i], N, N, circleBuffer, XOR);
      }
    while (!keyhit())
     {
        for (i=0; i<N; i++) 
	 {
            x0=x[i];
            y0=y[i];
	    if ( abs(vx[i])>6 ) 
	      {
	        printf( "Weird value (%d) for vx[%d]\n", vx[i], i );
	        vx[i] = r(-6, 6);
	      }
            x[i]=x[i]+vx[i];
            if (x[i]<0) 
	     {
	     	/*
		 * Bounce off the left wall
		 */
                x[i]= -x[i];
                vx[i]= -vx[i];
            } else if (x[i]>Xmax-N) 
	     {
	      	  /*
		   * Bounce off the right wall
		   */
                x[i]=2*(Xmax-N)-x[i];
                vx[i]= -vx[i];
            }
	    if ( abs(vy[i])>6 ) 
	      {
	        printf( "Weird value (%d) for vy[%d]\n", vy[i], i );
	        vy[i] = r(-6, 6);
	      }
            y[i]=y[i]+vy[i];
            if (y[i]<0) 
	     {
	     	  /*
		   * Bounce off the top
		   */
                y[i]= -y[i];
                vy[i]= -vy[i];
            }
	   else if (y[i]>Ymax-N) 
	      {
	      	  /*
		   * Bounce off the bottom
		   */
                y[i]=2*(Ymax-N)-y[i];
                vy[i]= -vy[i];
              }
	    GXfunction = op;
	    rasterop1 (N, N, x0, (op==SET) ? y0 : y0+ 1);
            ReasonablePut( x[i], (op==SET) ? y[i] : y[i]-1, N, N, circleBuffer, XOR);
          }
        for (i=0; i<N-1; i++)
	 {
            for (j=i+1; j<N; j++)
	      {
	    	  /*
		   * Check each pair of balls for collisions
		   */
                x0=x[i]-x[j];
                y0=y[i]-y[j];
                if ((abs(x0)<N) && (abs(y0)<N) && (x0*x0+y0*y0<N*N)) 
		 {
                    if (y0<0) 
		      {
                        y0= -y0;
                        x0= -x0;
                      }
                    if ((10*abs(x0))>(10*y0)) 
		     {
		           /*
			    * flip both horizontal velocities
			    */
                        vx[i]= -vx[i];
                        vx[j]= -vx[j];
                     }
		    else if ((10*y0)>(12*abs(x0))) 
		      {
		      	    /*
			     * Flip both vertical velocities
			     */
                        vy[i]= -vy[i];
                        vy[j]= -vy[j];
                      }
		     else if (y0>0) 
		      {
		      	   /*
			    * Flip both and transpose x & y
			    */
                        t=vx[i];
                        vx[i]= -vy[i];
                        vy[i]= -t;
                        t=vx[j];
                        vx[j]= -vy[j];
                        vy[j]= -t;
                      } 
		    else 
		      {
		      	   /*
			    * Flip horizontal and transpose x & y
			    */
                        t=vx[i];
                        vx[i]= -vy[i];
                        vy[i]=t;
                        t=vx[j];
                        vx[j]= -vy[j];
                        vy[j]=t;
                      }
                 }

            }
        }
    }
}


#define NX 48
#define NY -36
#define NZ 80

sphere (x0, y0, rad)
int x0, y0, rad;
{
    int i, x, y, zsq;

    GXsetSource = 0;
    for (x= -rad; x<=rad; x++) {
        if (!done)
	  {
            done=keyhit();
            for (y= -rad; y<=rad; y++) {
               zsq=rad*rad-x*x-y*y;
               if (zsq>=0) {
                   i=NX*x+NY*y+NZ*sqroot(zsq);
                   if (r(0, rad*100)>i)
                       GXfunction = XORNOT;
                   else
                       GXfunction = XOR;
                   rasterop1 (1, 1, x+x0, y+y0);
               }
           }
       }
    }
}

spheres() 
 {
    ScreenSet();
    done=false;
    while (!done)
        sphere(r(180, 767-180), r(180, 1023-180), r(50, 180));
 }

#define SIZE 128

combox(x, y, xs, ys)
int x, y, xs, ys;
{

    if (x<0) { xs=xs+x; x=0; }
    if (y<0) { ys=ys+y; y=0; }
    if ((x<1024) && (y<1024)) {
        if (x+xs>1023) xs=1023-x;
        if (y+ys>1023) ys=1023-y;
        if ((xs>0) && (ys>0))
            rasterop1 (xs, ys, x, y);
    }
}

int flag;

grandmal() 
 {
   int x0, y0, x1, y1, t, vx0, vy0, vx1, vy1, snooze;

   ScreenSet();
   x0=384;
   y0=512;
   x1=384;
   y1=512;
   vx0=0;
   vy0=0;
   vx1=0;
   vy1=0;
   flag=NOT;
   while (!keyhit()) 
    {
       GXfunction = flag;
       if ((x0!=x1) && (y0!=y1))
           combox (x0, y0, (x1-x0), (y1-y0));
       if (r(1, 10)!=1) flag=NOT; else flag=SET;
       vx0=vx0+r(-1, 1);
       if (vx0<-5) vx0= -5; else if (5<vx0) vx0=5;
       x0=x0+vx0;
       if (x0<0) {
           x0= -x0;
           vx0= -vx0;
       } else if (Xmax<x0) 
         {
           x0=2*Xmax-x0;
           vx0= -vx0;
       }
       vx1=vx1+r(-1, 1);
       if (vx1<-5) vx1= -5; else if (5<vx1) vx1=5;
       x1=x1+vx1;
       if (x1<0) {
           x1= -x1;
           vx1= -vx1;
       } else if (Xmax<x1) {
           x1=2*Xmax-x1;
           vx1= -vx1;
       }
       if (x0>x1) {
           t=x0;x0=x1;x1=t;
           t=vx0;vx0=vx1;vx1=t;
       }
       vy0=vy0+r(-1, 1);
       if (vy0<-5) vy0= -5; else if (5<vy0) vy0=5;
       y0=y0+vy0;
       if (y0<0) {
           y0= -y0;
           vy0= -vy0;
       } else if (Ymax<y0) {
           y0=2*Ymax-y0;
           vy0= -vy0;
       }
       vy1=vy1+r(-1, 1);
       if (vy1<-5) vy1= -5; else if (5<vy1) vy1=5;
       y1=y1+vy1;
       if (y1<0) {
           y1= -y1;
           vy1= -vy1;
       } else if (Ymax<y1) {
           y1=2*Ymax-y1;
           vy1= -vy1;
       }
       if (y0>y1) 
        {
           t=y0;y0=y1;y1=t;
           t=vy0;vy0=vy1;vy1=t;
        }
   }
}

WallPaper() 
 {
 	/*
	 * 64 concurrent small versions of the above pattern
	 */
   int x0, y0, x1, y1, t, vx0, vy0, vx1, vy1, i, j;
   ScreenSet();
   x0=0;
   y0=0;
   x1=0;
   y1=0;
   vx0=0;
   vy0=0;
   vx1=0;
   vy1=0;
   while (!keyhit()) 
    {
       if (r(1, 10)!=1) GXfunction=NOT; else GXfunction=SET;
       for (i= -1; i<= (Mode ? 7 : 5); i++)
           for (j= -1; j<= (Mode ? 5 : 7); j++)
               combox(x0+i*SIZE, y0+j*SIZE, x1-x0, y1-y0);
       vx0=vx0+r(-1, 1);
       if (vx0<-5) vx0= -5; else if (5<vx0) vx0=5;
       x0=x0+vx0;
       if (x0<0) {
           x0= -x0;
           vx0= -vx0;
       } else if (SIZE<x0) {
           x0=2*SIZE-x0;
           vx0= -vx0;
       }
       vx1=vx1+r(-1, 1);
       if (vx1<-5) vx1= -5; else if (5<vx1) vx1=5;
       x1=x1+vx1;
       if (x1<0) {
           x1= -x1;
           vx1= -vx1;
       } else if (SIZE<x1) {
           x1=2*SIZE-x1;
           vx1= -vx1;
       }
       if (x0>x1) {
           t=x0;x0=x1;x1=t;
           t=vx0;vx0=vx1;vx1=t;
       }
       vy0=vy0+r(-1, 1);
       if (vy0<-5) vy0= -5; else if (5<vy0) vy0=5;
       y0=y0+vy0;
       if (y0<0) {
           y0= -y0;
           vy0= -vy0;
       } else if (SIZE<y0) {
           y0=2*SIZE-y0;
           vy0= -vy0;
       }
       vy1=vy1+r(-1, 1);
       if (vy1<-5) vy1= -5; else if (5<vy1) vy1=5;
       y1=y1+vy1;
       if (y1<0) {
           y1= -y1;
           vy1= -vy1;
       } else if (SIZE<y1) {
           y1=2*SIZE-y1;
           vy1= -vy1;
       }
       if (y0>y1) 
        {
           t=y0;y0=y1;y1=t;
           t=vy0;vy0=vy1;vy1=t;
        }
   }
}

schwartz() 
  {
    int i, j;

    ScreenSet();
    i=100;
    while (!keyhit()) 
     {
	GXfunction = NOT;
	rasterop1 (384, 512, 192, 256);
        for (j=0; j<=i; j++);
        i=i+100;
        if (i==10000) i=100;
    }
  }
