/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 * display and buffer file or keyboard character
 */

#include <Vio.h>
#include "talk.h"
#ifdef DEBUG
#define Reply(msg, pid)	debugReply("notify", msg, pid)
#endif DEBUG

/* Imports */
extern TalkState Talker[MAXTALKERS];


SystemCode Notify(c)
    char c;
  /* notify everyone of file/keyboard character */
  {
    int slot;
    TalkMessage msg;

    /* see if everyone has buffer space */
    for (slot=1; slot<MAXTALKERS; slot++)
      if ((Talker[slot].status >= TALKING) && (Talker[slot].count == 15))
	return(BUSY);

    /* update our screen */
    viewPutc(Talker[0].view, c);
    viewFlush();

    /* buffer it up for everyone else */
    for (slot=1; slot<MAXTALKERS; slot++)
      if (Talker[slot].status >= TALKING)
	{
	  Talker[slot].buffer[Talker[slot].count] = c;
	  Talker[slot].count++;
	  if (Talker[slot].status == WAITING)
	    {
	      /* sender is waiting - give it to him now */
	      Talker[slot].buffer[Talker[slot].count] = '\0';
	      msg.requestcode = OK;
	      strcpy(msg.text, Talker[slot].buffer);
	      Reply(&msg, Talker[slot].sender);
	      Talker[slot].count = 0;
	      Talker[slot].status = TALKING;
	    }
	}
    return(OK);
  }
