/*
 * Talk - interworkstation communications
 * Andrew B. Hastings
 *
 * helper processes
 */

#include <Vgts.h>
#include <Vio.h>
#include <Vtermagent.h>
#include "talk.h"
#ifdef DEBUG
#define Send(msg, pid)	debugSend("helper", msg, pid)
#endif DEBUG

/* Imports */
extern TalkState Talker[MAXTALKERS];
extern File *viewFile2;
extern File *readingFile;
extern File *padin;


depart()
  /*
   * Quitting - send LEAVE_TALK to other talkers
   */
  {
    TalkMessage msg;
    int i;

    for (i=1; i<MAXTALKERS; i++)
      if (Talker[i].status >= TALKING)
	{
	  if (ValidPid(Talker[i].sender))
	    Destroy(Talker[i].sender);
	  msg.requestcode = LEAVE_TALK;
	  msg.teamserver = Talker[0].teamserver;
	  msg.talker = Talker[0].pid;
	  Send(&msg, Talker[i].pid);
	}
    exit(0);
  }



Finish(slot)
    int slot;
  /*
   * perform interaction with remote talk to complete invitation
   */
  {
    TalkMessage msg;
    SystemCode code;
    int i;

    /* send initial startup message to invitee */
    msg.requestcode = RESERVE_SLOT;
    msg.teamserver = Talker[slot].teamserver;
    msg.talker = Talker[slot].pid;
    msg.invitorteamserver = Talker[0].teamserver;
    Send(&msg, Talker[slot].pid);
    if (msg.requestcode != OK)
      {
	/* something's screwed up, notify our talker */
	msg.requestcode = LEAVE_TALK;
	msg.teamserver = Talker[slot].teamserver;
	msg.talker = Talker[slot].pid;
	msg.invitorteamserver = Talker[0].teamserver;
	Send(&msg, Talker[0].pid);
	return;
      }

    /* make sure everyone else has space */
    for (i=1; i<MAXTALKERS; i++)
      if (Talker[i].status >= TALKING)
	{
	  msg.requestcode = RESERVE_SLOT;
	  msg.teamserver = Talker[slot].teamserver;
	  msg.talker = Talker[slot].pid;
	  msg.invitorteamserver = Talker[0].teamserver;
	  Send(&msg, Talker[i].pid);
	  if (msg.requestcode == NO_SERVER_RESOURCES)
	    break;
	}
    code = LEAVE_TALK;
    if (i == MAXTALKERS)
      {
	/* tell invitee to continue with invitation */
	msg.requestcode = JOIN_TALK;
	msg.teamserver = Talker[slot].teamserver;
	msg.talker = Talker[slot].pid;
	Send(&msg, Talker[slot].pid);
	if (msg.requestcode == OK)
	  {
	    /* invitee accepted - tell of other talkers */
	    for (i=0; i<MAXTALKERS; i++)
	      if ((i != slot) && (Talker[i].status != INACTIVE))
		{
		  msg.requestcode = (Talker[i].status == RESERVED) ?
					RESERVE_SLOT : JOIN_TALK;
		  msg.teamserver = Talker[i].teamserver;
		  msg.talker = Talker[i].pid;
		  msg.invitorteamserver = Talker[i].invitorteamserver;
		  Send(&msg, Talker[slot].pid);
		}
	    code = JOIN_TALK;
	  }
      }

    /* tell everybody what happened */
    for (i=0; i<MAXTALKERS; i++)
      if ((Talker[i].status >= TALKING) && (i != slot))
	{
	  msg.requestcode = code;
	  msg.teamserver = Talker[slot].teamserver;
	  msg.talker = Talker[slot].pid;
	  msg.invitorteamserver = Talker[0].teamserver;
	  Send(&msg, Talker[i].pid);
	}
  }




getfilein()
  /*
   * read characters from file
   */
  {
    TalkMessage msg;
    int c;

    while ((c = getc(readingFile)) != EOF)
      do
	{
	  msg.text[0] = c;
	  msg.requestcode = FILE_CHAR;
	  msg.talker = Talker[0].pid;
	  Send(&msg, Talker[0].pid);
	}
      while (msg.requestcode == BUSY);
  }




getinput()
  /*
   * read characters from keyboard
   */
  {
    TalkMessage msg;
    int c;

    while ((c = getc(padin)) != EOF)
      do
	{
	  msg.requestcode = INPUT_CHAR;
	  msg.text[0] = c;
	  msg.talker= Talker[0].pid;
	  Send(&msg, Talker[0].pid);
	}
      while (msg.requestcode == BUSY);
  }




openlog()
  /*
   * create separate pad for log file
   */
  {
    File *pad;
    File *OpenPad();
    SystemCode error;

    pad = OpenPad("talk log", PadHeight, PadWidth, &error);
    if (error != OK)
      pad = (File *) 0;
    if (pad)
      {
	ModifyPad(pad, LF_Output);
	/* make sure pad sticks around when we die */
	SetInstanceOwner(FileServer(pad), FileId(pad), Talker[0].pid);
	/*
	 * This is bad form - helper process shouldn't write shared
	 * data structures.  But I know that the only other way that
	 * viewFile2 can be changed is if the user does ^[L.  This
	 * cannot occur until he clicks the mouse to create the pad.
	 * So the only way we can screw up here is if the user manages
	 * to hit ^[L between the time we open the pad, and the time
	 * this statement is executed.  The probability of this is very
	 * low, and even if it does happen, the effects are not at all
	 * dangerous.
	 */
	viewFile2 = pad;
      }
  }




Sender(pid)
    ProcessId pid;
  /*
   * request characters from our talker to send to remote talker
   */
  {
    TalkMessage msg;

    for (;;)
      {
	msg.requestcode = GIMME_CHAR;
	msg.talker = pid;
	Send(&msg, Talker[0].pid);
	msg.requestcode = REMOTE_CHAR;
	msg.talker = Talker[0].pid;
	msg.teamserver = Talker[0].teamserver;
	Send(&msg, pid);
	if (msg.requestcode != OK)
	  {
	    msg.requestcode = SEND_FAILED;
	    msg.talker = pid;
	    Send(&msg, Talker[0].pid);
	  }
      }
  }
