#include <Venviron.h>
#include <stdio.h>
#include <Vgts.h>
#include <Vio.h>
#include <Vquerykernel.h>
#include <Vethernet.h>

int RootStackSize = 8196;

#define INTERVAL 12	/* seconds per update */

#define TOPITEM 1

#define ProcBase 128
int ProcHorz = 0;
int ProcVert = 0;

#define MemBase 256
int MemHorz = 0;
int MemVert = 0;

#define EtherBase 384
int EtherHorz = 0;
int EtherVert = 0;

int Processor = 1, Memory = 1, Ethernet = 1;
int SawSpec = 0;
int Fixed ;
int Across = 1;

int TotalHorz, TotalVert;

short vgt, sdf ;
ProcessId watchpid;
extern ProcessId Kernel_Process_Pid;
char Name[256];
int etherscale;

main(argc, argv)
    int argc ;
    char *argv[] ;
  {
    Message msg;
    int watch();
    SystemCode QueryWorkstationConfig();
    
    while (argc > 1)
      {
	if (argv[1][0] == '-')
	  {
	    register char *cp;
	    
	    for (cp = argv[1]+1; *cp; cp++)
	      {
	        switch(*cp)
		  {
		case 'f':	/* Fixed position */
		    Fixed = 1;
		    break;
		case 'd':	/* display down instead of Across */
		    Across = 0;
		    break;
		case 'e':
		case 'p':
		case 'm':
		    if (!SawSpec++)
		      {
		        Ethernet = 0;
			Processor = 0;
			Memory = 0;
		      }
		    switch (*cp)
		      {
		    case 'e':
		        Ethernet = 1;
			break;
		    case 'p':
		        Processor = 1;
			break;
		    case 'm':
		        Memory = 1;
			break;
		      }
		    break;
		default:
		    fprintf(stderr, "Unknown option -%c ignored\n", *cp);
		    fflush(stderr);
		  }
	      }
	  }
	else
	  {
	    fprintf(stderr, "Usage: mon -[fdmpe]\n");
	    exit(1);
	  }
	argc--;
	argv++;
      }


    if (QueryWorkstationConfig("name", Name, 80) != OK)
        strcpy(Name, "Status");
    strcat(Name, "                                                         ") ;
    strcat(Name, "                                                         ") ;
    strcat(Name, "                                                         ") ;
    /* catch break */
    watchpid = Create (100, watch, 1024) ;
    Ready (watchpid, 0) ;
    SetBreakProcess (stdin, watchpid) ;

    Watchers();
  }

watch()
  {
    Message msg ;
    
    while (1)
        Receive (msg) ;
  }


Watchers()
  {
    short font, titlefont ;
    unsigned total, freem, freemem() ;
    float mem[75] ;
    float proc[75] ;
    int ether[75] ;
    int i ;
    font = DefineFont("Helvetica7", NULL ) ;
    titlefont = DefineFont("Clarity12", NULL);
    
    if (Across)
      {
	ProcHorz = MemHorz + 180*Memory;
	EtherHorz = ProcHorz + 180*Processor;
	TotalHorz = EtherHorz + 180*Ethernet;
	TotalVert = 160;
      }
    else
      {
        ProcVert = MemVert + 140*Memory;
	EtherVert = ProcVert + 140*Processor;
	TotalHorz = 180;
	TotalVert = EtherVert + 150*Ethernet + 10;
      }
    
    sdf = CreateSDF() ;
    if (sdf == -1)
      {
        fprintf(stderr, "Couldn't create SDF\n");
	exit(1);
      }

    DefineSymbol (sdf, TOPITEM, "Status");
    
    if (Memory)
      {
	AddItem(sdf, MemBase+2,  MemHorz+20, MemHorz+170, MemVert+15, MemVert+16, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, MemBase+3,  MemHorz+20, MemHorz+170, MemVert+65, MemVert+66, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, MemBase+4,  MemHorz+20, MemHorz+170, MemVert+115, MemVert+116, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, MemBase+5,  MemHorz+13, MemHorz+25, MemVert+12, MemVert+17, 
                 font, SDF_TEXT, "0") ;
	AddItem(sdf, MemBase+6,  MemHorz+7, MemHorz+20, MemVert+62, MemVert+67,
                  font, SDF_TEXT, "50") ;
	AddItem(sdf, MemBase+7,  MemHorz+2, MemHorz+15, MemVert+112, MemVert+117, 
                 font, SDF_TEXT, "100") ;
	AddItem(sdf, MemBase+8, MemHorz+20, MemHorz+21, MemVert+12, MemVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, MemBase+9, MemHorz+70, MemHorz+71, MemVert+12, MemVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, MemBase+10, MemHorz+120,MemHorz+121, MemVert+12, MemVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, MemBase+11, MemHorz+170,MemHorz+171, MemVert+12, MemVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, MemBase+12, MemHorz+60, MemHorz+71, MemVert+3, MemVert+10, 
                  font, SDF_TEXT, "-10") ;
	AddItem(sdf, MemBase+13, MemHorz+115,MemHorz+126, MemVert+3, MemVert+10, 
                  font, SDF_TEXT, "-5") ;
	AddItem(sdf, MemBase+14, MemHorz+30, MemHorz+60, MemVert+120, MemVert+125,
    		  titlefont, SDF_TEXT, "Memory");
	for (i=0; i<75; i++)
	  {
	    mem[i] = 0 ;
	    AddItem(sdf, MemBase+20+i, MemHorz+20+i*2, MemHorz+21+i*2, MemVert+15, 
	       (int) (MemVert+15+mem[i]*100), 0, SDF_VERTICAL_LINE, NULL) ;
	  }
      }
    
    if (Processor)
      {
	AddItem(sdf, ProcBase+2,  ProcHorz+20, ProcHorz+170, ProcVert+15, ProcVert+16, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, ProcBase+3,  ProcHorz+20, ProcHorz+170, ProcVert+65, ProcVert+66, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, ProcBase+4,  ProcHorz+20, ProcHorz+170, ProcVert+115, ProcVert+116, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, ProcBase+5,  ProcHorz+13, ProcHorz+25, ProcVert+12, ProcVert+17, 
                 font, SDF_TEXT, "0") ;
	AddItem(sdf, ProcBase+6,  ProcHorz+7, ProcHorz+20, ProcVert+62, ProcVert+67,
                  font, SDF_TEXT, "50") ;
	AddItem(sdf, ProcBase+7,  ProcHorz+2, ProcHorz+15, ProcVert+112, ProcVert+117, 
                 font, SDF_TEXT, "100") ;
	AddItem(sdf, ProcBase+8, ProcHorz+20, ProcHorz+21, ProcVert+12, ProcVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, ProcBase+9, ProcHorz+70, ProcHorz+71, ProcVert+12, ProcVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, ProcBase+10, ProcHorz+120,ProcHorz+121, ProcVert+12, ProcVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, ProcBase+11, ProcHorz+170,ProcHorz+171, ProcVert+12, ProcVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, ProcBase+12, ProcHorz+60, ProcHorz+71, ProcVert+3, ProcVert+10, 
                  font, SDF_TEXT, "-10") ;
	AddItem(sdf, ProcBase+13, ProcHorz+115,ProcHorz+126, ProcVert+3, ProcVert+10, 
                  font, SDF_TEXT, "-5") ;
	AddItem(sdf, ProcBase+14, ProcHorz+30, ProcHorz+60, ProcVert+120, ProcVert+125,
    		  titlefont, SDF_TEXT, "Processor");
	for (i=0; i<75; i++)
	  {
	    proc[i] = 0 ;
	    AddItem(sdf, ProcBase+20+i, ProcHorz+20+i*2, ProcHorz+21+i*2, ProcVert+15, 
	       (int) (ProcVert+15+proc[i]), 0, SDF_VERTICAL_LINE, NULL) ;
	  }
      }
    
    if (Ethernet)
      {
	AddItem(sdf, EtherBase+2,  EtherHorz+20, EtherHorz+170, EtherVert+15, EtherVert+16, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, EtherBase+3,  EtherHorz+20, EtherHorz+170, EtherVert+65, EtherVert+66, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, EtherBase+4,  EtherHorz+20, EtherHorz+170, EtherVert+115, EtherVert+116, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
	AddItem(sdf, EtherBase+5,  EtherHorz+13, EtherHorz+25, EtherVert+12, EtherVert+17, 
                 font, SDF_TEXT, "0") ;
	AddItem(sdf, EtherBase+6,  EtherHorz+7, EtherHorz+20, EtherVert+62, EtherVert+67,
                  font, SDF_TEXT, "25") ;
	AddItem(sdf, EtherBase+7,  EtherHorz+7, EtherHorz+15, EtherVert+112, EtherVert+117, 
                 font, SDF_TEXT, "50") ;
	AddItem(sdf, EtherBase+8, EtherHorz+20, EtherHorz+21, EtherVert+12, EtherVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, EtherBase+9, EtherHorz+70, EtherHorz+71, EtherVert+12, EtherVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, EtherBase+10, EtherHorz+120,EtherHorz+121, EtherVert+12, EtherVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, EtherBase+11, EtherHorz+170,EtherHorz+171, EtherVert+12, EtherVert+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
	AddItem(sdf, EtherBase+12, EtherHorz+60, EtherHorz+71, EtherVert+3, EtherVert+10, 
                  font, SDF_TEXT, "-10") ;
	AddItem(sdf, EtherBase+13, EtherHorz+115,EtherHorz+126, EtherVert+3, EtherVert+10, 
                  font, SDF_TEXT, "-5") ;
	AddItem(sdf, EtherBase+14, EtherHorz+30, EtherHorz+60, EtherVert+120, EtherVert+125,
    		  titlefont, SDF_TEXT, "Ethernet");
	for (i=0; i<75; i++)
	  {
	    ether[i] = 0;
	    AddItem(sdf, EtherBase+20+i, EtherHorz+20+i*2, EtherHorz+21+i*2, EtherVert+15, 
	       EtherVert+15+ether[i], 0, SDF_VERTICAL_LINE, NULL) ;
	  }
      }
    
    EndSymbol(sdf, TOPITEM, 0);

    vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, TOPITEM, Name) ;
    if (vgt < 0)
      {
        fprintf(stderr, "Couldn't create VGT\n");
	DeleteSDF(sdf);
	exit(1);
      }

    if (Fixed)
      {
        i = frameBuffer() ;
        switch (i) {
          case PRF_FRAMEBUFFER_SUN1:
     	    CreateView(  (int) vgt, 
    		  (short) 1025-TotalHorz, 	/*  sxmin          */
		  (short) 5,  		/*  symin          */
		  (short) 1025,  	/*  sxmax          */
		  (short) 5+TotalVert,  	/*  symax          */
		  (short) 0,  		/*  wxmin          */
		  (short) 0,  		/*  wymin          */
		  (char) 0, 0) ; 	/*  zoom, showgrid */
	    break ;

           case PRF_FRAMEBUFFER_SUN2:
           case PRF_FRAMEBUFFER_SUN3:
     	    CreateView(  (int) vgt, 
    		  (short) 1150-TotalHorz, 	/*  sxmin          */
		  (short) 5,  		/*  symin          */
		  (short) 1150,  	/*  sxmax          */
		  (short) 5+TotalVert,  	/*  symax          */
		  (short) 0,  		/*  wxmin          */
		  (short) 0,  		/*  wymin          */
		  (char) 0, 0) ; 	/*  zoom, showgrid */
	    break ;

          default:
	    printf("I don't know about framebuffer type %d.\n", i);
	    DefaultView(vgt, TotalHorz, TotalVert, 0, 0, 0, 0, 0, 0) ;
	    break ;
        }
      }
    else
        DefaultView(vgt, TotalHorz, TotalVert, 0, 0, 0, 0, 0, 0) ;

    if (Processor)
        GetIdleTimeCount() ;

    if (Memory)
	freemem(&total) ;
    
    if (Ethernet)
        GetEtherCount() ;

    etherscale = 50;
    while (1)
      {
        for (i=0; i<70; i++)
	  {
	    proc[i] = proc[i+5] ;
	    mem[i] = mem[i+5] ;
	    ether[i] = ether[i+5];
	  }
	for (i=0; i<(60/INTERVAL); i++)
	  {
	    int ethermax = 0;

	    if (! ValidPid(watchpid))
	         Quit() ;
	    if (Ethernet)
	      {
		register int j;
		int ethercount;

		for (j=0; j < INTERVAL; j++)
		  {
		    /* take the maximum over INTERVAL 1-second periods */
		    sleep(1);
		    if ((ethercount = GetEtherCount()) > ethermax)
		        ethermax = ethercount;
		  }
	      }
	    else
	        sleep(INTERVAL);
	    if (Processor) proc[70+i] = 100 - GetIdleTimeCount() ;
	    if (Memory) mem[70+i] = 1.0 - (freemem(0)*1.0) / (total*1.0) ;
	    if (Ethernet) ether[70+i] = ethermax ;
	  }
	EditSymbol(sdf, TOPITEM) ;
	if (Ethernet)
	  {
	    char scale[10];
	    int ethermax = ether[0];

	    for ( i = 1; i < 75; i++ )
		if (ether[i] > ethermax) ethermax = ether[i];
	
	    if ( EtherRescale( &etherscale, ethermax ) )
	      {
		sprintf( scale, "%d", etherscale/2 );
		DeleteItem(sdf, EtherBase+6);
		DeleteItem(sdf, EtherBase+7);
		AddItem(sdf, EtherBase+6,
		    EtherHorz+6, EtherHorz+20, EtherVert+62, EtherVert+67,
		    font, SDF_TEXT, scale);
		sprintf( scale, "%d", etherscale );
		AddItem(sdf, EtherBase+7,
		    EtherHorz+7, EtherHorz+15, EtherVert+112, EtherVert+117,
		    font, SDF_TEXT, scale);
	      }
	  }

        for (i = 0; i<75; i++)
          {
	    if (Memory)
	        ChangeItem(sdf, MemBase+20+i, MemHorz+20+i*2, MemHorz+21+i*2, MemVert+15, 
	           (int) (MemVert+15+mem[i]*100), 0, SDF_VERTICAL_LINE, NULL) ;
	    if (Processor)
	        ChangeItem(sdf, ProcBase+20+i, ProcHorz+20+i*2, ProcHorz+21+i*2, ProcVert+15, 
	           (int) (ProcVert+15+proc[i]), 0, SDF_VERTICAL_LINE, NULL) ;
	    if (Ethernet)
		ChangeItem(sdf, EtherBase+20+i,
			EtherHorz+20+i*2, EtherHorz+21+i*2, EtherVert+15, 
			EtherVert+15+(ether[i]*100)/etherscale,
			0, SDF_VERTICAL_LINE, NULL) ;
          }
	EndSymbol(sdf, TOPITEM, vgt) ;
      }
  }


Quit()
  {
	  DeleteVGT(vgt, 1) ;
	  DeleteSDF(sdf) ;
	  exit() ;
  }


unsigned
freemem(tot)
    int *tot ;
/* 
 *   unsigned freemem(tot)
 *        int *tot ;
 *
 *
 * freemem returns the no of free bytes in workstation.
 *
 * it expexts an integer pointer as argument. If this is nonnull
 * the total amount of memory in system is stored there.
 *
 */

  {
    static Message msg ;
    static ProcessId pid = 0 ;
    QueryKernelRequest *reqmsg = (QueryKernelRequest *) msg;
    MachineConfigurationReply *machreply =
    	(MachineConfigurationReply *) msg ;
    MemoryStatisticsReply *memreply  =
	(MemoryStatisticsReply *) msg ;
	
    if (pid==0)
        pid  =  Creator(0) ;
    if (tot) 
      {
        QueryKernel(pid,  MACHINE_CONFIG, machreply) ;
        *tot = machreply->fastMemory + machreply->slowMemory ;
      }

    QueryKernel(pid, MEMORY_STATS, memreply) ;
    
    return (memreply->unusedFastMemory + memreply->unusedSlowMemory) ;
  }



int GetIdleTimeCount()
  {
    unsigned newcount, newsecs, newticks  ;
    static unsigned oldcount, oldsecs, oldticks = 0 ;
    unsigned secs, ticks, count ;
    float factor ;
    static ProcessId idleprocess = 0 ;
    SystemCode QueryProcessorUsage( ) ;

    if (idleprocess == 0)
        idleprocess = Creator(0) & 0xFFFF0000 ;
    
    QueryProcessorUsage (idleprocess, &newcount, 0) ; 
    newsecs = GetTime(&newticks) ;
    /* do arithmetic in ticks and compute CurrentIdleTime as
     * counts per minute */
    if (newcount >= oldcount)
        count = newcount - oldcount ;
    else
        count = newcount + (0xFFFFFFFF - oldcount) ;
    if (newsecs >= oldsecs)
        secs = newsecs - oldsecs ;
    else
        secs = newsecs + (0xFFFFFFFF - oldsecs) ;
    if (newticks < oldticks)
      {
        secs++ ;
	ticks = newticks - oldticks + CLICKS_PER_SEC ;
      }
    else
        ticks = newticks - oldticks ;  
    factor = 100 / (secs*100.0 + ticks) ;
    factor = factor * count ;
    oldsecs = newsecs ;
    oldticks = newticks ;
    oldcount = newcount ;
    return (factor) ;
  }

frameBuffer()
  {
    static Message msg ;
    PeripheralConfigurationReply *pmsg =  (PeripheralConfigurationReply *) msg;
    int i ;
    
    QueryKernel(GetPid(0,0), PERIPHERAL_CONFIG, pmsg) ;
    if (pmsg->replycode != OK)
      return(0); 
    for (i=0; i<MAX_PERIPHERALS; i++)
        if ((pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN1) ||
                   (pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN2) ||
                   (pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN3))
            return(pmsg->peripheral[i]) ;
    return(0); 
  }


#include <Vnaming.h>

int GetEtherCount()
  {
    Message msg;
    register NameRequest *qerequest = (NameRequest *) msg;
    register QueryEnetReply *qereply = (QueryEnetReply *) msg;
    static ProcessId deviceProcess = 0;
    static unsigned oldPackets = 0;
    unsigned newPackets;

    if (deviceProcess == 0)
        deviceProcess = GetPid(DEVICE_SERVER, LOCAL_PID);

    qerequest->requestcode = NQUERY_FILE;
    qerequest->nameptr = "ethernet";
    qerequest->namelength = sizeof("ethernet");
    qerequest->nameindex = 0;
    qerequest->namecontextid = DEFAULT_CONTEXT;

    Send(qerequest, deviceProcess);
    if (qereply->replycode != OK)
        return(0);

    newPackets = qereply->NumValidPackets - oldPackets;
    oldPackets = qereply->NumValidPackets;
    return(newPackets);
  }

int EtherRescale( scale, emax )
int *scale;
int emax;
  {
    if ( *scale < emax )
      {
	while (*scale < emax ) *scale += 50;
	return( 1 );
      }
    if ( (emax < *scale-50 ) && (*scale > 50) )
      {
	while ( (emax < *scale-50) && (*scale > 50) ) *scale -= 50;
	return( 1 );
      }
    return( 0 );
  }
