#include <Venviron.h>
#include <stdio.h>
#include <Vgts.h>
#include <Vio.h>
#include <Vquerykernel.h>

#define MN 0
#define MH 10
#define MV 0

short Mvgt, Msdf ;
extern ProcessId Kernel_Process_Pid;
char Name[256];


main()
  {
    memwatch() ;
  }

watch()
  {
    Message msg ;
    
    while (1)
        Receive (msg) ;
  }


memwatch()
  {
    unsigned total, freem, freemem() ;
    float mem[75] ;
    int i ;
    ProcessId  watchpid ;
    int watch() ;
    SystemCode QueryWorkstationConfig();
    short font = DefineFont("Helvetica7", NULL ) ;
    short titlefont = DefineFont("Clarity12", NULL);

    if (QueryWorkstationConfig("name", Name, 80) != OK)
        strcpy(Name, "Status");
    strcat(Name, "                                                         ") ;
    /* catch break */
    watchpid = Create (100, watch, 512) ;
    Ready (watchpid, 0) ;
    SetBreakProcess (stdin, watchpid) ;

    font = DefineFont("Helvetica7", NULL ) ;
    
    Msdf = CreateSDF() ;
    DefineSymbol (Msdf, MN+1, "Memory") ;

    AddItem(Msdf, MN+2,  MH+10, MH+160, MV+15, MV+16, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
    AddItem(Msdf, MN+3,  MH+10, MH+160, MV+65, MV+66, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
    AddItem(Msdf, MN+4,  MH+10, MH+160, MV+115, MV+116, 
              0, SDF_HORIZONTAL_LINE, NULL) ;
    AddItem(Msdf, MN+5,  MH+3, MH+15, MV+12, MV+17, 
                 font, SDF_TEXT, "0") ;
    AddItem(Msdf, MN+6,  MH-3, MH+10, MV+62, MV+67,
                  font, SDF_TEXT, "50") ;
    AddItem(Msdf, MN+7,  MH-8, MH+5, MV+112, MV+117, 
                 font, SDF_TEXT, "100") ;
    AddItem(Msdf, MN+8, MH+10, MH+11, MV+12, MV+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
    AddItem(Msdf, MN+9, MH+60, MH+61, MV+12, MV+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
    AddItem(Msdf, MN+10, MH+110,MH+111, MV+12, MV+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
    AddItem(Msdf, MN+11, MH+160,MH+161, MV+12, MV+15, 
              0, SDF_VERTICAL_LINE, NULL) ;
    AddItem(Msdf, MN+12, MH+50, MH+61, MV+3, MV+10, 
                  font, SDF_TEXT, "-10") ;
    AddItem(Msdf, MN+13, MH+105,MH+116, MV+3, MV+10, 
                  font, SDF_TEXT, "-5") ;
    AddItem(Msdf, MN+14, MH+20, MH+50, MV+120, MV+125,
    		  titlefont, SDF_TEXT, "Memory");
    for (i=0; i<75; i++)
      {
        mem[i] = 0 ;
	AddItem(Msdf, MN+20+i, MH+10+i*2, MH+11+i*2, MV+15, 
	   (int) (MV+15+mem[i]*100), 0, SDF_VERTICAL_LINE, NULL) ;
      }
    
    EndSymbol(Msdf, MN+1,0) ;
    
    Mvgt = CreateVGT(Msdf, GRAPHICS+ZOOMABLE, MN+1, Name) ;

    i = frameBuffer() ;
    switch (i) {
      case PRF_FRAMEBUFFER_SUN1:
     	CreateView(  (int) Mvgt, 
    		  (short) 850, 		/*  sxmin          */
		  (short) 5,  		/*  symin          */
		  (short) 850+180,  	/*  sxmax          */
		  (short) 5+160,  	/*  symax          */
		  (short) 0,  		/*  wxmin          */
		  (short) 0,  		/*  wymin          */
		  (char) 0, 0) ; 	/*  zoom, showgrid */
	break ;

       case PRF_FRAMEBUFFER_SUN2:
     	CreateView(  (int) Mvgt, 
    		  (short) 982, 		/*  sxmin          */
		  (short) 5,  		/*  symin          */
		  (short) 982+180,  	/*  sxmax          */
		  (short) 5+160,  	/*  symax          */
		  (short) 0,  		/*  wxmin          */
		  (short) 0,  		/*  wymin          */
		  (char) 0, 0) ; 	/*  zoom, showgrid */
	break ;

      default:
     	DefaultView(Mvgt, 175, 150, 0, 0, 0, 0, 0, 0) ;
    }
    
    freemem(&total) ;
    
    while (1)
      {
        for (i=0; i<70; i++)
	  mem[i] = mem[i+5] ;
	for (i=0; i<5; i++)
	  {
	   if (! ValidPid(watchpid))
	         Quit() ;
	    sleep(12) ;
	    mem[70+i] = 1.0 - (freemem(0)*1.0) / (total*1.0) ;
	    /* printf("mem = %f\n", mem[29] ) ; */
	  }
	EditSymbol(Msdf, MN+1) ;
        for (i=0; i<75; i++)
          {
  	    ChangeItem(Msdf, MN+20+i, MH+10+i*2, MH+11+i*2, MV+15, 
	       (int) (MV+15+mem[i]*100), 0, SDF_VERTICAL_LINE, NULL) ;
          }
	EndSymbol(Msdf, MN+1, Mvgt) ;
      }
  }


Quit()
  {
	  DeleteVGT(Mvgt, 1) ;
	  DeleteSDF(Msdf) ;
	  exit( 0 ) ;
  }


unsigned
freemem(tot)
    int *tot ;
/* 
 *   unsigned freemem(tot)
 *        int *tot ;
 *
 *
 * freemem returns the no of free bytes in workstation.
 *
 * it expexts an integer pointer as argument. If this is nonnull
 * the total amount of memory in system is stored there.
 *
 */

  {
    static Message msg ;
    static ProcessId pid = 0 ;
    QueryKernelRequest *reqmsg = (QueryKernelRequest *) msg;
    MachineConfigurationReply *machreply =
    	(MachineConfigurationReply *) msg ;
    MemoryStatisticsReply *memreply  =
	(MemoryStatisticsReply *) msg ;
	
    if (pid==0)
        pid  =  Creator(0) ;
    if (tot) 
      {
        QueryKernel(pid,  MACHINE_CONFIG, machreply) ;
        *tot = machreply->fastMemory + machreply->slowMemory ;
      }

    QueryKernel(pid, MEMORY_STATS, memreply) ;
    
    return (memreply->unusedFastMemory + memreply->unusedSlowMemory) ;
  }


frameBuffer()
  {
    static Message msg ;
    PeripheralConfigurationReply *pmsg =  (PeripheralConfigurationReply *) msg;
    int i ;
    
    QueryKernel(GetPid(0,0), PERIPHERAL_CONFIG, pmsg) ;
    if (pmsg->replycode != OK)
      return(0); 
    for (i=0; i<MAX_PERIPHERALS; i++)
        if ((pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN1) ||
                   (pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN2)) 
            return(pmsg->peripheral[i]) ;
    return(0); 
  }
