/*
 * V Clock - Copyright (c) 1985 by Stanford University
 *
 * Author: Michael Stumm
 */
#include <Venviron.h>
#include <Vio.h>
#include <Vgts.h>
#include <sys/time.h>
#include <Vioprotocol.h>
#include <Vdirectory.h>
#include <Vnaming.h>
#include <Vquerykernel.h>
#include "splines.h"

#define PI 3.14159
#define MIN (short) 2
#define HR (short) 3
#define SEC (short) 4
#define SWISS 5
#define TIMING 6
#define CX 40


short sdf, vgt , font ;
int withsecs, mailcheck, notext ;
extern double sin(), cos() ;

initclock()
  {
    int i, x1, x2, y1, y2 ;
    double x, y ;

    if ((sdf = CreateSDF()) <= 0)
      {
        fprintf(stderr, "CreateSDF returns <=0\n") ;
	exit(1) ;
      }
    DefineSymbol (sdf, 1, "   Clock      ") ;
    x1 = 59 + 42 * 0 + 0.5 ;
    y1 = CX + 50 + 42 * 1 + 0.5 ;
    x2 = 59 + 50 * 0 + 0.5 ;
    y2 = CX + 50 + 50 * 1 + 0.5 ;
    AddItem (sdf, 0, x1, x2, y1, y2, 0, SDF_GENERAL_LINE, 0) ;
    x1 = 61 + 42 * 0 + 0.5 ;
    y1 = CX + 50 + 42 * 1 + 0.5 ;
    x2 = 61 + 50 * 0 + 0.5 ;
    y2 = CX + 50 + 50 * 1 + 0.5 ;
    AddItem (sdf, 0, x1, x2, y1, y2, 0, SDF_GENERAL_LINE, 0) ;
    for (i=5; i<60; i=i+5)
      {
        x = sin(i*PI/30) ;
        y = cos(i*PI/30) ;
	if (i%15)
	  {
            x1 = 60 + 45 * x + 0.5 ;
            y1 = CX+ 50 + 45 * y + 0.5;
            x2 = 60 + 50 * x + 0.5 ;
            y2 = CX + 50 + 50 * y + 0.5 ;
	  }
	else 
	  {
            x1 = 60 + 43 * x + 0.5 ;
            y1 = CX+ 50 + 43 * y + 0.5 ;
            x2 = 60 + 50 * x + 0.5 ;
            y2 = CX + 50 + 50 * y + 0.5 /* the 0.5 is for proper rounding */ ;
	  }
	AddItem (sdf, 0, x1, x2, y1, y2, 0, SDF_GENERAL_LINE, 0) ;
      } 
    if (! notext)
      {
    	if ((font = DefineFont("Helvetica7", NULL )) == 0)
    	  {
            fprintf(stderr, "DefineFont(\"Helvetica7\", NULL) returns 0\n") ;
	    DeleteSDF(sdf) ;
	    exit(1) ;
          }
      
    	/* add text "swiss timing" */
    	AddItem(sdf, SWISS, 50, 60, CX+70,  CX+75,
                  font, SDF_TEXT, "Swiss") ;
    	AddItem(sdf, TIMING, 48, 60, CX+28, CX+35,
                  font, SDF_TEXT, "Timing") ;
      }
    EndSymbol (sdf, 1, 0) ;
    if ((vgt = CreateVGT (sdf, GRAPHICS+ZOOMABLE, 1, "    Clock           "))
    	== 0) exit(1) ;
    i = frameBuffer() ;
    switch (i) {

      case PRF_FRAMEBUFFER_SUN1:
        CreateView(  (int) vgt, 
    		  (short) 900, 		/*  sxmin          */
		  (short) 570,  		/*  symin          */
		  (short) 900+120,  	/*  sxmax          */
		  (short) 570+133,  	/*  symax          */
		  (short) 0,  		/*  wxmin          */
		  (short) CX-5,  		/*  wymin          */
		  (char) 0, 0) ; 	/*  zoom, showgrid */
	break ;

       case PRF_FRAMEBUFFER_SUN3:
       case PRF_FRAMEBUFFER_SUN2:
        CreateView(  (int) vgt, 
    		  (short) 982, 		/*  sxmin          */
		  (short) 570,  		/*  symin          */
		  (short) 982+120,  	/*  sxmax          */
		  (short) 570+133,  	/*  symax          */
		  (short) 0,  		/*  wxmin          */
		  (short) CX-5,  		/*  wymin          */
		  (char) 0, 0) ; 	/*  zoom, showgrid */
	break ;

       case PRF_FRAMEBUFFER_QVSS:
        CreateView(  (int) vgt, 
    		  (short) 900, 		/*  sxmin          */
		  (short) 570,  		/*  symin          */
		  (short) 900+120,  	/*  sxmax          */
		  (short) 570+133,  	/*  symax          */
		  (short) 0,  		/*  wxmin          */
		  (short) CX-5,  		/*  wymin          */
		  (char) 0, 0) ; 	/*  zoom, showgrid */
	break ;
	
      default:
       DefaultView (vgt, 120, 133, 0, CX-5, 0, 0, 0, 0) ;
    }
  }


gettime (hr, mi, sec)
    int *hr, *mi, *sec ;
  {
    struct tm *trec ;
    long t ;
   
    t = time (0) ;   
    trec = localtime (&t) ;
    
    *hr = trec->tm_hour ;
    *mi = trec->tm_min ;
    *sec = trec->tm_sec ;
  }

updateclock()
  {
    DisplayItem (sdf, 1, vgt) ;
  }

AddHand(sdf, type, x1, x2, y1, y2)
    short sdf, type, x1, x2, y1, y2 ;
  {
    static SPLINE *sptr = (SPLINE *) 0 ;
    static POINT *vert ;
     if (sptr == (SPLINE *) 0)
       {
        if ((sptr = (SPLINE *) malloc (sizeof(SPLINE) + 2 * sizeof(POINT)))==0)
	  {
	    fprintf(stderr, "no memory\n") ;
	    exit (1) ;
	  }
      }
	sptr->order = 2 ;	/* Order of the spline			*/
	sptr->numvert = 2 ;	/* Number of vertices present.		*/
	sptr->border = 1 ;	/* Is the border visible?		*/
	sptr->closed = 0 ;	/* Is this object closed or open?	*/
	sptr->filled = 0 ;	/* Is this object filled?		*/
	sptr->opaque = 0 ;	/* Is the filling opaque (solid)?	*/
	sptr->pat = PatChainLink ;/* Fill (stipple) pattern.		*/
	vert =  &(sptr->head) ;	/* Head of the list of vertices		*/
    if (type==HR)      
	sptr->nib = NibCircle2;	/* Nib to be used for drawing.		*/
    else if (type == MIN)
	sptr->nib = NibCircle1;
    else 
	sptr->nib = NibCircle0;
    vert[0].x = x1 ;
    vert[0].y = y1 ;
    vert[1].x = x2 ;
    vert[1].y = y2 ; 
    
    EditSymbol (sdf, 1) ;
    if (InquireItem(sdf, type, 0,0,0,0,0,0,0))
        DeleteItem (sdf, type);
    AddItem (sdf, type, 0,0,0,0, 0,SDF_SPLINE, (char *) sptr) ;
    				/*	  SDF_GENERAL_LINE, 0) ;    */
    EndSymbol (sdf, 1, 0) ;
  }

updatesec (sec)
    int sec ;
  {
    short x1, x2, y1, y2 ;
    double x, y ;

    x = 45 * sin(sec*PI/30) ;
    y = 45 * cos(sec*PI/30) ;
    x1 = 60 - x/5 + 0.5 /* for proper rounding */ ;
    y1 = CX + 50 - y/5 + 0.5 /* for proper rounding */ ;
    x2 = 60 + x + 0.5 /* for proper rounding */ ;
    y2 = CX + 50 + y + 0.5 /* for proper rounding */ ;
    
    AddHand (sdf, SEC, x1, x2, y1, y2) ;
  }

updatemin(mi)
    int mi ;
  {
    short x1, x2, y1, y2 ;
    double x, y ;

    x = 49 * sin(mi*PI/30) ;
    y = 49 * cos(mi*PI/30) ;
    x1 = 60 - x/5 + 0.5 /* for proper rounding */ ;
    y1 = CX + 50 - y/5 + 0.5 /* for proper rounding */ ;
    x2 = 60 + x + 0.5 /* for proper rounding */ ;
    y2 = CX + 50 + y + 0.5 /* for proper rounding */ ;

    x1 -= y/50 ;
    x2 -= y/50 ;
    y1 -= x/50 ;
    y2 -= x/50 ;

    AddHand (sdf, MIN, x1, x2, y1, y2) ;
  }


updatehr(hr, mi)
    int hr, mi ;
  { 
    short x1, x2, y1, y2 ;
    double x, y, h ;

    h = hr; 
    h += ((double) mi) / 60 ;
    h *= 5 ;
    x = 30 * sin(h*PI/30) ;
    y = 30 * cos(h*PI/30) ;
    x1 = 60 - x/5 + 0.5 /* for proper rounding */ ;
    y1 = CX + 50 - y/5 + 0.5 /* for proper rounding */ ;
    x2 = 60 + x + 0.5 /* for proper rounding */ ;
    y2 = CX + 50 + y + 0.5 /* for proper rounding */ ;

    AddHand (sdf, HR, x1, x2, y1, y2) ;
  }

Message msg ;
char fname[10] ;
 	
main(argc, argv)
    int argc ;
    char *argv[] ;
  {
    int sec, mi, hr, i ;
    int cursec, curmi, curhr ;
    ProcessId  watchpid ;
    int watch() ;

    /* catch break */
    watchpid = Create (100, watch, 512) ;
    Ready (watchpid, 0) ;
    SetBreakProcess (stdin, watchpid) ;

    /* init */
    notext = withsecs = 0 ;
    while (--argc > 0) {
        argv++ ;
	if(argv[0][0] == '-') 
	    switch(argv[0][1]) {
		case 's':
				withsecs++ ;
				break ;
		case 't':
				notext++ ;
				break ;
		default:
				printf("Unknown flag %s\n", *argv) ;
				break;
	    }
      }
    initclock();
    cursec = curmi = curhr = 999 ;

    /* forever update clock */
    while (1) 
      {
	for (i=0; i < 60; i++)
	  {
            gettime (&hr, &mi, &sec) ;
            if (sec != cursec)
              {
                if (withsecs) updatesec(sec) ;
	        if (mi != curmi)
	          {
	            updatemin(mi) ;
	            curmi = mi ;
		    updatehr (hr, mi) ;
		    curhr = hr ;
		    if (! withsecs) updateclock() ;
	           }
	         if (withsecs) updateclock() ;
	      }
	     sleep(1) ;
	     if (! ValidPid(watchpid))
	         Quit() ;
	  }
	
      }
  }

Quit()
  {
    DeleteVGT(vgt, 1) ;
    DeleteSDF (sdf) ;
    exit(1) ;
  }

watch()
  {
    Message msg ;
    
    while (1)
        Receive (msg) ;
  }


frameBuffer()
  {
    static Message msg ;
    PeripheralConfigurationReply *pmsg =  (PeripheralConfigurationReply *) msg;
    int i ;
    
    QueryKernel(GetPid(0,0), PERIPHERAL_CONFIG, pmsg) ;
    if (pmsg->replycode != OK)
      return(0); 
    for (i=0; i<MAX_PERIPHERALS; i++)
        if ((pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN1) ||
                   (pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN2) ||
                   (pmsg->peripheral[i] == PRF_FRAMEBUFFER_SUN3) ||
                   (pmsg->peripheral[i] == PRF_FRAMEBUFFER_QVSS)
	       ) 
            return(pmsg->peripheral[i]) ;
    return(0); 
  }
