#include <Venviron.h>
#include <Vioprotocol.h>
#include <Vio.h>
#include <Vstorage.h>


main( argc, argv )
  int  argc;
  char *argv[];

  {
    register Message msg;
    register IoRequest *req = (IoRequest *) msg;
    register QueryStorageReply *reply = (QueryStorageReply *) msg;

    if( argc > 2 )
      {
        printf("Error on %s: Too many args.  Use: %s [-c]\n",
           argv[0], argv[0] );
        exit( 1 );
      }
    else if( argc > 1 )
      {
        if( strcmp( argv[1], "-c" ) != 0 )
          {
            printf("Error on %s: Bad argument.  Use: %s [-c]\n",
               argv[0], argv[0] );
            exit( 1 );
          }
      }
            

    req->requestcode = QUERY_STORAGE_STATS;
    Send( req, GetPid( VSTORAGE_SERVER, ANY_PID ) );

    if( reply->replycode != OK )
      {
        printf("Error on query: replycode = %s\n",
            ErrorString(reply->replycode));
        exit( 1 ); 
      }

    printf("Number of reads = %d\n",reply->NumReads);
    printf("Number of writes = %d\n",reply->NumWrites);
    printf("Numer of FD file reads = %d\n",reply->NumFDReads);
    printf("Average read length = %d\n",reply->AverageReadLength);
    printf("Average write length = %d\n",reply->AverageWriteLength);
    printf("Cylinders seeked per I/O = %d\n",reply->CylindersPerIO);
    printf("Buffer Hit Rate = %5.2f\n",reply->BufferHitRate);

    if( argc > 1 )
      {
        req->requestcode = MODIFY_STORAGE_STATS;
        Send( req, GetPid( VSTORAGE_SERVER, ANY_PID ) );

        if( reply->replycode != OK )
          {
            printf("Error on modify: replycode = %s\n",
               ErrorString(reply->replycode));
            exit( 1 );
          }
      }

  }

    