/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Print out a name descriptor in an aesthetically pleasing format.
 */

#include <Vioprotocol.h>
#include <Vnaming.h>
#include <Vgts.h>
#include <Vdirectory.h>
#include <Vstorage.h>
 
char *DescriptorName(desc)
    register ArbitraryDescriptor *desc;
/*
 * Return a pointer to the character string name of the descriptor passed in.
 */
  {
    unsigned short mode, i;

    switch (desc->e.descriptortype)
      {
	case EMPTY_DESCRIPTOR: return(0);
	case FILE_DESCRIPTOR: return(desc->f.name ); 
	case TEAM_DESCRIPTOR: return(desc->t.fileName);
	case HOST_DESCRIPTOR: return(desc->h.hostName);
	case DEVICE_DESCRIPTOR: return(desc->d.name);
	case UNIXFILE_DESCRIPTOR: return(desc->u.name );
	case VGT_DESCRIPTOR: return(desc->v.name);
      }
    return( 0 );
  } /* Name */

