/*
 * rm.c
 * Remove files from a storage server
 */

#include <Vio.h>

main(argc, argv)
    int argc;
    char **argv;
  {
    SystemCode code, error;
    int i, n, m;
    int fflag = 0;

    if (argc < 2)
      {
	fprintf(stderr, "Usage: %s file1 file2 ... \n", argv[0]);
	exit(1);
      }
    for (n = 1; argv[n][0] == '-'; n++)
      {
	/* Process options. */
	for (m = 1; argv[n][m] != '\0'; m++)
	  {
	    switch (argv[n][m])
	      {
		case 'f':
		    fflag = 1;
		    break;
		default:
		    fprintf(stderr, "Option -%c not understood.\n", 
		    		argv[n][m]);
		    exit(1);
	      }
	  }
      }
    if ((argc - n) < 1)
      {
	fprintf(stderr, "Usage: %s file1 file2 ... \n", argv[0]);
	exit(1);
      }

    error = OK;

    for (i = n; i < argc; i++)
      {
	code = RemoveFile(argv[i]);
	if ((!fflag) && (code != OK))
	  {
	    fprintf(stderr, "%s: %s: %s\n", argv[0], argv[i], 
		ErrorString(code));
	    error = code;
	  }
      }

    exit(error);
  }
