/*
 *	A user program for querying various aspects of the system.
 *
 *		Ross Finlayson, June 1984.
 */

/* Imports: */
extern Qkernel();
extern QConfig();
extern QEthernet();


main(argc, argv)
    int argc;
    char *argv[];
  {
    /* Look through the command line options, to see what to query. */
    if ( argc == 1 )
      {
	/* Query the default things. */
	QKernel();
	QConfig();
      }
    while ( --argc > 0 )
      {
	char *thisOption = *++argv;
	
	/* Ignore leading hyphens (they aren't necessary). */
	while ( *thisOption == '-')
	    ++thisOption;

	Upper(thisOption);

	/* Check for the options that we know about. */
	if ( Equal(thisOption, "HELP") || (thisOption[0] == '?') )
	    QHelp();
	else if ( Equal(thisOption, "KERNEL") )
	    QKernel();
	else if ( Equal(thisOption, "CONFIG") )
	    QConfig();
	else if ( Equal(thisOption, "ETHERNET") )
	    QEthernet();
	else
	  {
	    printf("Unknown option: %s\n", thisOption);
	    QHelp();
	  }
      }
  }


QHelp()
    /* Prints out the possible options for the command. */
  {
    printf("Possible options are: kernel, config, ethernet.\n");
    printf("Default options are: kernel, config.\n");
  }