#include <Venviron.h>
#include <Vquerykernel.h>
#include "search.h"

/* Exports:	QKernel().	*/

/* Imports: */
extern Describe(), DescribeMemory();
extern char *Lookup();

#include "qkernel.h"


QKernel()
    /* Prints out the result of invoking the QueryKernel operation. */
  {
    Message msg;
    QueryKernelRequest *request = (QueryKernelRequest *)msg;
    MachineConfigurationReply *mcReply = (MachineConfigurationReply *)msg;
    PeripheralConfigurationReply *pcReply = (PeripheralConfigurationReply *)msg;
    MemoryStatisticsReply *msReply = (MemoryStatisticsReply *)msg;
    KernelConfigurationReply *kcReply = (KernelConfigurationReply *)msg;
    KernelStatisticsReply *ksReply = (KernelStatisticsReply *)msg;

    char firstPeripheral = 1;	/* Boolean flag */
    char slowMemory = 0;	/* ditto */
    char *stringVal;
    register i;
    
    printf("Querying kernel:\n");
    

    /* Machine Configuration */
    printf("    Machine configuration:\n");
    QueryKernel(0, MACHINE_CONFIG, mcReply);
    Describe("	Machine", mcReply->machine, mcMachineEntries);
    Describe("	Processor", mcReply->processor, mcProcessorEntries);
    DescribeMemory("	Memory", mcReply->memory);
    if (mcReply->fastMemory != mcReply->memory)
      {
	slowMemory = 1;
	DescribeMemory("	    fast", mcReply->fastMemory);
	DescribeMemory("	    slow", mcReply->slowMemory);
      }
    /* don't bother printing "confreg". */


    /* Peripheral Configuration */
    printf("    Peripherals: ");
    QueryKernel(0, PERIPHERAL_CONFIG, pcReply);
    for (i = 0; i < MAX_PERIPHERALS; ++i)
        if (pcReply->peripheral[i] != PRF_NONE)
	  {
	    if (!firstPeripheral)
	        printf(", ");
	    stringVal = Lookup(pcReply->peripheral[i], pcPeripheralEntries);
	    printf("%s", stringVal ? stringVal : "???");
	    firstPeripheral = 0;
	  }
    printf("\n");


    /* Memory Statistics */
    printf("    Memory statistics:\n");
    QueryKernel(0, MEMORY_STATS, msReply);
    if (slowMemory)
      {
	DescribeMemory("	Unused fast memory", msReply->unusedFastMemory);
	DescribeMemory("	Unused slow memory", msReply->unusedSlowMemory);
      }
    else
	DescribeMemory("	Unused memory", msReply->unusedFastMemory);


    /* Kernel Configuration */
    printf("    Kernel configuration:\n");
    QueryKernel(0, KERNEL_CONFIG, kcReply);
    Describe("	IKC", kcReply->ikcType, kcIkcEntries);
    printf("	Version #%d\n", kcReply->versionNumber);
    printf("	Max. processes = %d\n", kcReply->maxProcesses);
    printf("	Max. teams = %d\n", kcReply->maxTeams);
    Describe("	Virtual memory", kcReply->vmConfig, kcVmEntries);
    /* don't bother printing "rootPriority", "maxLogicalId", "initStack". */


    /* Kernel Statistics */
    printf("    Kernel statistics:\n");
    QueryKernel(0, KERNEL_STATS, ksReply);
    printf("	%d free process descriptors\n", ksReply->freePds);
    printf("	%d free team descriptors\n", ksReply->freeTds);
    /* don't bother printing "alienCount", "delayQueueHead". */

  }
