#include "search.h"

/* Exports:	Describe(), DescribeMemory().	*/

/* Imports: */
extern char *Lookup();

Describe(printString, value, table)
    /* Invokes "Lookup" to look up "value" in the search table "table",
     * printing out the corresponding description if it is found.
     */
    char *printString;
    unsigned value;
    SearchTableEntry table[];
  {
    char *description;

    description = Lookup(value, table);
    if (description != 0)
        printf("%s: %s\n", printString, description);
    else
	printf("%s: ??? (code = 0x%x)\n", printString, value);
  }


DescribeMemory(printString, numBytes)
    /* Prints out in human-readable form (preceded by "printString") the memory
     * size given by "numBytes"
     */
    char *printString;
    unsigned long numBytes;
  {
    /* Special case: numBytes == 0. */
    if (numBytes == 0)
        printf("%s: 0 ", printString);
    else
	printf("%s: 0x%x = ", printString, numBytes);

    /* 'Giga'bytes (wishful thinking) */
    if (numBytes >= 0x40000000)
        printf("%dG ", numBytes>>30);

    /* 'Mega'bytes */
    if ((numBytes &= 0x3fffffff) >= 0x100000)
        printf("%dM ", numBytes>>20);

    /* 'Kilo'bytes */
    if ((numBytes &= 0xfffff) >= 0x400)
        printf("%dK ", numBytes>>10);

    /* bytes */
    if ((numBytes &= 0x3ff) > 0)
        printf("%d ", numBytes);
    printf("bytes\n");
  }
