/*
 *  scale.c
 *
 *  This file contains the routines necessary to perform the 'scale'
 *  operation, which will scale an object on the screen, and as a side
 *  effect raise it to the top of the display list.  Scaling text will
 *  not scale individual characters -- it will just move the string.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern double sqrt();
extern ScaleObject();
extern Checkpoint();
extern RedrawActivelist();
extern short SelectObject();
 
 
/* Exports */
extern ActScale();
 
 
/* Local Definitions */
static POINT_DATA prompts[] =
  {
    { "Enter the fixed point of the scaling.", 0,0,0, },
    { "Enter a point at the initial distance from the fixed point.", 0,0,0, },
    { "Enter a point at the scaled distance from the fixed point.", 0,0,0, },
  };

/*
 *  This routine is the main driver for the scale command.  It will
 *  call SelectObject() to get the user to pick an object to be scaled.
 *  Using CAlmostDone to confirm will permit multiple objects to be
 *  scaled, in the order specified.
 */
 
ActScale( cmd )
	enum MenuOptions cmd;
  {
    double factor;
    short dx1, dx2, dy1, dy2;
    short selected, p1, p2, scaling;
    ITEM_LIST_PTR *victim;
    register ITEM_LIST_PTR *p, *pnext, *pstop;
    
    /* Make ready */
    Checkpoint();
    scaling = 1;
    p1 = 0;  p2 = -1;
    
    /* Loop, doing the work. */
    while (scaling)
      {
	scaling = SelectObject( &victim, cmd, &p1, &p2,
		"SCALE:  Select an object type.", &selected, 0,
		3, prompts );
	cmd = CNull;
	
	/* Did the user Abort? */
	if (selected == 2)
	  {
	    scaling = 0;
	    break;
	  }
	
	/* Something was selected. */
	dx1 = prompts[1].x - prompts[0].x;
	dy1 = prompts[1].y - prompts[0].y;
	dx2 = prompts[2].x - prompts[0].x;
	dy2 = prompts[2].y - prompts[0].y;
	if ((dx2 == 0) && (dy2 == 0))
	  {
	    printf("Scale factor is undefined with those points.\n\r");
	    factor = (double) 1.0;
	  }
	else
	  {
	    factor = sqrt( (double) ((dx2 * dx2) + (dy2 * dy2)) ) /
		sqrt( (double) ((dx1 * dx1) + (dy1 * dy1)) );
	  }
	if (selected)
	  {
	    /* Everything was selected. */
	    p = activelist->prev;
	    pstop = activelist->next;
	    while (p)
	      {
		pnext = p->next;
		ScaleObject( p, factor, prompts[0].x, prompts[0].y, 0, 1 );
		if (p == pstop)
		    break;
		p = pnext;
	      }
	    
	    /* Redisplay Everything. */
	    RedrawActivelist( 1 );
	  }
	else if (victim)
	  {
	    /* Scale one object */
	    ScaleObject( victim, factor, prompts[0].x, prompts[0].y, 1, 1 );
	  }
      }
  }
