/*
 *  save.c
 *
 *  This file contains the code the deal with saving a file to disk.
 *
 * Split off from Perm.c by Gus Fernandez 4/11/85
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern Quit();
extern DebugObjectList();
extern GetMisc();
extern char *GetString();
extern RedrawActivelist();
extern EraseObject();
extern Checkpoint();
 
/* Exports */
extern WriteFile();
 
/* Local Definitions */
# define tolower(c)	(((c >= 'A') && (c <= 'Z')) ? (c - 'A' + 'a') : c)
# define SILHEADER	034562	/* SIL format header (password) */
# ifdef VAX
# define File FILE		/* Make files work on both machines */
# endif

/*
 *  This internal routine is a helper process for WriteFile().  This
 *  routine will scan the activelist, and print the description of
 *  each object the first time it is encountered.
 */
 
ScanWrite( fp, ptr, cnt )
	File *fp;
	ITEM_DESCRIPTOR *ptr;
	short *cnt;
  {
    short i;
    ITEM_LIST_PTR *p;
    SPLINE *sptr;
    POINT *pptr;
    
    /* Stop when we run out of data. */
    if (ptr == NULL)
	return;
    
/*    if (ptr->filnum == 0) */
      {	
	/* Print new items, numbering them as we go. */
	ptr->filnum = ++(*cnt);
	fprintf( fp, "%d\n", ptr->filnum );
	fprintf( fp, "%d %d %d %d %d %d %d %d\n",
		ptr->type, ptr->subtype, ptr->typedata,
		ptr->xmin, ptr->xmax, ptr->ymin, ptr->ymax, ptr->base );
	switch (ptr->type)
	  {
	    case TextObj:
	        /* Text.  Print the text string. */
		fprintf(fp,"%d %s\n",strlen(ptr->data),ptr->data);
		break;
	    
	    case GroupObj:
	        /* Groups.  Print the group name, and its items. */
		for (i = 0; i <= MAXLEN; i++)
		    putc( ptr->name[i], fp );
		fprintf( fp, "\n" );
		p = (ITEM_LIST_PTR *) ptr->data;
		while (p)
		  {
		    fprintf( fp, "%d %d ", p->dx, p->dy );
		    ScanWrite( fp, p->itemdesc, cnt );
		    p = p->next;
		  }
		fprintf( fp, "-1 -1 -1\n" );
		break;
	    
	    default:
	        /* Splines.  Print the spline data. */
		sptr = (SPLINE *) ptr->data;
		fprintf( fp, "%d %d %d %d %d %d %d %d\n",
			sptr->order, sptr->numvert, sptr->nib, sptr->border,
			sptr->closed, sptr->filled, sptr->opaque, sptr->pat );
		pptr = &(sptr->head);
		for (i = 0; i < sptr->numvert; i++)
		    fprintf( fp, "    %d %d\n", pptr[i].x, pptr[i].y );
		break;
	  }
      }
/*    else
	fprintf( fp, "%d\n", ptr->filnum ); */
  }

/*
 *  This internal routine will write the activelist into a file.
 */
 
WriteFile()
  {
    short count;		/* Reachable item count */
    char *fname;
    File *fp, *fopen();
    ITEM_DESCRIPTOR *id;
    ITEM_LIST_PTR *p;
    
    /* Discard ridiculous cases */
    if ((activelist->prev == NULL) || (itemlist == NULL))
      {
	printf("There is no point to writing an empty file.\n\r");
	return;
      }
    
    /* Get the file */
    printf("Output file name?  ");
    if ((fname = GetString()) == NULL)
      {
	printf("Write File Aborted.\n\r");
	return;
      }
    if ((fp = fopen( fname, "w" )) == NULL)
      {
	printf("Error:  Couldn't open file '%s'.\n\r", fname);
	printf("Write File Aborted.\n\r");
	free( fname );
	return;
      }
    printf("Writing file '%s', please wait .", fname );
    fputs( FILEHEADER, fp );
    
    /* We have a file to write.  Reset all of the file numbers. */
    if (Debug)
	printf("Resetting file numbers in itemlist.\n\r");
    id = itemlist;
    while (id)
      {
	id->filnum = 0;
	id = id->prev;
      }
    
    /* Scan and print all of the items referenced by the activelist. */
    printf(".");
    if (Debug)
	printf("Doing real work.\n\r");
    count = 0;
    for ( p = activelist->prev; p; p = p->next )
      {
	fprintf( fp, "%d %d ", p->dx, p->dy );
	ScanWrite( fp, p->itemdesc, &count );
      }
    fprintf( fp, "-1 -1 -1\n" );
    
    /* Close the file and finish up. */
    fclose( fp );
    free( fname );
    printf(". done.\n\r");
    modified = 0;
  }
