/*
 *  rotate.c
 *
 *  This file contains the routines necessary to perform the 'rotate'
 *  operation, which will rotate an object on the screen, and as a side
 *  effect raise it to the top of the display list.  Rotating text will
 *  rotate individual characters -- it will just move the string.
 *
 *  David Kaelbling, May 1983
 */
 
 
/* Includes */
# ifdef VAX
# include "stdio.h"
# else
# include "Vio.h"
# endif
# include "Vgts.h"
# include "splines.h"
# include "draw.h"
 
 
/* Imports */
extern double atan2();
extern RotateObject();
extern Checkpoint();
extern RedrawActivelist();
extern short SelectObject();
 
 
/* Exports */
extern ActRotate();
 
 
/* Local Definitions */
# define PI 3.1415926535
static POINT_DATA prompts[] =
  {
    { "Enter the fixed point of the rotation.", 0, 0, 0, },
    { "Enter the starting point of the rotation.", 0, 0, 0, },
    { "Enter the ending point of the rotation.", 0, 0, 0, },
  };

/*
 *  This routine is the main driver for the rotate command.  It will
 *  call SelectObject() to get the user to pick an object to be rotated.
 *  Using CAlmostDone to confirm will permit multiple objects to be
 *  rotated, in the order specified.
 */
 
ActRotate( cmd )
	enum MenuOptions cmd;
  {
    double theta;
    short selected, p1, p2, rotating;
    ITEM_LIST_PTR *victim;
    register ITEM_LIST_PTR *p, *pnext, *pstop;
    
    /* Make ready */
    Checkpoint();
    rotating = 1;
    p1 = 0;  p2 = -1;
    
    /* Loop, doing the work. */
    while (rotating)
      {
	rotating = SelectObject( &victim, cmd, &p1, &p2,
		"ROTATE:  Select an object type.", &selected, 0,
		3, prompts );
	cmd = CNull;
	
	/* Did the user Abort? */
	if (selected == 2)
	  {
	    rotating = 0;
	    break;
	  }
	
	/* Something was selected. */
	theta = atan2( (double) (prompts[2].x - prompts[0].x),
			(double) (prompts[2].y - prompts[0].y) ) -
		atan2( (double) (prompts[1].x - prompts[0].x),
			(double) (prompts[1].y - prompts[0].y) ) +
		(2 * PI) ; 
	while (theta > PI)
	    theta -= (2 * PI);
	if (selected)
	  {
	    /* Everything was selected. */
	    p = activelist->prev;
	    pstop = activelist->next;
	    while (p)
	      {
		pnext = p->next;
		RotateObject( p, theta, prompts[0].x, prompts[0].y, 0, 1 );
		if (p == pstop)
		    break;
		p = pnext;
	      }
	    
	    /* Redisplay Everything. */
	    RedrawActivelist( 1 );
	  }
	else if (victim)
	  {
	    /* Rotate one object */
	    RotateObject( victim, theta, prompts[0].x, prompts[0].y, 1, 1 );
	  }
      }
  }
